/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchGroup;
import com.maddyhome.idea.vim.api.VimSearchGroupBase;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.SearchHelperKtKt;
import com.maddyhome.idea.vim.helper.SearchHighlightsHelper;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.newapi.IjVimDocument;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.GlobalOptionChangeListener;
import com.maddyhome.idea.vim.options.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="VimSearchSettings", storages={@Storage(value="$APP_CONFIG$/vim_settings_local.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 -2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0003-./B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0014J\b\u0010\u0011\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0014J\b\u0010\u0016\u001a\u00020\tH\u0017J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0014J\b\u0010\u001b\u001a\u00020\tH\u0016J\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003J\"\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J\u000e\u0010\"\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003J\u001a\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010#\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0003H\u0016J\u000e\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup;", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "showSearchHighlight", "", "highlightSearchLines", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "startLine", "", "endLine", "updateSearchHighlights", "force", "resetIncsearchHighlights", "addSubstitutionConfirmationHighlight", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;", "startOffset", "endOffset", "resetState", "isSomeTextHighlighted", "getCurrentIncsearchResultRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "setShouldShowSearchHighlights", "clearSearchHighlight", "saveData", "element", "addOptionalTextElement", "name", "", "text", "readData", "getSafeChildText", "defaultValue", "getState", "loadState", "state", "fileEditorManagerSelectionChangedCallback", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "turnOn", "turnOff", "Companion", "IjSearchHighlight", "DocumentSearchListener", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nIjVimSearchGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjVimSearchGroup.kt\ncom/maddyhome/idea/vim/newapi/IjVimSearchGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,309:1\n774#2:310\n865#2,2:311\n1#3:313\n39#4:314\n*S KotlinDebug\n*F\n+ 1 IjVimSearchGroup.kt\ncom/maddyhome/idea/vim/newapi/IjVimSearchGroup\n*L\n114#1:310\n114#1:311,2\n47#1:314\n*E\n"})
public class IjVimSearchGroup
extends VimSearchGroupBase
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean showSearchHighlight;
    @NotNull
    private static final Lazy<VimLogger> logger$delegate = LazyKt.lazy(IjVimSearchGroup::logger_delegate$lambda$0);

    public IjVimSearchGroup() {
        VimPlugin.getOptionGroup().addGlobalOptionChangeListener((Option)Options.INSTANCE.getHlsearch(), () -> IjVimSearchGroup._init_$lambda$0(this));
        GlobalOptionChangeListener updateHighlightsIfVisible = () -> IjVimSearchGroup._init_$lambda$1(this);
        VimPlugin.getOptionGroup().addGlobalOptionChangeListener((Option)Options.INSTANCE.getIgnorecase(), updateHighlightsIfVisible);
        VimPlugin.getOptionGroup().addGlobalOptionChangeListener((Option)Options.INSTANCE.getSmartcase(), updateHighlightsIfVisible);
        this.showSearchHighlight = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getHlsearch();
    }

    public void highlightSearchLines(@NotNull VimEditor editor, int startLine, int endLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String pattern = this.getLastUsedPattern();
        if (pattern != null) {
            List results = VimInjectorKt.getInjector().getSearchHelper().findAll(editor, pattern, startLine, endLine, SearchHelperKtKt.shouldIgnoreCase(pattern, VimSearchGroupBase.getLastIgnoreSmartCase()));
            SearchHighlightsHelper.highlightSearchResults(IjVimEditorKt.getIj(editor), pattern, results, -1);
        }
    }

    protected void updateSearchHighlights(boolean force) {
        SearchHighlightsHelper.updateSearchHighlights(this.getLastUsedPattern(), VimSearchGroupBase.getLastIgnoreSmartCase(), this.showSearchHighlight, force);
    }

    public void resetIncsearchHighlights() {
        SearchHighlightsHelper.updateSearchHighlights(this.getLastUsedPattern(), VimSearchGroupBase.getLastIgnoreSmartCase(), this.showSearchHighlight, true);
    }

    @NotNull
    protected VimSearchGroupBase.SearchHighlight addSubstitutionConfirmationHighlight(@NotNull VimEditor editor, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor ijEditor = ((IjVimEditor)editor).getEditor();
        RangeHighlighter highlighter = SearchHighlightsHelper.addSubstitutionConfirmationHighlight(ijEditor, startOffset, endOffset);
        return new IjSearchHighlight(ijEditor, highlighter);
    }

    @TestOnly
    public void resetState() {
        super.resetState();
        this.showSearchHighlight = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getHlsearch();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSomeTextHighlighted() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VimEditor it = (VimEditor)element$iv$iv;
            boolean bl = false;
            if (!(VimInjectorKt.getInjector().getApplication().isUnitTest() || IjVimEditorKt.getIj(it).getComponent().isShowing())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List vimEditors = (List)destination$iv$iv;
        for (VimEditor vimEditor : vimEditors) {
            Editor editor = IjVimEditorKt.getIj(vimEditor);
            if (UserDataManager.getVimLastHighlighters(editor) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public TextRange getCurrentIncsearchResultRange(@NotNull VimEditor editor) {
        RangeHighlighter currentHighlighter;
        RangeHighlighter rangeHighlighter;
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Editor ijEditor = IjVimEditorKt.getIj(editor);
            Collection<RangeHighlighter> collection = UserDataManager.getVimLastHighlighters(ijEditor);
            if (collection == null) {
                return null;
            }
            Collection<RangeHighlighter> incsearchHighlighters = collection;
            Integer n = UserDataManager.getVimIncsearchCurrentMatchOffset(ijEditor);
            if (n == null) {
                return null;
            }
            int currentOffset = n;
            Iterable iterable = incsearchHighlighters;
            for (Object t : iterable) {
                RangeHighlighter it = (RangeHighlighter)t;
                boolean bl = false;
                if (!(it.getStartOffset() == currentOffset)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        return (rangeHighlighter = (currentHighlighter = (RangeHighlighter)v2)) != null && (rangeHighlighter = rangeHighlighter.getTextRange()) != null ? IjVimEditorKt.getVim((com.intellij.openapi.util.TextRange)rangeHighlighter) : null;
    }

    protected void setShouldShowSearchHighlights() {
        this.showSearchHighlight = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getHlsearch();
    }

    public void clearSearchHighlight() {
        this.showSearchHighlight = false;
        this.updateSearchHighlights(false);
    }

    public final void saveData(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IjVimSearchGroup.Companion.getLogger().debug("saveData");
        Element search = new Element("search");
        this.addOptionalTextElement(search, "last-search", this.getLastSearchPattern());
        this.addOptionalTextElement(search, "last-substitute", this.getLastSubstitutePattern());
        this.addOptionalTextElement(search, "last-offset", VimSearchGroupBase.Companion.getLastPatternTrailing());
        this.addOptionalTextElement(search, "last-replace", VimSearchGroupBase.Companion.getLastReplaceString());
        this.addOptionalTextElement(search, "last-pattern", VimSearchGroupBase.Companion.getLastPatternType() == VimSearchGroupBase.PatternType.SEARCH ? this.getLastSearchPattern() : this.getLastSubstitutePattern());
        this.addOptionalTextElement(search, "last-dir", String.valueOf(this.getLastSearchDirection().toInt()));
        this.addOptionalTextElement(search, "show-last", String.valueOf(this.showSearchHighlight));
        element.addContent(search);
    }

    private final void addOptionalTextElement(Element element, String name, String text) {
        if (text != null) {
            element.addContent(VimPlugin.getXML().setSafeXmlText(new Element(name), text));
        }
    }

    public final void readData(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IjVimSearchGroup.Companion.getLogger().debug("readData");
        Element element2 = element.getChild("search");
        if (element2 == null) {
            return;
        }
        Element search = element2;
        this.setLastSearchPattern(this.getSafeChildText(search, "last-search"));
        this.setLastSubstitutePattern(this.getSafeChildText(search, "last-substitute"));
        VimSearchGroupBase.Companion.setLastReplaceString(this.getSafeChildText(search, "last-replace"));
        VimSearchGroupBase.Companion.setLastPatternTrailing(this.getSafeChildText(search, "last-offset", ""));
        String lastPatternText = this.getSafeChildText(search, "last-pattern");
        if (lastPatternText == null || Intrinsics.areEqual((Object)lastPatternText, (Object)this.getLastSearchPattern())) {
            VimSearchGroupBase.Companion.setLastPatternType(VimSearchGroupBase.PatternType.SEARCH);
        } else {
            VimSearchGroupBase.Companion.setLastPatternType(VimSearchGroupBase.PatternType.SUBSTITUTE);
        }
        Element dir = search.getChild("last-dir");
        try {
            String string = dir.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            VimSearchGroupBase.Companion.setLastDirection(Direction.Companion.fromInt(Integer.parseInt(string)));
        }
        catch (NumberFormatException e) {
            VimSearchGroupBase.Companion.setLastDirection(Direction.FORWARDS);
        }
        Element show = search.getChild("show-last");
        boolean disableHighlight = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getViminfo().contains((Object)"h");
        boolean bl = this.showSearchHighlight = !disableHighlight && Boolean.parseBoolean(show.getText());
        if (IjVimSearchGroup.Companion.getLogger().isDebug()) {
            IjVimSearchGroup.Companion.getLogger().debug("show=" + show + "(" + show.getText() + ")");
            IjVimSearchGroup.Companion.getLogger().debug("showSearchHighlight=" + this.showSearchHighlight);
        }
    }

    private final String getSafeChildText(Element element, String name) {
        Element child = element.getChild(name);
        return child != null ? VimPlugin.getXML().getSafeXmlText(child) : null;
    }

    private final String getSafeChildText(Element element, String name, String defaultValue) {
        Element child = element.getChild(name);
        if (child != null) {
            String value = VimPlugin.getXML().getSafeXmlText(child);
            String string = value;
            if (string == null) {
                string = defaultValue;
            }
            return string;
        }
        return defaultValue;
    }

    @Nullable
    public Element getState() {
        Element element = new Element("search");
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.readData(state);
    }

    public final void fileEditorManagerSelectionChangedCallback(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateSearchHighlights(false);
    }

    public final void turnOn() {
        this.updateSearchHighlights(false);
    }

    public final void turnOff() {
        boolean show = this.showSearchHighlight;
        this.clearSearchHighlight();
        this.showSearchHighlight = show;
    }

    private static final void _init_$lambda$0(IjVimSearchGroup this$0) {
        this$0.setShouldShowSearchHighlights();
        this$0.updateSearchHighlights(true);
    }

    private static final void _init_$lambda$1(IjVimSearchGroup this$0) {
        if (this$0.showSearchHighlight) {
            this$0.updateSearchHighlights(true);
        }
    }

    private static final VimLogger logger_delegate$lambda$0() {
        boolean $i$f$vimLogger = false;
        return VimInjectorKt.getInjector().getLogger(IjVimSearchGroup.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "logger$delegate", "Lkotlin/Lazy;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        private final VimLogger getLogger() {
            Lazy lazy = logger$delegate;
            return (VimLogger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$DocumentSearchListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "()V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "Companion", "IdeaVIM"})
    public static final class DocumentSearchListener
    implements DocumentListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static DocumentSearchListener INSTANCE = new DocumentSearchListener();

        @Contract(pure=true)
        private DocumentSearchListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            for (VimEditor vimEditor : VimInjectorKt.getInjector().getEditorGroup().getEditors((VimDocument)new IjVimDocument(document2))) {
                LogicalPosition endPosition;
                LogicalPosition startPosition;
                Collection<RangeHighlighter> existingHighlighters;
                Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.newapi.IjVimEditor");
                Editor editor = ((IjVimEditor)vimEditor).getEditor();
                if (UserDataManager.getVimLastHighlighters(editor) == null) continue;
                if (Companion.getLogger().isDebug()) {
                    Companion.getLogger().debug("hls=" + existingHighlighters);
                    Companion.getLogger().debug("event=" + event);
                }
                Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToLogicalPosition(event.getOffset()), (String)"offsetToLogicalPosition(...)");
                Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToLogicalPosition(event.getOffset() + event.getNewLength()), (String)"offsetToLogicalPosition(...)");
                int startLineOffset = document2.getLineStartOffset(startPosition.line);
                int endLineOffset = document2.getLineEndOffset(endPosition.line);
                Iterator<RangeHighlighter> iter = existingHighlighters.iterator();
                while (iter.hasNext()) {
                    RangeHighlighter highlighter = iter.next();
                    if (!highlighter.isValid()) {
                        iter.remove();
                        continue;
                    }
                    if (!highlighter.getTextRange().intersects(startLineOffset, endLineOffset)) continue;
                    iter.remove();
                    editor.getMarkupModel().removeHighlighter(highlighter);
                }
                VimSearchGroup vimSearchGroup = VimInjectorKt.getInjector().getSearchGroup();
                Intrinsics.checkNotNull((Object)vimSearchGroup, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.VimSearchGroupBase");
                ((VimSearchGroupBase)vimSearchGroup).highlightSearchLines(IjVimEditorKt.getVim(editor), startPosition.line, endPosition.line);
                if (!Companion.getLogger().isDebug()) continue;
                Collection<RangeHighlighter> collection = UserDataManager.getVimLastHighlighters(editor);
                Intrinsics.checkNotNull(collection);
                existingHighlighters = collection;
                Companion.getLogger().debug("sl=" + startPosition.line + ", el=" + endPosition.line);
                Companion.getLogger().debug("hls=" + existingHighlighters);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$DocumentSearchListener$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$DocumentSearchListener;", "getINSTANCE", "()Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$DocumentSearchListener;", "setINSTANCE", "(Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$DocumentSearchListener;)V", "IdeaVIM"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DocumentSearchListener getINSTANCE() {
                return INSTANCE;
            }

            public final void setINSTANCE(@NotNull DocumentSearchListener documentSearchListener) {
                Intrinsics.checkNotNullParameter((Object)documentSearchListener, (String)"<set-?>");
                INSTANCE = documentSearchListener;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchGroup$IjSearchHighlight;", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "remove", "", "IdeaVIM"})
    private static final class IjSearchHighlight
    extends VimSearchGroupBase.SearchHighlight {
        @NotNull
        private final Editor editor;
        @NotNull
        private final RangeHighlighter highlighter;

        public IjSearchHighlight(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.editor = editor;
            this.highlighter = highlighter;
        }

        public void remove() {
            this.editor.getMarkupModel().removeHighlighter(this.highlighter);
        }
    }
}

