/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimSearchHelperBase;
import com.maddyhome.idea.vim.helper.PsiHelper;
import com.maddyhome.idea.vim.helper.SearchHelperKtKt;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchHelper;", "Lcom/maddyhome/idea/vim/api/VimSearchHelperBase;", "<init>", "()V", "findMethodEnd", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "count", "findMethodStart", "findMisspelledWord", "Companion", "IdeaVIM"})
public final class IjVimSearchHelper
extends VimSearchHelperBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public int findMethodEnd(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return PsiHelper.findMethodEnd(IjVimEditorKt.getIj(editor), IjVimCaretKt.getIj(caret).getOffset(), count);
    }

    public int findMethodStart(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return PsiHelper.findMethodStart(IjVimEditorKt.getIj(editor), IjVimCaretKt.getIj(caret).getOffset(), count);
    }

    public int findMisspelledWord(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int startOffset = 0;
        int endOffset = 0;
        int skipCount = 0;
        IntComparator offsetOrdering = null;
        if (count < 0) {
            startOffset = 0;
            endOffset = caret.getOffset() - 1;
            skipCount = -count - 1;
            IntComparator intComparator = IntComparators.OPPOSITE_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)intComparator, (String)"OPPOSITE_COMPARATOR");
            offsetOrdering = intComparator;
        } else {
            startOffset = caret.getOffset() + 1;
            endOffset = IjVimEditorKt.getIj(editor).getDocument().getTextLength();
            skipCount = count - 1;
            IntComparator intComparator = IntComparators.NATURAL_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)intComparator, (String)"NATURAL_COMPARATOR");
            offsetOrdering = intComparator;
        }
        return SearchHelperKtKt.findMisspelledWords(IjVimEditorKt.getIj(editor), startOffset, endOffset, skipCount, offsetOrdering);
    }

    static {
        Logger logger = Logger.getInstance((String)IjVimSearchHelper.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IjVimSearchHelper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimSearchHelper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

