/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.StringAndKeysKt;
import com.maddyhome.idea.vim.key.KeyStack;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Collection;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\b\u0004\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0086\b\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/ui/ModalEntry;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "activate", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "processor", "Lkotlin/Function1;", "Ljavax/swing/KeyStroke;", "", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nModalEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModalEntry.kt\ncom/maddyhome/idea/vim/ui/ModalEntry\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n67#2,4:79\n13#2:83\n*S KotlinDebug\n*F\n+ 1 ModalEntry.kt\ncom/maddyhome/idea/vim/ui/ModalEntry\n*L\n35#1:79,4\n29#1:83\n*E\n"})
public final class ModalEntry {
    @NotNull
    public static final ModalEntry INSTANCE = new ModalEntry();
    @NotNull
    private static final Logger LOG;

    private ModalEntry() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    public final void activate(@NotNull VimEditor editor, @NotNull Function1<? super KeyStroke, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        boolean $i$f$activate = false;
        KeyStack mappingStack = KeyHandler.Companion.getInstance().getKeyStack();
        this.getLOG().trace("Dumping key stack:");
        Logger $this$trace$iv = this.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(mappingStack.dump());
        }
        KeyStroke stroke = mappingStack.feedSomeStroke();
        while (stroke != null) {
            boolean result = (Boolean)processor.invoke((Object)stroke);
            if (!result) {
                this.getLOG().trace("Got char from mapping stack");
                return;
            }
            stroke = mappingStack.feedSomeStroke();
        }
        EventQueue systemQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop loop = systemQueue.createSecondaryLoop();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(processor, loop){
            final /* synthetic */ Function1<KeyStroke, Boolean> $processor;
            final /* synthetic */ SecondaryLoop $loop;
            {
                this.$processor = $processor;
                this.$loop = $loop;
            }

            public boolean dispatchKeyEvent(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                KeyStroke stroke = null;
                if (e.getID() == 402) {
                    KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStrokeForEvent(...)");
                    stroke = keyStroke;
                    if (!StringAndKeysKt.isCloseKeyStroke((KeyStroke)stroke) && stroke.getKeyCode() != 10) {
                        return true;
                    }
                } else if (e.getID() == 400) {
                    KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStrokeForEvent(...)");
                    stroke = keyStroke;
                } else {
                    return true;
                }
                if (VimInjectorKt.getInjector().getRegisterGroup().isRecording()) {
                    ((Collection)KeyHandler.Companion.getInstance().getModalEntryKeys()).add(stroke);
                }
                if (!((Boolean)this.$processor.invoke((Object)stroke)).booleanValue()) {
                    ModalEntry.INSTANCE.getLOG().trace("Got char from keyboard input: " + stroke + ". Event: " + e);
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
                    this.$loop.exit();
                }
                return true;
            }
        });
        loop.enter();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ModalEntry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

