/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimCommandLineCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContext;
import com.maddyhome.idea.vim.options.helpers.GuiCursorAttributes;
import com.maddyhome.idea.vim.options.helpers.GuiCursorMode;
import com.maddyhome.idea.vim.options.helpers.GuiCursorOptionHelper;
import com.maddyhome.idea.vim.options.helpers.GuiCursorType;
import com.maddyhome.idea.vim.ui.ex.ExDocument;
import com.maddyhome.idea.vim.ui.ex.ExEditorKit;
import com.maddyhome.idea.vim.ui.ex.ExEntryPanel;
import com.maddyhome.idea.vim.ui.ex.ExTextFieldUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 E2\u00020\u0001:\u0002DEB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0012\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\u0014H\u0002J\b\u00100\u001a\u000201H\u0014J\u0006\u00102\u001a\u00020\u0007J\b\u00103\u001a\u00020\u0007H\u0002J\u0006\u00104\u001a\u00020\u0007J\b\u00105\u001a\u00020\u0007H\u0002J\b\u00106\u001a\u00020\u0007H\u0002J\b\u00107\u001a\u00020\u0007H\u0002J\b\u00108\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\u00070\u0010\u00a2\u0006\u0002\b:8G\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010?\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006F"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExTextField;", "Ljavax/swing/JTextField;", "myParentPanel", "Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel;", "<init>", "(Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel;)V", "reset", "", "deactivate", "getMargin", "Ljava/awt/Insets;", "getInsets", "updateUI", "saveLastEntry", "updateText", "string", "", "setText", "insertText", "offset", "", "text", "deleteText", "length", "setFontToJField", "stringToDisplay", "setFont", "f", "Ljava/awt/Font;", "setForeground", "fg", "Ljava/awt/Color;", "setSpecialKeyForeground", "handleKey", "stroke", "Ljavax/swing/KeyStroke;", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "isAllowedTypedEvent", "", "event", "isAllowedPressedEvent", "isKeyCharEnterOrEscape", "keyChar", "", "isKeyCodeEnterOrEscape", "keyCode", "createDefaultModel", "Ljavax/swing/text/Document;", "clearCurrentAction", "setInsertMode", "toggleInsertReplace", "resetCaret", "setNormalModeCaret", "setInsertModeCaret", "setReplaceModeCaret", "caretShape", "Lorg/jetbrains/annotations/NonNls;", "getCaretShape", "()Ljava/lang/String;", "caret", "Lcom/maddyhome/idea/vim/ui/ex/ExTextField$CommandLineCaret;", "currentActionPromptCharacterOffset", "getCurrentActionPromptCharacterOffset", "()I", "setCurrentActionPromptCharacterOffset", "(I)V", "CommandLineCaret", "Companion", "IdeaVIM"})
public final class ExTextField
extends JTextField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExEntryPanel myParentPanel;
    @NotNull
    private final CommandLineCaret caret;
    private int currentActionPromptCharacterOffset;
    @NotNull
    private static final Logger logger;

    public ExTextField(@NotNull ExEntryPanel myParentPanel) {
        Intrinsics.checkNotNullParameter((Object)myParentPanel, (String)"myParentPanel");
        this.myParentPanel = myParentPanel;
        this.caret = new CommandLineCaret();
        this.currentActionPromptCharacterOffset = -1;
        this.caret.setBlinkRate(this.caret.getBlinkRate());
        this.setCaret(this.caret);
        this.setNormalModeCaret();
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type javax.swing.text.StyledDocument");
        Style defaultStyle = ((StyledDocument)document).getStyle("default");
        StyleConstants.setForeground(defaultStyle, this.getForeground());
        this.addCaretListener(arg_0 -> ExTextField._init_$lambda$0(this, arg_0));
    }

    public final void reset() {
        this.clearCurrentAction();
        this.setInsertMode();
    }

    public final void deactivate() {
        this.clearCurrentAction();
    }

    @Override
    @NotNull
    public Insets getMargin() {
        JBInsets jBInsets = JBUI.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        return (Insets)jBInsets;
    }

    @Override
    @NotNull
    public Insets getInsets() {
        JBInsets jBInsets = JBUI.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        return (Insets)jBInsets;
    }

    @Override
    public void updateUI() {
        this.setUI(new ExTextFieldUI(ExEditorKit.INSTANCE));
        this.invalidate();
        this.setBorder(null);
    }

    public final void saveLastEntry() {
        this.myParentPanel.setLastEntry(super.getText());
    }

    public final void updateText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        super.setText(string);
        this.setFontToJField(string);
    }

    @Override
    public void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        super.setText(string);
        this.saveLastEntry();
        this.setFontToJField(string);
    }

    public final void insertText(int offset, @Nullable String text) {
        try {
            this.getDocument().insertString(offset, text, null);
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
        }
        this.saveLastEntry();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.setFontToJField(string);
    }

    public final void deleteText(int offset, int length) {
        try {
            this.getDocument().remove(offset, Math.min(length, this.getDocument().getLength() - offset));
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
        }
        this.saveLastEntry();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.setFontToJField(string);
    }

    private final void setFontToJField(String stringToDisplay) {
        this.setFont(UiHelper.selectEditorFont(this.myParentPanel.getIjEditor(), stringToDisplay));
    }

    @Override
    public void setFont(@Nullable Font f) {
        super.setFont(f);
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            Style defaultStyle = ((StyledDocument)document).getStyle("default");
            if (!Intrinsics.areEqual((Object)StyleConstants.getFontFamily(defaultStyle), (Object)this.getFont().getFamily())) {
                StyleConstants.setFontFamily(defaultStyle, this.getFont().getFamily());
            }
            if (StyleConstants.getFontSize(defaultStyle) != this.getFont().getSize()) {
                StyleConstants.setFontSize(defaultStyle, this.getFont().getSize());
            }
        }
    }

    @Override
    public void setForeground(@Nullable Color fg) {
        super.setForeground(fg);
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            Style defaultStyle = ((StyledDocument)document).getStyle("default");
            StyleConstants.setForeground(defaultStyle, fg);
        }
    }

    public final void setSpecialKeyForeground(@NotNull Color fg) {
        Intrinsics.checkNotNullParameter((Object)fg, (String)"fg");
        Document document = this.getDocument();
        if (document instanceof ExDocument) {
            ((ExDocument)document).setSpecialKeyForeground(fg);
        }
    }

    public final void handleKey(@NotNull KeyStroke stroke) {
        Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
        if (logger.isDebugEnabled()) {
            logger.debug("stroke=" + stroke);
        }
        if (stroke.getKeyChar() != '\uffff') {
            this.replaceSelection(String.valueOf(stroke.getKeyChar()));
        } else {
            KeyEvent event = new KeyEvent(this, stroke.getKeyEventType(), new Date().getTime(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar());
            super.processKeyEvent(event);
        }
        this.saveLastEntry();
    }

    @Override
    protected void processKeyEvent(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (logger.isDebugEnabled()) {
            logger.debug("key=" + e);
        }
        if (this.isAllowedPressedEvent(e) || this.isAllowedTypedEvent(e)) {
            VimEditor editor = this.myParentPanel.getEditor();
            KeyHandler keyHandler = KeyHandler.Companion.getInstance();
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            Intrinsics.checkNotNull((Object)keyStroke);
            DataContext dataContext = this.myParentPanel.getContext();
            Intrinsics.checkNotNull((Object)dataContext);
            keyHandler.handleKey(editor, keyStroke, (ExecutionContext)new IjEditorExecutionContext(dataContext), keyHandler.getKeyHandlerState());
            e.consume();
        } else {
            super.processKeyEvent(e);
        }
    }

    private final boolean isAllowedTypedEvent(KeyEvent event) {
        return event.getID() == 400 && !this.isKeyCharEnterOrEscape(event.getKeyChar());
    }

    private final boolean isAllowedPressedEvent(KeyEvent event) {
        return event.getID() == 401 && this.isKeyCodeEnterOrEscape(event.getKeyCode());
    }

    private final boolean isKeyCharEnterOrEscape(char keyChar) {
        return keyChar == '\n' || keyChar == '\u001b';
    }

    private final boolean isKeyCodeEnterOrEscape(int keyCode) {
        return keyCode == 10 || keyCode == 27;
    }

    @Override
    @NotNull
    protected Document createDefaultModel() {
        return new ExDocument();
    }

    public final void clearCurrentAction() {
        block0: {
            VimCommandLine commandLine;
            VimCommandLine vimCommandLine = commandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
            if (vimCommandLine == null) break block0;
            vimCommandLine.clearPromptCharacter();
        }
    }

    private final void setInsertMode() {
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ui.ex.ExDocument");
        ExDocument doc = (ExDocument)document;
        if (doc.isOverwrite()) {
            doc.toggleInsertReplace();
        }
        this.resetCaret();
    }

    public final void toggleInsertReplace() {
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ui.ex.ExDocument");
        ExDocument doc = (ExDocument)document;
        doc.toggleInsertReplace();
        this.caret.setVisible(false);
        this.resetCaret();
        this.caret.setVisible(true);
    }

    private final void resetCaret() {
        if (this.getCaretPosition() == super.getText().length() || this.currentActionPromptCharacterOffset == super.getText().length() - 1) {
            this.setNormalModeCaret();
        } else {
            Document document = this.getDocument();
            Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ui.ex.ExDocument");
            ExDocument doc = (ExDocument)document;
            if (doc.isOverwrite()) {
                this.setReplaceModeCaret();
            } else {
                this.setInsertModeCaret();
            }
        }
    }

    private final void setNormalModeCaret() {
        this.caret.setAttributes(GuiCursorOptionHelper.INSTANCE.getAttributes(GuiCursorMode.CMD_LINE));
    }

    private final void setInsertModeCaret() {
        this.caret.setAttributes(GuiCursorOptionHelper.INSTANCE.getAttributes(GuiCursorMode.CMD_LINE_INSERT));
    }

    private final void setReplaceModeCaret() {
        this.caret.setAttributes(GuiCursorOptionHelper.INSTANCE.getAttributes(GuiCursorMode.CMD_LINE_REPLACE));
    }

    @TestOnly
    @NotNull
    public final String getCaretShape() {
        CommandLineCaret caret = this.caret;
        String string = "%s %d";
        Object[] objectArray = new Object[]{caret.getMode(), caret.getThickness()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final int getCurrentActionPromptCharacterOffset() {
        return this.currentActionPromptCharacterOffset;
    }

    public final void setCurrentActionPromptCharacterOffset(int n) {
        this.currentActionPromptCharacterOffset = n;
    }

    private static final void _init_$lambda$0(ExTextField this$0, CaretEvent caretEvent) {
        this$0.resetCaret();
    }

    static {
        Logger logger = Logger.getInstance((String)ExTextField.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ExTextField.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\fJ&\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0013J\u000e\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u000e\"\u0004\b1\u0010\u0010\u00a8\u00062"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExTextField$CommandLineCaret;", "Ljavax/swing/text/DefaultCaret;", "Lcom/maddyhome/idea/vim/api/VimCommandLineCaret;", "<init>", "()V", "mode", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorType;", "getMode", "()Lcom/maddyhome/idea/vim/options/helpers/GuiCursorType;", "setMode", "(Lcom/maddyhome/idea/vim/options/helpers/GuiCursorType;)V", "thickness", "", "getThickness", "()I", "setThickness", "(I)V", "lastBlinkRate", "hasFocus", "", "setAttributes", "", "attributes", "Lcom/maddyhome/idea/vim/options/helpers/GuiCursorAttributes;", "focusGained", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "paint", "g", "Ljava/awt/Graphics;", "damage", "r", "Ljava/awt/Rectangle;", "modelToView", "Ljava/awt/geom/Rectangle2D;", "dot", "getCaretWidth", "", "fm", "Ljava/awt/FontMetrics;", "dotX", "widthPercentage", "coerceCharacterWidth", "getCaretHeight", "fullHeight", "i", "offset", "getOffset", "setOffset", "IdeaVIM"})
    private static final class CommandLineCaret
    extends DefaultCaret
    implements VimCommandLineCaret {
        @Nullable
        private GuiCursorType mode;
        private int thickness = 100;
        private int lastBlinkRate;
        private boolean hasFocus;

        @Nullable
        public final GuiCursorType getMode() {
            return this.mode;
        }

        public final void setMode(@Nullable GuiCursorType guiCursorType) {
            this.mode = guiCursorType;
        }

        public final int getThickness() {
            return this.thickness;
        }

        public final void setThickness(int n) {
            this.thickness = n;
        }

        public final void setAttributes(@NotNull GuiCursorAttributes attributes) {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            this.mode = attributes.getType();
            this.thickness = this.mode == GuiCursorType.BLOCK ? 100 : attributes.getThickness();
        }

        @Override
        public void focusGained(@Nullable FocusEvent e) {
            if (this.lastBlinkRate != 0) {
                this.setBlinkRate(this.lastBlinkRate);
                this.lastBlinkRate = 0;
            }
            super.focusGained(e);
            this.repaint();
            this.hasFocus = true;
        }

        @Override
        public void focusLost(@Nullable FocusEvent e) {
            this.hasFocus = false;
            this.lastBlinkRate = this.getBlinkRate();
            this.setBlinkRate(0);
            this.setVisible(true);
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this.isVisible()) {
                return;
            }
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                Rectangle2D rectangle2D;
                JTextComponent component = this.getComponent();
                g2d.setColor(component.getBackground());
                g2d.setXORMode(component.getCaretColor());
                if (this.modelToView(this.getDot()) == null) {
                    return;
                }
                Rectangle2D r = rectangle2D;
                if (this.width > 0 && this.height > 0 && !this.contains(r)) {
                    Rectangle clip = g2d.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r.getBounds());
                }
                FontMetrics fm = component.getFontMetrics(component.getFont());
                if (!this.hasFocus) {
                    float outlineThickness = (float)PaintUtil.alignToInt((double)1.0, (Graphics2D)g2d);
                    Intrinsics.checkNotNull((Object)fm);
                    double caretWidth = this.getCaretWidth(fm, r.getX(), 100, false);
                    Area area = new Area(new Rectangle2D.Double(r.getX(), r.getY(), caretWidth, r.getHeight()));
                    area.subtract(new Area(new Rectangle2D.Double(r.getX() + (double)outlineThickness, r.getY() + (double)outlineThickness, caretWidth - (double)((float)2 * outlineThickness), r.getHeight() - (double)((float)2 * outlineThickness))));
                    g2d.fill(area);
                } else {
                    double caretHeight = this.getCaretHeight(r.getHeight());
                    Intrinsics.checkNotNull((Object)fm);
                    double caretWidth = this.getCaretWidth(fm, r.getX(), this.thickness, true);
                    Rectangle2D.Double rect = new Rectangle2D.Double(r.getX(), r.getY() + r.getHeight() - caretHeight, caretWidth, caretHeight);
                    g2d.fill(rect);
                }
            }
            finally {
                g2d.dispose();
            }
        }

        @Override
        protected synchronized void damage(@Nullable Rectangle r) {
            if (r != null) {
                FontMetrics fm = this.getComponent().getFontMetrics(this.getComponent().getFont());
                this.x = r.x;
                this.y = r.y;
                Intrinsics.checkNotNull((Object)fm);
                this.width = (int)Math.ceil(this.getCaretWidth(fm, r.x, 100, false)) + 1;
                this.height = r.height;
                this.repaint();
            }
        }

        @Nullable
        public final Rectangle2D modelToView(int dot) {
            Rectangle2D rectangle2D;
            if (dot > this.getComponent().getDocument().getLength()) {
                return null;
            }
            try {
                rectangle2D = this.getComponent().getUI().modelToView2D(this.getComponent(), dot, this.getDotBias());
            }
            catch (BadLocationException badLocationException) {
                rectangle2D = null;
            }
            return rectangle2D;
        }

        public final double getCaretWidth(@NotNull FontMetrics fm, double dotX, int widthPercentage, boolean coerceCharacterWidth) {
            Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
            double width = 0.0;
            Rectangle2D r = this.modelToView(this.getDot() + 1);
            if (r != null && !coerceCharacterWidth) {
                width = r.getX() - dotX;
            } else {
                char c = ' ';
                try {
                    char documentChar;
                    if (this.getDot() < this.getComponent().getDocument().getLength() && EngineStringHelper.INSTANCE.isPrintableCharacter(documentChar = this.getComponent().getText(this.getDot(), 1).charAt(0))) {
                        c = documentChar;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                width = fm.charWidth(c);
            }
            return this.mode == GuiCursorType.VER ? Math.max(1.0, width * (double)widthPercentage / (double)100) : width;
        }

        public final double getCaretHeight(double fullHeight) {
            if (this.mode == GuiCursorType.HOR) {
                return Math.max(1.0, fullHeight * (double)this.thickness / 100.0);
            }
            return fullHeight;
        }

        public int getOffset() {
            return this.getDot();
        }

        public void setOffset(int i) {
            this.setDot(i);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExTextField$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

