/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.widgets.mode.listeners;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.EditorListener;
import com.maddyhome.idea.vim.common.ModeChangeListener;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.ui.widgets.VimWidgetListener;
import com.maddyhome.idea.vim.ui.widgets.mode.VimModeWidget;
import com.maddyhome.idea.vim.ui.widgets.mode.VimModeWidgetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/ui/widgets/mode/listeners/ModeWidgetListener;", "Lcom/maddyhome/idea/vim/common/ModeChangeListener;", "Lcom/maddyhome/idea/vim/common/EditorListener;", "Lcom/maddyhome/idea/vim/ui/widgets/VimWidgetListener;", "<init>", "()V", "modeChanged", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "oldMode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "getWidget", "Lcom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget;", "project", "Lcom/intellij/openapi/project/Project;", "created", "released", "focusGained", "focusLost", "getFocusedEditorForProject", "Lcom/intellij/openapi/editor/Editor;", "editorProject", "Companion", "IdeaVIM"})
public final class ModeWidgetListener
extends VimWidgetListener
implements ModeChangeListener,
EditorListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final RecursionGuard<Object> recursionGuard;
    @NotNull
    private static final Object recursionKey;

    public ModeWidgetListener() {
        super(ModeWidgetListener::_init_$lambda$0);
    }

    public void modeChanged(@NotNull VimEditor editor, @NotNull Mode oldMode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)oldMode, (String)"oldMode");
        VimModeWidget vimModeWidget = this.getWidget(editor);
        if (vimModeWidget == null) {
            return;
        }
        VimModeWidget modeWidget = vimModeWidget;
        Mode editorMode = editor.getMode();
        if (!(editorMode instanceof Mode.OP_PENDING)) {
            modeWidget.updateWidget(editorMode);
        }
    }

    private final VimModeWidget getWidget(VimEditor editor) {
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.newapi.IjVimEditor");
        Project project = ((IjVimEditor)editor).getEditor().getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return this.getWidget(project2);
    }

    private final VimModeWidget getWidget(Project project) {
        WindowManager windowManager = WindowManager.getInstance();
        if (windowManager == null || (windowManager = windowManager.getStatusBar(project)) == null) {
            return null;
        }
        WindowManager statusBar = windowManager;
        StatusBarWidget statusBarWidget = statusBar.getWidget("IdeaVimMode");
        return statusBarWidget instanceof VimModeWidget ? (VimModeWidget)statusBarWidget : null;
    }

    public void created(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimModeWidgetKt.updateModeWidget();
        VimModeWidget vimModeWidget = this.getWidget(editor);
        if (vimModeWidget == null) {
            return;
        }
        VimModeWidget modeWidget = vimModeWidget;
        Editor editor2 = this.getFocusedEditorForProject(IjVimEditorKt.getIj(editor).getProject());
        Mode mode2 = editor2 != null && (editor2 = IjVimEditorKt.getVim(editor2)) != null ? editor2.getMode() : null;
        modeWidget.updateWidget(mode2);
    }

    public void released(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimModeWidgetKt.updateModeWidget();
        VimModeWidget vimModeWidget = this.getWidget(editor);
        if (vimModeWidget == null) {
            return;
        }
        VimModeWidget modeWidget = vimModeWidget;
        Editor focusedEditor = this.getFocusedEditorForProject(IjVimEditorKt.getIj(editor).getProject());
        if (focusedEditor == null || Intrinsics.areEqual((Object)focusedEditor, (Object)IjVimEditorKt.getIj(editor))) {
            modeWidget.updateWidget(null);
        }
    }

    public void focusGained(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimModeWidget vimModeWidget = this.getWidget(editor);
        if (vimModeWidget == null) {
            return;
        }
        VimModeWidget modeWidget = vimModeWidget;
        Mode mode2 = editor.getMode();
        modeWidget.updateWidget(mode2);
    }

    public void focusLost(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimModeWidget vimModeWidget = this.getWidget(editor);
        if (vimModeWidget == null) {
            return;
        }
        VimModeWidget modeWidget = vimModeWidget;
        Editor editor2 = this.getFocusedEditorForProject(IjVimEditorKt.getIj(editor).getProject());
        Mode mode2 = editor2 != null && (editor2 = IjVimEditorKt.getVim(editor2)) != null ? editor2.getMode() : null;
        modeWidget.updateWidget(mode2);
    }

    private final Editor getFocusedEditorForProject(Project editorProject) {
        if (editorProject == null) {
            return null;
        }
        return (Editor)recursionGuard.doPreventingRecursion(recursionKey, false, () -> ModeWidgetListener.getFocusedEditorForProject$lambda$0(editorProject));
    }

    private static final void _init_$lambda$0() {
        VimModeWidgetKt.updateModeWidget();
    }

    private static final Editor getFocusedEditorForProject$lambda$0(Project $editorProject) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$editorProject);
        return fileEditorManager.getSelectedTextEditor();
    }

    static {
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)"IdeaVim.modeWidgetListener");
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"createGuard(...)");
        ModeWidgetListener.recursionGuard = recursionGuard;
        recursionKey = new Object();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00010\u00010\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/ui/widgets/mode/listeners/ModeWidgetListener$Companion;", "", "<init>", "()V", "recursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "recursionKey", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

