/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.options.helpers;

import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.VimLockLabel;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelper;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelperKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper;", "", "<init>", "()V", "applyCorrections", "", "corrections", "", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action;", "editor", "Lcom/intellij/openapi/editor/Editor;", "calculateCorrectionsToSyncEditorToMode", "correctEditorSelection", "Action", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nIdeaRefactorModeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaRefactorModeHelper.kt\ncom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1869#2,2:137\n*S KotlinDebug\n*F\n+ 1 IdeaRefactorModeHelper.kt\ncom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper\n*L\n46#1:137,2\n*E\n"})
public final class IdeaRefactorModeHelper {
    @NotNull
    public static final IdeaRefactorModeHelper INSTANCE = new IdeaRefactorModeHelper();

    private IdeaRefactorModeHelper() {
    }

    public final void applyCorrections(@NotNull List<? extends Action> corrections, @NotNull Editor editor) {
        LookupImpl lookup;
        Intrinsics.checkNotNullParameter(corrections, (String)"corrections");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Function0 correctionsApplier = () -> IdeaRefactorModeHelper.applyCorrections$lambda$0(corrections, editor);
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)editor);
        LookupImpl lookupImpl = lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        if (lookup != null) {
            int selStart = editor.getSelectionModel().getSelectionStart();
            int selEnd = editor.getSelectionModel().getSelectionEnd();
            lookup.performGuardedChange(() -> IdeaRefactorModeHelper.applyCorrections$lambda$1(correctionsApplier));
            lookup.addLookupListener(new LookupListener(lookup, editor, selStart, selEnd){
                final /* synthetic */ LookupImpl $lookup;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ int $selStart;
                final /* synthetic */ int $selEnd;
                {
                    this.$lookup = $lookup;
                    this.$editor = $editor;
                    this.$selStart = $selStart;
                    this.$selEnd = $selEnd;
                }

                public boolean beforeItemSelected(LookupEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$lookup.performGuardedChange(() -> applyCorrections.2.beforeItemSelected$lambda$0(this.$editor, this.$selStart, this.$selEnd));
                    this.$lookup.removeLookupListener((LookupListener)this);
                    return true;
                }

                private static final void beforeItemSelected$lambda$0(Editor $editor, int $selStart, int $selEnd) {
                    $editor.getSelectionModel().setSelection($selStart, $selEnd);
                }
            });
        } else {
            correctionsApplier.invoke();
        }
    }

    @VimLockLabel.RequiresReadLock
    @RequiresReadLock
    @NotNull
    public final List<Action> calculateCorrectionsToSyncEditorToMode(@NotNull Editor editor) {
        List corrections;
        block9: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            corrections = new ArrayList();
            Mode mode2 = IjVimEditorKt.getVim(editor).getMode();
            if (!CommandStateHelper.getHasVisualSelection(mode2) && editor.getSelectionModel().hasSelection()) {
                corrections.add(Action.RemoveSelection.INSTANCE);
            }
            if (CommandStateHelper.getHasVisualSelection(mode2) && editor.getSelectionModel().hasSelection()) {
                SelectionType selectionType = VimPlugin.getVisualMotion().detectSelectionType(IjVimEditorKt.getVim(editor));
                if (ModeExtensionsKt.getSelectionType((Mode)mode2) != selectionType) {
                    Mode mode3;
                    Mode mode4 = mode2;
                    if (mode4 instanceof Mode.SELECT) {
                        mode3 = (Mode)Mode.SELECT.copy$default((Mode.SELECT)((Mode.SELECT)mode2), (SelectionType)selectionType, null, (int)2, null);
                    } else if (mode4 instanceof Mode.VISUAL) {
                        mode3 = (Mode)Mode.VISUAL.copy$default((Mode.VISUAL)((Mode.VISUAL)mode2), (SelectionType)selectionType, null, (int)2, null);
                    } else {
                        throw new IllegalStateException("IdeaVim should be either in visual or select modes".toString());
                    }
                    Mode newMode = mode3;
                    corrections.add(new Action.SetMode(newMode));
                }
            }
            if (!IdeaRefactorModeHelperKt.isIdeaRefactorModeKeep(IjVimEditorKt.getVim(editor))) break block9;
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            if (templateState != null && (templateState = templateState.getCurrentVariableRange()) != null) {
                TemplateState segmentRange = templateState;
                boolean bl = false;
                if (!segmentRange.isEmpty() && segmentRange.getStartOffset() != editor.getCaretModel().getOffset()) {
                    corrections.add(new Action.MoveToOffset(segmentRange.getStartOffset()));
                }
            }
        }
        return corrections;
    }

    public final void correctEditorSelection(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimInjectorKt.getInjector().getApplication().runReadAction(() -> IdeaRefactorModeHelper.correctEditorSelection$lambda$0(editor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit applyCorrections$lambda$0(List $corrections, Editor $editor) {
        Iterable $this$forEach$iv = $corrections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Action correction = (Action)element$iv;
            boolean bl = false;
            Action action = correction;
            if (action instanceof Action.MoveToOffset) {
                $editor.getCaretModel().moveToOffset(((Action.MoveToOffset)correction).getNewOffset());
                continue;
            }
            if (Intrinsics.areEqual((Object)action, (Object)Action.RemoveSelection.INSTANCE)) {
                Closeable closeable = (Closeable)SelectionVimListenerSuppressor.INSTANCE.lock();
                Throwable throwable = null;
                try {
                    VimListenerSuppressor.Locked it = (VimListenerSuppressor.Locked)closeable;
                    boolean bl2 = false;
                    $editor.getSelectionModel().removeSelection();
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    continue;
                }
            }
            if (action instanceof Action.SetMode) {
                IjVimEditorKt.getVim($editor).setMode(((Action.SetMode)correction).getNewMode());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final void applyCorrections$lambda$1(Function0 $correctionsApplier) {
        $correctionsApplier.invoke();
    }

    private static final Unit correctEditorSelection$lambda$0(Editor $editor) {
        List<Action> corrections = INSTANCE.calculateCorrectionsToSyncEditorToMode($editor);
        INSTANCE.applyCorrections(corrections, $editor);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action;", "", "RemoveSelection", "SetMode", "MoveToOffset", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action$MoveToOffset;", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action$RemoveSelection;", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action$SetMode;", "IdeaVIM"})
    public static sealed interface Action {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action$MoveToOffset;", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action;", "newOffset", "", "<init>", "(I)V", "getNewOffset", "()I", "IdeaVIM"})
        public static final class MoveToOffset
        implements Action {
            private final int newOffset;

            public MoveToOffset(int newOffset) {
                this.newOffset = newOffset;
            }

            public final int getNewOffset() {
                return this.newOffset;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action$RemoveSelection;", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action;", "<init>", "()V", "IdeaVIM"})
        public static final class RemoveSelection
        implements Action {
            @NotNull
            public static final RemoveSelection INSTANCE = new RemoveSelection();

            private RemoveSelection() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action$SetMode;", "Lcom/maddyhome/idea/vim/vimscript/model/options/helpers/IdeaRefactorModeHelper$Action;", "newMode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "<init>", "(Lcom/maddyhome/idea/vim/state/mode/Mode;)V", "getNewMode", "()Lcom/maddyhome/idea/vim/state/mode/Mode;", "IdeaVIM"})
        public static final class SetMode
        implements Action {
            @NotNull
            private final Mode newMode;

            public SetMode(@NotNull Mode newMode) {
                Intrinsics.checkNotNullParameter((Object)newMode, (String)"newMode");
                this.newMode = newMode;
            }

            @NotNull
            public final Mode getNewMode() {
                return this.newMode;
            }
        }
    }
}

