/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vim.api.models;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B+\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vim/api/models/Color;", "", "hexCode", "", "<init>", "(Ljava/lang/String;)V", "r", "", "g", "b", "a", "(IIII)V", "getHexCode", "()Ljava/lang/String;", "getR", "()I", "getG", "getB", "getA", "component1", "copy", "equals", "", "other", "hashCode", "toString", "api"})
public final class Color {
    @NotNull
    private final String hexCode;
    private final int r;
    private final int g;
    private final int b;
    private final int a;

    public Color(@NotNull String hexCode) {
        Intrinsics.checkNotNullParameter((Object)hexCode, (String)"hexCode");
        this.hexCode = hexCode;
        this.r = Integer.parseInt(StringsKt.substring((String)this.hexCode, (IntRange)new IntRange(1, 2)), CharsKt.checkRadix((int)16));
        this.g = Integer.parseInt(StringsKt.substring((String)this.hexCode, (IntRange)new IntRange(3, 4)), CharsKt.checkRadix((int)16));
        this.b = Integer.parseInt(StringsKt.substring((String)this.hexCode, (IntRange)new IntRange(5, 6)), CharsKt.checkRadix((int)16));
        this.a = this.hexCode.length() == 9 ? Integer.parseInt(StringsKt.substring((String)this.hexCode, (IntRange)new IntRange(7, 8)), CharsKt.checkRadix((int)16)) : 255;
        CharSequence charSequence = this.hexCode;
        if (!new Regex("^#[0-9A-Fa-f]{6}([0-9A-Fa-f]{2})?$").matches(charSequence)) {
            boolean bl = false;
            String string = "Hex code should be in format #RRGGBB[AA]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getHexCode() {
        return this.hexCode;
    }

    public Color(int r, int g, int b, int a) {
        String string = "#%02x%02x%02x%02x";
        Object[] objectArray = new Object[]{r, g, b, a};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this(string2);
    }

    public /* synthetic */ Color(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 255;
        }
        this(n, n2, n3, n4);
    }

    public final int getR() {
        return this.r;
    }

    public final int getG() {
        return this.g;
    }

    public final int getB() {
        return this.b;
    }

    public final int getA() {
        return this.a;
    }

    @NotNull
    public final String component1() {
        return this.hexCode;
    }

    @NotNull
    public final Color copy(@NotNull String hexCode) {
        Intrinsics.checkNotNullParameter((Object)hexCode, (String)"hexCode");
        return new Color(hexCode);
    }

    public static /* synthetic */ Color copy$default(Color color, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = color.hexCode;
        }
        return color.copy(string);
    }

    @NotNull
    public String toString() {
        return "Color(hexCode=" + this.hexCode + ")";
    }

    public int hashCode() {
        return this.hexCode.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Color)) {
            return false;
        }
        Color color = (Color)other;
        return Intrinsics.areEqual((Object)this.hexCode, (Object)color.hexCode);
    }
}

