/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.IgnoreManager;
import mobi.hsz.idea.gitignore.file.type.IgnoreFileType;
import mobi.hsz.idea.gitignore.indexing.AbstractIgnoreFilesIndex;
import mobi.hsz.idea.gitignore.indexing.IgnoreEntryOccurrence;
import mobi.hsz.idea.gitignore.indexing.IgnoreFileTypeKey;
import mobi.hsz.idea.gitignore.indexing.IgnoreFilesIndex;
import mobi.hsz.idea.gitignore.indexing.IgnoreFilesIndexKt;
import mobi.hsz.idea.gitignore.psi.IgnoreEntry;
import mobi.hsz.idea.gitignore.psi.IgnoreFile;
import mobi.hsz.idea.gitignore.psi.IgnoreVisitor;
import mobi.hsz.idea.gitignore.util.Glob;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016\u00a8\u0006\u001b"}, d2={"Lmobi/hsz/idea/gitignore/indexing/IgnoreFilesIndex;", "Lmobi/hsz/idea/gitignore/indexing/AbstractIgnoreFilesIndex;", "Lmobi/hsz/idea/gitignore/indexing/IgnoreFileTypeKey;", "Lmobi/hsz/idea/gitignore/indexing/IgnoreEntryOccurrence;", "()V", "acceptInput", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "Lcom/intellij/util/indexing/ID;", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "map", "", "inputData", "Lcom/intellij/util/indexing/FileContent;", "read", "input", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nIgnoreFilesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFilesIndex.kt\nmobi/hsz/idea/gitignore/indexing/IgnoreFilesIndex\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n179#2,2:107\n1#3:109\n*S KotlinDebug\n*F\n+ 1 IgnoreFilesIndex.kt\nmobi/hsz/idea/gitignore/indexing/IgnoreFilesIndex\n*L\n67#1:107,2\n*E\n"})
public final class IgnoreFilesIndex
extends AbstractIgnoreFilesIndex<IgnoreFileTypeKey, IgnoreEntryOccurrence> {
    @NotNull
    public ID<IgnoreFileTypeKey, IgnoreEntryOccurrence> getName() {
        return IgnoreFilesIndexKt.getKEY();
    }

    @NotNull
    public Map<IgnoreFileTypeKey, IgnoreEntryOccurrence> map(@NotNull FileContent inputData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        try {
            object = inputData.getPsiFile();
        }
        catch (Exception e) {
            return MapsKt.emptyMap();
        }
        PsiFile psiFile = object;
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile inputDataPsi = psiFile;
        if (!(inputDataPsi instanceof IgnoreFile)) {
            return MapsKt.emptyMap();
        }
        List items = new ArrayList();
        inputDataPsi.acceptChildren((PsiElementVisitor)new IgnoreVisitor(items){
            final /* synthetic */ List<Pair<String, Boolean>> $items;
            {
                this.$items = $items;
            }

            public void visitEntry(@NotNull IgnoreEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                String regex = Glob.INSTANCE.getRegex(entry.getValue(), entry.getSyntax(), false);
                Pair pair = Pair.create((Object)regex, (Object)entry.isNegated());
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                this.$items.add((Pair<String, Boolean>)pair);
            }
        });
        FileType fileType = inputData.getFileType();
        Intrinsics.checkNotNull((Object)fileType, (String)"null cannot be cast to non-null type mobi.hsz.idea.gitignore.file.type.IgnoreFileType");
        IgnoreFileTypeKey ignoreFileTypeKey = new IgnoreFileTypeKey((IgnoreFileType)fileType);
        String string = inputData.getFile().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        object = Collections.singletonMap(ignoreFileTypeKey, new IgnoreEntryOccurrence(string, items));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"singletonMap(...)");
        return object;
    }

    public synchronized void save(@NotNull DataOutput out, @NotNull IgnoreFileTypeKey value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        out.writeUTF(value.getType().getLanguageName());
    }

    @NotNull
    public synchronized IgnoreFileTypeKey read(@NotNull DataInput input) throws IOException {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String $this$read_u24lambda_u242 = input.readUTF();
            boolean bl = false;
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)IgnoreBundle.INSTANCE.getLANGUAGES()), (Function1)read.1.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IgnoreFileType it = (IgnoreFileType)((Object)element$iv);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getLanguageName(), (Object)$this$read_u24lambda_u242)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        IgnoreFileType it = v0;
        boolean bl = false;
        IgnoreFileType ignoreFileType = it;
        if (ignoreFileType == null) {
            ignoreFileType = IgnoreFileType.Companion.getINSTANCE();
        }
        return new IgnoreFileTypeKey(ignoreFileType);
    }

    @NotNull
    public DataExternalizer<IgnoreEntryOccurrence> getValueExternalizer() {
        return IgnoreFilesIndexKt.access$getDATA_EXTERNALIZER$p();
    }

    public int getVersion() {
        return 5;
    }

    public boolean acceptInput(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getFileType() instanceof IgnoreFileType || IgnoreManager.Companion.getFILE_TYPES_ASSOCIATION_QUEUE().containsKey(file.getName());
    }
}

