/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.provider;

import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.utils.attributes.Attributes;
import ai.koog.prompt.params.LLMParams;
import com.intellij.ml.llm.core.models.api.AiaLlmChatMessage;
import com.intellij.ml.llm.core.providers.AiaThirdPartyLlmChatMessage;
import com.intellij.ml.llm.smartChat.endpoints.LlmFunctionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/provider/AiaThirdPartyProviderClientUtils;", "", "<init>", "()V", "debugLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getDebugLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "extractSchema", "Lai/koog/prompt/params/LLMParams$Schema;", "attributes", "Lai/grazie/utils/attributes/Attributes;", "extractToolChoice", "Lai/koog/prompt/params/LLMParams$ToolChoice;", "logDebugMessages", "", "messages", "", "Lcom/intellij/ml/llm/core/models/api/AiaLlmChatMessage;", "logDebugTools", "chatCompletionTools", "Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "intellij.ml.llm.provider"})
@SourceDebugExtension(value={"SMAP\nAiaThirdPartyProviderClientUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiaThirdPartyProviderClientUtils.kt\ncom/intellij/ml/llm/provider/AiaThirdPartyProviderClientUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n1869#2,2:172\n1869#2,2:174\n23#3:176\n*S KotlinDebug\n*F\n+ 1 AiaThirdPartyProviderClientUtils.kt\ncom/intellij/ml/llm/provider/AiaThirdPartyProviderClientUtils\n*L\n50#1:172,2\n64#1:174,2\n29#1:176\n*E\n"})
public final class AiaThirdPartyProviderClientUtils {
    @NotNull
    public static final AiaThirdPartyProviderClientUtils INSTANCE;
    @NotNull
    private static final Logger debugLogger;

    private AiaThirdPartyProviderClientUtils() {
    }

    @NotNull
    public final Logger getDebugLogger() {
        return debugLogger;
    }

    @Nullable
    public final LLMParams.Schema extractSchema(@NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object object = attributes.getJson(LLMParameters.INSTANCE.getResponseFormat());
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object responseFormatJson = object;
        JsonElement jsonElement = Json.Default.parseToJsonElement((String)responseFormatJson);
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            return null;
        }
        JsonObject jsonObject2 = jsonObject;
        return (LLMParams.Schema)new LLMParams.Schema.JSON.Basic("", jsonObject2);
    }

    @Nullable
    public final LLMParams.ToolChoice extractToolChoice(@NotNull Attributes attributes) {
        LLMParams.ToolChoice toolChoice;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Attributes.Value.Bool bool = attributes.getBool(LLMParameters.ToolChoice.INSTANCE.getAuto());
        boolean bl = bool != null ? bool.getValue().booleanValue() : false;
        if (bl) {
            toolChoice = (LLMParams.ToolChoice)LLMParams.ToolChoice.Auto.INSTANCE;
        } else {
            Attributes.Value.Bool bool2 = attributes.getBool(LLMParameters.ToolChoice.INSTANCE.getNone());
            boolean bl2 = bool2 != null ? bool2.getValue().booleanValue() : false;
            if (bl2) {
                toolChoice = (LLMParams.ToolChoice)LLMParams.ToolChoice.None.INSTANCE;
            } else {
                Attributes.Value.Bool bool3 = attributes.getBool(LLMParameters.ToolChoice.INSTANCE.getRequired());
                boolean bl3 = bool3 != null ? bool3.getValue().booleanValue() : false;
                if (bl3) {
                    toolChoice = (LLMParams.ToolChoice)LLMParams.ToolChoice.Required.INSTANCE;
                } else {
                    Attributes.Value.Text text = attributes.getText(LLMParameters.ToolChoice.INSTANCE.getNamed());
                    if ((text != null ? text.getValue() : null) != null) {
                        Attributes.Value.Text text2 = attributes.getText(LLMParameters.ToolChoice.INSTANCE.getNamed());
                        String string = text2 != null ? text2.getValue() : null;
                        Intrinsics.checkNotNull((Object)string);
                        toolChoice = (LLMParams.ToolChoice)new LLMParams.ToolChoice.Named(string);
                    } else {
                        toolChoice = null;
                    }
                }
            }
        }
        return toolChoice;
    }

    public final void logDebugMessages(@NotNull List<? extends AiaLlmChatMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        debugLogger.debug("=== MESSAGES ===");
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AiaLlmChatMessage aiaLlmChatMessage;
            AiaLlmChatMessage message = (AiaLlmChatMessage)element$iv;
            boolean bl = false;
            AiaLlmChatMessage aiaLlmChatMessage2 = message;
            if (aiaLlmChatMessage2 instanceof AiaThirdPartyLlmChatMessage.System) {
                aiaLlmChatMessage = (AiaLlmChatMessage)((AiaThirdPartyLlmChatMessage.System)message).copy("<omitted>");
            } else if (aiaLlmChatMessage2 instanceof AiaThirdPartyLlmChatMessage.User) {
                AiaThirdPartyLlmChatMessage.User user = (AiaThirdPartyLlmChatMessage.User)message;
                String string = StringUtil.first((String)((AiaThirdPartyLlmChatMessage.User)message).getContent(), (int)300, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"first(...)");
                aiaLlmChatMessage = (AiaLlmChatMessage)user.copy(string);
            } else if (aiaLlmChatMessage2 instanceof AiaThirdPartyLlmChatMessage.Assistant) {
                AiaThirdPartyLlmChatMessage.Assistant assistant = (AiaThirdPartyLlmChatMessage.Assistant)message;
                String string = StringUtil.first((String)((AiaThirdPartyLlmChatMessage.Assistant)message).getContent(), (int)300, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"first(...)");
                aiaLlmChatMessage = (AiaLlmChatMessage)assistant.copy(string);
            } else {
                aiaLlmChatMessage = message;
            }
            debugLogger.debug(String.valueOf(aiaLlmChatMessage));
        }
    }

    public final void logDebugTools(@NotNull List<LlmFunctionDescriptor> chatCompletionTools) {
        Intrinsics.checkNotNullParameter(chatCompletionTools, (String)"chatCompletionTools");
        debugLogger.debug("=== TOOLS ===");
        Iterable $this$forEach$iv = chatCompletionTools;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LlmFunctionDescriptor it = (LlmFunctionDescriptor)element$iv;
            boolean bl = false;
            String string = it.getName();
            String string2 = it.getDescription();
            if (string2 == null) {
                string2 = "";
            }
            debugLogger.debug(string + " - " + StringUtil.first((String)string2, (int)300, (boolean)true));
        }
    }

    static {
        AiaThirdPartyProviderClientUtils $this$thisLogger$iv = INSTANCE = new AiaThirdPartyProviderClientUtils();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AiaThirdPartyProviderClientUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        debugLogger = logger;
    }
}

