/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.ml.llm.core.statistics.llmc.RequestPrivateData;
import com.intellij.ml.llm.terminal.LanguageDetectionFalsePositiveType;
import com.intellij.ml.llm.terminal.TerminalAiUsageCollector;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0017\u001a\u00020\u0018H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiCollectorBase;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;)V", "getGroup", "USER_INPUT_FIELD", "Lcom/intellij/ml/llm/core/statistics/llmc/RequestPrivateData;", "FALSE_POSITIVE_TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/ml/llm/terminal/LanguageDetectionFalsePositiveType;", "falsePositiveDetectedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "falseNegativeDetectedEvent", "falsePositiveDetected", "", "userInput", "", "falsePositiveType", "shellType", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "falseNegativeDetected", "isEnabled", "", "intellij.ml.llm.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalAiLlmcCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalAiLlmcCollector.kt\ncom/intellij/ml/llm/terminal/TerminalAiCollectorBase\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,95:1\n261#2,3:96\n*S KotlinDebug\n*F\n+ 1 TerminalAiLlmcCollector.kt\ncom/intellij/ml/llm/terminal/TerminalAiCollectorBase\n*L\n20#1:96,3\n*E\n"})
public abstract class TerminalAiCollectorBase
extends CounterUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP;
    @NotNull
    private final RequestPrivateData USER_INPUT_FIELD;
    @NotNull
    private final EnumEventField<LanguageDetectionFalsePositiveType> FALSE_POSITIVE_TYPE_FIELD;
    @NotNull
    private final VarargEventId falsePositiveDetectedEvent;
    @NotNull
    private final VarargEventId falseNegativeDetectedEvent;

    /*
     * WARNING - void declaration
     */
    public TerminalAiCollectorBase(@NotNull EventLogGroup GROUP) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)GROUP, (String)"GROUP");
        this.GROUP = GROUP;
        this.USER_INPUT_FIELD = new RequestPrivateData("user_input");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "type";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        this.FALSE_POSITIVE_TYPE_FIELD = new EnumEventField(name$iv, LanguageDetectionFalsePositiveType.class, null, transform$iv);
        eventFieldArray = new EventField[]{this.USER_INPUT_FIELD, this.FALSE_POSITIVE_TYPE_FIELD, TerminalAiUsageCollector.INSTANCE.getSHELL_TYPE_FIELD()};
        this.falsePositiveDetectedEvent = this.GROUP.registerVarargEvent("language.detection.false.positive.detected", "Natural language was detected when it is actually shell", eventFieldArray);
        eventFieldArray = new EventField[]{this.USER_INPUT_FIELD, TerminalAiUsageCollector.INSTANCE.getSHELL_TYPE_FIELD()};
        this.falseNegativeDetectedEvent = this.GROUP.registerVarargEvent("language.detection.false.negative.detected", "Shell was detected when it is actually a natural language", eventFieldArray);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    public final void falsePositiveDetected(@NotNull String userInput, @NotNull LanguageDetectionFalsePositiveType falsePositiveType, @Nullable ShellType shellType) {
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        Intrinsics.checkNotNullParameter((Object)((Object)falsePositiveType), (String)"falsePositiveType");
        if (!this.isEnabled()) {
            return;
        }
        if (shellType != null) {
            EventPair[] eventPairArray = new EventPair[]{this.USER_INPUT_FIELD.with((Object)userInput), this.FALSE_POSITIVE_TYPE_FIELD.with((Object)falsePositiveType), TerminalAiUsageCollector.INSTANCE.getSHELL_TYPE_FIELD().with((Object)shellType)};
            this.falsePositiveDetectedEvent.log(eventPairArray);
        } else {
            EventPair[] eventPairArray = new EventPair[]{this.USER_INPUT_FIELD.with((Object)userInput), this.FALSE_POSITIVE_TYPE_FIELD.with((Object)falsePositiveType)};
            this.falsePositiveDetectedEvent.log(eventPairArray);
        }
    }

    public final void falseNegativeDetected(@NotNull String userInput, @Nullable ShellType shellType) {
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        if (!this.isEnabled()) {
            return;
        }
        if (shellType != null) {
            EventPair[] eventPairArray = new EventPair[]{this.USER_INPUT_FIELD.with((Object)userInput), TerminalAiUsageCollector.INSTANCE.getSHELL_TYPE_FIELD().with((Object)shellType)};
            this.falseNegativeDetectedEvent.log(eventPairArray);
        } else {
            EventPair[] eventPairArray = new EventPair[]{this.USER_INPUT_FIELD.with((Object)userInput)};
            this.falseNegativeDetectedEvent.log(eventPairArray);
        }
    }

    public abstract boolean isEnabled();
}

