/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.ml.llm.terminal.LanguageDetectionFalsePositiveType;
import com.intellij.ml.llm.terminal.TerminalAiEventsLogger;
import com.intellij.ml.llm.terminal.TerminalAiPromptEventsReporterKt;
import com.intellij.ml.llm.terminal.TerminalAiPromptStateChangeEvent;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeState;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter;", "", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "heuristics", "", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$HeuristicDescriptor;", "curState", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandModeState;", "userInputBeforeAiSwitch", "", "falseDetectionReported", "", "eventHappened", "", "event", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "newState", "languageDetected", "userInput", "createFalseDetectionHeuristics", "commandSearchAndHistoryTransitions", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine$Builder;", "reportFalsePositive", "type", "Lcom/intellij/ml/llm/terminal/LanguageDetectionFalsePositiveType;", "reportFalseNegative", "HeuristicDescriptor", "State", "StateMachine", "intellij.ml.llm.terminal"})
public final class TerminalAiFalseLanguageDetectionsReporter {
    @NotNull
    private final TerminalPromptModel promptModel;
    @NotNull
    private final List<HeuristicDescriptor> heuristics;
    @NotNull
    private TerminalTextToCommandModeState curState;
    @NotNull
    private String userInputBeforeAiSwitch;
    private boolean falseDetectionReported;

    public TerminalAiFalseLanguageDetectionsReporter(@NotNull TerminalPromptModel promptModel) {
        Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
        this.promptModel = promptModel;
        this.heuristics = this.createFalseDetectionHeuristics();
        this.curState = TerminalTextToCommandModeState.SHELL_INPUT;
        this.userInputBeforeAiSwitch = "";
    }

    public final void eventHappened(@NotNull TerminalAiPromptStateChangeEvent event, @NotNull TerminalTextToCommandModeState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.curState = newState;
        if (this.falseDetectionReported) {
            return;
        }
        for (HeuristicDescriptor heuristic : this.heuristics) {
            heuristic.getDetector().handleEvent(event);
            if (!heuristic.getDetector().isCompleted()) continue;
            heuristic.getReport().invoke();
            this.falseDetectionReported = true;
            break;
        }
    }

    public final void languageDetected(@NotNull String userInput) {
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        if (this.curState == TerminalTextToCommandModeState.SHELL_INPUT) {
            this.userInputBeforeAiSwitch = userInput;
        }
    }

    private final List<HeuristicDescriptor> createFalseDetectionHeuristics() {
        List heuristics = new ArrayList();
        StateMachine aiModeDisabledDetector = this.commandSearchAndHistoryTransitions(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(new StateMachine.Builder(), State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.NL_DETECTED, State.AI_MODE, 0L, 8, null), State.AI_MODE, TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED, State.COMPLETED, 0L, 8, null), State.AI_MODE, TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED, State.COMPLETED, 0L, 8, null), State.AI_MODE, TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED, State.COMPLETED, 0L, 8, null), State.AI_MODE, TerminalAiPromptStateChangeEvent.ESCAPE_PRESSED, State.COMPLETED, 0L, 8, null)).build();
        heuristics.add(new HeuristicDescriptor(aiModeDisabledDetector, (Function0<Unit>)((Function0)() -> TerminalAiFalseLanguageDetectionsReporter.createFalseDetectionHeuristics$lambda$0(this))));
        StateMachine textPartRemovedDetector = this.commandSearchAndHistoryTransitions(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(new StateMachine.Builder(), State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.NL_DETECTED, State.AI_MODE, 0L, 8, null), State.AI_MODE, TerminalAiPromptStateChangeEvent.TEXT_PART_REMOVED, State.COMPLETED, 0L, 8, null)).build();
        heuristics.add(new HeuristicDescriptor(textPartRemovedDetector, (Function0<Unit>)((Function0)() -> TerminalAiFalseLanguageDetectionsReporter.createFalseDetectionHeuristics$lambda$1(this))));
        StateMachine commandGenerationInterruptedFastDetector = this.commandSearchAndHistoryTransitions(StateMachine.Builder.transition$default(new StateMachine.Builder(), State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.NL_DETECTED, State.AI_MODE, 0L, 8, null).transition(State.AI_MODE, TerminalAiPromptStateChangeEvent.AI_GENERATION_STARTED, State.AI_GENERATION_IN_PROGRESS, 1000L).transition(State.AI_GENERATION_IN_PROGRESS, TerminalAiPromptStateChangeEvent.AI_GENERATION_INTERRUPTED, State.COMPLETED, 3000L)).build();
        heuristics.add(new HeuristicDescriptor(commandGenerationInterruptedFastDetector, (Function0<Unit>)((Function0)() -> TerminalAiFalseLanguageDetectionsReporter.createFalseDetectionHeuristics$lambda$2(this))));
        StateMachine aiModeEnabledDetector = this.commandSearchAndHistoryTransitions(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(StateMachine.Builder.transition$default(new StateMachine.Builder(), State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.AI_ICON_CLICKED, State.COMPLETED, 0L, 8, null), State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.AI_CONTEXT_MENU_OPTION_CLICKED, State.COMPLETED, 0L, 8, null), State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.AI_SHORTCUT_PRESSED, State.COMPLETED, 0L, 8, null)).build();
        heuristics.add(new HeuristicDescriptor(aiModeEnabledDetector, (Function0<Unit>)((Function0)() -> TerminalAiFalseLanguageDetectionsReporter.createFalseDetectionHeuristics$lambda$3(this))));
        return heuristics;
    }

    private final StateMachine.Builder commandSearchAndHistoryTransitions(StateMachine.Builder $this$commandSearchAndHistoryTransitions) {
        StateMachine.Builder.transition$default($this$commandSearchAndHistoryTransitions, State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.COMMAND_HISTORY_SHOWN, State.SHELL_INPUT_WITHOUT_NL_DETECTION, 0L, 8, null);
        StateMachine.Builder.transition$default($this$commandSearchAndHistoryTransitions, State.SHELL_INPUT, TerminalAiPromptStateChangeEvent.COMMAND_SEARCH_SHOWN, State.SHELL_INPUT_WITHOUT_NL_DETECTION, 0L, 8, null);
        StateMachine.Builder.transition$default($this$commandSearchAndHistoryTransitions, State.SHELL_INPUT_WITHOUT_NL_DETECTION, TerminalAiPromptStateChangeEvent.COMMAND_HISTORY_ABORTED, State.SHELL_INPUT, 0L, 8, null);
        StateMachine.Builder.transition$default($this$commandSearchAndHistoryTransitions, State.SHELL_INPUT_WITHOUT_NL_DETECTION, TerminalAiPromptStateChangeEvent.COMMAND_SEARCH_ABORTED, State.SHELL_INPUT, 0L, 8, null);
        return $this$commandSearchAndHistoryTransitions;
    }

    private final void reportFalsePositive(LanguageDetectionFalsePositiveType type) {
        if (((CharSequence)this.userInputBeforeAiSwitch).length() > 0) {
            TerminalAiEventsLogger.INSTANCE.falsePositiveDetected(this.userInputBeforeAiSwitch, type, TerminalAiPromptEventsReporterKt.getShellType(this.promptModel));
        }
    }

    private final void reportFalseNegative() {
        if (((CharSequence)this.userInputBeforeAiSwitch).length() > 0) {
            TerminalAiEventsLogger.INSTANCE.falseNegativeDetected(this.userInputBeforeAiSwitch, TerminalAiPromptEventsReporterKt.getShellType(this.promptModel));
        }
    }

    private static final Unit createFalseDetectionHeuristics$lambda$0(TerminalAiFalseLanguageDetectionsReporter this$0) {
        this$0.reportFalsePositive(LanguageDetectionFalsePositiveType.AI_MODE_DISABLED);
        return Unit.INSTANCE;
    }

    private static final Unit createFalseDetectionHeuristics$lambda$1(TerminalAiFalseLanguageDetectionsReporter this$0) {
        this$0.reportFalsePositive(LanguageDetectionFalsePositiveType.TEXT_PART_REMOVED);
        return Unit.INSTANCE;
    }

    private static final Unit createFalseDetectionHeuristics$lambda$2(TerminalAiFalseLanguageDetectionsReporter this$0) {
        this$0.reportFalsePositive(LanguageDetectionFalsePositiveType.COMMAND_GENERATION_INTERRUPTED_FAST);
        return Unit.INSTANCE;
    }

    private static final Unit createFalseDetectionHeuristics$lambda$3(TerminalAiFalseLanguageDetectionsReporter this$0) {
        this$0.reportFalseNegative();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$HeuristicDescriptor;", "", "detector", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine;", "report", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine;Lkotlin/jvm/functions/Function0;)V", "getDetector", "()Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine;", "getReport", "()Lkotlin/jvm/functions/Function0;", "intellij.ml.llm.terminal"})
    private static final class HeuristicDescriptor {
        @NotNull
        private final StateMachine detector;
        @NotNull
        private final Function0<Unit> report;

        public HeuristicDescriptor(@NotNull StateMachine detector, @NotNull Function0<Unit> report) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            Intrinsics.checkNotNullParameter(report, (String)"report");
            this.detector = detector;
            this.report = report;
        }

        @NotNull
        public final StateMachine getDetector() {
            return this.detector;
        }

        @NotNull
        public final Function0<Unit> getReport() {
            return this.report;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;", "", "<init>", "(Ljava/lang/String;I)V", "SHELL_INPUT", "SHELL_INPUT_WITHOUT_NL_DETECTION", "AI_MODE", "AI_GENERATION_IN_PROGRESS", "COMPLETED", "FAILED", "intellij.ml.llm.terminal"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State SHELL_INPUT = new State();
        public static final /* enum */ State SHELL_INPUT_WITHOUT_NL_DETECTION = new State();
        public static final /* enum */ State AI_MODE = new State();
        public static final /* enum */ State AI_GENERATION_IN_PROGRESS = new State();
        public static final /* enum */ State COMPLETED = new State();
        public static final /* enum */ State FAILED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.SHELL_INPUT, State.SHELL_INPUT_WITHOUT_NL_DETECTION, State.AI_MODE, State.AI_GENERATION_IN_PROGRESS, State.COMPLETED, State.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine;", "", "transitions", "", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine$Transition;", "<init>", "(Ljava/util/List;)V", "curState", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;", "stateUpdateTimeMillis", "", "isCompleted", "", "()Z", "handleEvent", "", "event", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "Transition", "Builder", "intellij.ml.llm.terminal"})
    private static final class StateMachine {
        @NotNull
        private final List<Transition> transitions;
        @NotNull
        private State curState;
        private long stateUpdateTimeMillis;

        private StateMachine(List<Transition> transitions) {
            this.transitions = transitions;
            this.curState = State.SHELL_INPUT;
            this.stateUpdateTimeMillis = System.currentTimeMillis();
        }

        public final boolean isCompleted() {
            return this.curState == State.COMPLETED;
        }

        public final void handleEvent(@NotNull TerminalAiPromptStateChangeEvent event) {
            Transition transition;
            Object object;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                if (this.curState == State.COMPLETED || this.curState == State.FAILED) {
                    return;
                }
                Iterable iterable = this.transitions;
                for (Object t : iterable) {
                    Transition it = (Transition)t;
                    boolean bl = false;
                    if (!(it.getFromState() == this.curState && it.getEvent() == event && (it.getTimeoutMillis() < 0L || System.currentTimeMillis() - this.stateUpdateTimeMillis < it.getTimeoutMillis()))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((object = (transition = (Transition)v0)) == null || (object = object.getToState()) == null) {
                object = State.FAILED;
            }
            this.curState = object;
            this.stateUpdateTimeMillis = System.currentTimeMillis();
        }

        public /* synthetic */ StateMachine(List transitions, DefaultConstructorMarker $constructor_marker) {
            this(transitions);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine$Builder;", "", "<init>", "()V", "transitions", "", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine$Transition;", "transition", "fromState", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;", "event", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "toState", "timeoutMillis", "", "build", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine;", "intellij.ml.llm.terminal"})
        public static final class Builder {
            @NotNull
            private final List<Transition> transitions = new ArrayList();

            @NotNull
            public final Builder transition(@NotNull State fromState, @NotNull TerminalAiPromptStateChangeEvent event, @NotNull State toState, long timeoutMillis) {
                Intrinsics.checkNotNullParameter((Object)((Object)fromState), (String)"fromState");
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                Intrinsics.checkNotNullParameter((Object)((Object)toState), (String)"toState");
                this.transitions.add(new Transition(fromState, event, toState, timeoutMillis));
                return this;
            }

            public static /* synthetic */ Builder transition$default(Builder builder, State state, TerminalAiPromptStateChangeEvent terminalAiPromptStateChangeEvent, State state2, long l, int n, Object object) {
                if ((n & 8) != 0) {
                    l = -1L;
                }
                return builder.transition(state, terminalAiPromptStateChangeEvent, state2, l);
            }

            @NotNull
            public final StateMachine build() {
                return new StateMachine(this.transitions, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$StateMachine$Transition;", "", "fromState", "Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;", "event", "Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "toState", "timeoutMillis", "", "<init>", "(Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;J)V", "getFromState", "()Lcom/intellij/ml/llm/terminal/TerminalAiFalseLanguageDetectionsReporter$State;", "getEvent", "()Lcom/intellij/ml/llm/terminal/TerminalAiPromptStateChangeEvent;", "getToState", "getTimeoutMillis", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.terminal"})
        private static final class Transition {
            @NotNull
            private final State fromState;
            @NotNull
            private final TerminalAiPromptStateChangeEvent event;
            @NotNull
            private final State toState;
            private final long timeoutMillis;

            public Transition(@NotNull State fromState, @NotNull TerminalAiPromptStateChangeEvent event, @NotNull State toState, long timeoutMillis) {
                Intrinsics.checkNotNullParameter((Object)((Object)fromState), (String)"fromState");
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                Intrinsics.checkNotNullParameter((Object)((Object)toState), (String)"toState");
                this.fromState = fromState;
                this.event = event;
                this.toState = toState;
                this.timeoutMillis = timeoutMillis;
            }

            @NotNull
            public final State getFromState() {
                return this.fromState;
            }

            @NotNull
            public final TerminalAiPromptStateChangeEvent getEvent() {
                return this.event;
            }

            @NotNull
            public final State getToState() {
                return this.toState;
            }

            public final long getTimeoutMillis() {
                return this.timeoutMillis;
            }

            @NotNull
            public final State component1() {
                return this.fromState;
            }

            @NotNull
            public final TerminalAiPromptStateChangeEvent component2() {
                return this.event;
            }

            @NotNull
            public final State component3() {
                return this.toState;
            }

            public final long component4() {
                return this.timeoutMillis;
            }

            @NotNull
            public final Transition copy(@NotNull State fromState, @NotNull TerminalAiPromptStateChangeEvent event, @NotNull State toState, long timeoutMillis) {
                Intrinsics.checkNotNullParameter((Object)((Object)fromState), (String)"fromState");
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                Intrinsics.checkNotNullParameter((Object)((Object)toState), (String)"toState");
                return new Transition(fromState, event, toState, timeoutMillis);
            }

            public static /* synthetic */ Transition copy$default(Transition transition, State state, TerminalAiPromptStateChangeEvent terminalAiPromptStateChangeEvent, State state2, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    state = transition.fromState;
                }
                if ((n & 2) != 0) {
                    terminalAiPromptStateChangeEvent = transition.event;
                }
                if ((n & 4) != 0) {
                    state2 = transition.toState;
                }
                if ((n & 8) != 0) {
                    l = transition.timeoutMillis;
                }
                return transition.copy(state, terminalAiPromptStateChangeEvent, state2, l);
            }

            @NotNull
            public String toString() {
                return "Transition(fromState=" + this.fromState + ", event=" + this.event + ", toState=" + this.toState + ", timeoutMillis=" + this.timeoutMillis + ")";
            }

            public int hashCode() {
                int result = this.fromState.hashCode();
                result = result * 31 + this.event.hashCode();
                result = result * 31 + this.toState.hashCode();
                result = result * 31 + Long.hashCode(this.timeoutMillis);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Transition)) {
                    return false;
                }
                Transition transition = (Transition)other;
                if (this.fromState != transition.fromState) {
                    return false;
                }
                if (this.event != transition.event) {
                    return false;
                }
                if (this.toState != transition.toState) {
                    return false;
                }
                return this.timeoutMillis == transition.timeoutMillis;
            }
        }
    }
}

