/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.features.edit.patch;

import ai.grazie.code.features.edit.patch.FilePatch$;
import ai.koog.agents.core.tools.annotations.LLMDescription;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="FilePatch")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0003()*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006+"}, d2={"Lai/grazie/code/features/edit/patch/FilePatch;", "", "original", "", "replacement", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getOriginal$annotations", "()V", "getOriginal", "()Ljava/lang/String;", "getReplacement$annotations", "getReplacement", "isDelete", "", "()Z", "isReplace", "isRewrite", "validate", "Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult;", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$code_features_edit", "Companion", "ValidationResult", "$serializer", "code-features-edit"})
public final class FilePatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String original;
    @NotNull
    private final String replacement;
    private static final int GLOBAL_PATCH_LIMIT = 100000;

    public FilePatch(@NotNull String original, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        this.original = original;
        this.replacement = replacement;
    }

    @NotNull
    public final String getOriginal() {
        return this.original;
    }

    @LLMDescription(description="The original text to be modified or removed. If empty, the file patch represents a rewrite of whole file")
    public static /* synthetic */ void getOriginal$annotations() {
    }

    @NotNull
    public final String getReplacement() {
        return this.replacement;
    }

    @LLMDescription(description="The replacement text. If empty, the file patch represents a deletion.")
    public static /* synthetic */ void getReplacement$annotations() {
    }

    public final boolean isDelete() {
        return ((CharSequence)this.original).length() > 0 && ((CharSequence)this.replacement).length() == 0;
    }

    public final boolean isReplace() {
        return ((CharSequence)this.original).length() > 0 && ((CharSequence)this.replacement).length() > 0 && !Intrinsics.areEqual((Object)this.original, (Object)this.replacement);
    }

    public final boolean isRewrite() {
        return ((CharSequence)this.original).length() == 0 && ((CharSequence)this.replacement).length() > 0;
    }

    @NotNull
    public final ValidationResult validate() {
        if (this.original.length() > 100000) {
            return new ValidationResult.Invalid("The original text exceeds the character limit");
        }
        if (this.replacement.length() > 100000) {
            return new ValidationResult.Invalid("The replacement text exceeds the character limit");
        }
        return ValidationResult.Valid.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.original;
    }

    @NotNull
    public final String component2() {
        return this.replacement;
    }

    @NotNull
    public final FilePatch copy(@NotNull String original, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return new FilePatch(original, replacement);
    }

    public static /* synthetic */ FilePatch copy$default(FilePatch filePatch, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = filePatch.original;
        }
        if ((n & 2) != 0) {
            string2 = filePatch.replacement;
        }
        return filePatch.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "FilePatch(original=" + this.original + ", replacement=" + this.replacement + ")";
    }

    public int hashCode() {
        int result2 = this.original.hashCode();
        result2 = result2 * 31 + this.replacement.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FilePatch)) {
            return false;
        }
        FilePatch filePatch = (FilePatch)other;
        if (!Intrinsics.areEqual((Object)this.original, (Object)filePatch.original)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.replacement, (Object)filePatch.replacement);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$code_features_edit(FilePatch self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.original);
        output.encodeStringElement(serialDesc, 1, self.replacement);
    }

    public /* synthetic */ FilePatch(int seen0, String original, String replacement, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.original = original;
        this.replacement = replacement;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/grazie/code/features/edit/patch/FilePatch$Companion;", "", "<init>", "()V", "GLOBAL_PATCH_LIMIT", "", "of", "Lai/grazie/code/features/edit/patch/FilePatch;", "original", "", "replacement", "delete", "replace", "rewrite", "serializer", "Lkotlinx/serialization/KSerializer;", "code-features-edit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilePatch of(@NotNull String original, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            if (((CharSequence)original).length() == 0) {
                return this.rewrite(replacement);
            }
            if (((CharSequence)replacement).length() == 0) {
                return this.delete(original);
            }
            return this.replace(original, replacement);
        }

        @NotNull
        public final FilePatch delete(@NotNull String original) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            return new FilePatch(original, "");
        }

        @NotNull
        public final FilePatch replace(@NotNull String original, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            return new FilePatch(original, replacement);
        }

        @NotNull
        public final FilePatch rewrite(@NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            return new FilePatch("", replacement);
        }

        @NotNull
        public final KSerializer<FilePatch> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult;", "", "Valid", "Invalid", "Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult$Invalid;", "Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult$Valid;", "code-features-edit"})
    public static interface ValidationResult {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult$Invalid;", "Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult;", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "code-features-edit"})
        public static final class Invalid
        implements ValidationResult {
            @NotNull
            private final String reason;

            public Invalid(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Invalid copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                return new Invalid(reason);
            }

            public static /* synthetic */ Invalid copy$default(Invalid invalid, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = invalid.reason;
                }
                return invalid.copy(string);
            }

            @NotNull
            public String toString() {
                return "Invalid(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invalid)) {
                    return false;
                }
                Invalid invalid = (Invalid)other;
                return Intrinsics.areEqual((Object)this.reason, (Object)invalid.reason);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult$Valid;", "Lai/grazie/code/features/edit/patch/FilePatch$ValidationResult;", "<init>", "()V", "code-features-edit"})
        public static final class Valid
        implements ValidationResult {
            @NotNull
            public static final Valid INSTANCE = new Valid();

            private Valid() {
            }
        }
    }
}

