/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.model;

import ai.grazie.code.files.model.Language;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\u0005\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u001a\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000bJ\b\u0010\f\u001a\u00020\rH\u0016\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lai/grazie/code/files/model/LanguageSet;", "", "<init>", "()V", "contains", "", "language", "Lai/grazie/code/files/model/Language;", "forEach", "", "action", "Lkotlin/Function1;", "toString", "", "Any", "None", "Some", "Completion", "Companion", "Lai/grazie/code/files/model/LanguageSet$Any;", "Lai/grazie/code/files/model/LanguageSet$None;", "Lai/grazie/code/files/model/LanguageSet$Some;", "code-files-model"})
@SourceDebugExtension(value={"SMAP\nLanguageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageProvider.kt\nai/grazie/code/files/model/LanguageSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1869#2,2:175\n*S KotlinDebug\n*F\n+ 1 LanguageProvider.kt\nai/grazie/code/files/model/LanguageSet\n*L\n94#1:175,2\n*E\n"})
public abstract class LanguageSet {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LanguageSet() {
    }

    public final boolean contains(@NotNull Language language) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageSet languageSet = this;
        if (languageSet instanceof Any) {
            bl = true;
        } else if (languageSet instanceof None) {
            bl = false;
        } else if (languageSet instanceof Some) {
            bl = ((Some)this).getLanguages().contains(language);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final void forEach(@NotNull Function1<? super Language, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        LanguageSet languageSet = this;
        if (languageSet instanceof Any) {
            throw new UnsupportedOperationException("Cannot iterate over Any LanguageSet");
        }
        if (!(languageSet instanceof None)) {
            if (languageSet instanceof Some) {
                Iterable $this$forEach$iv = ((Some)this).getLanguages();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    action.invoke(element$iv);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public String toString() {
        String string;
        LanguageSet languageSet = this;
        if (languageSet instanceof Any) {
            string = "[any]";
        } else if (languageSet instanceof None) {
            string = "[none]";
        } else if (languageSet instanceof Some) {
            string = ((Some)this).getLanguages().size() == 1 ? CollectionsKt.single((Iterable)((Some)this).getLanguages()).toString() : ((Some)this).getLanguages().toString();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public /* synthetic */ LanguageSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lai/grazie/code/files/model/LanguageSet$Any;", "Lai/grazie/code/files/model/LanguageSet;", "<init>", "()V", "code-files-model"})
    public static final class Any
    extends LanguageSet {
        @NotNull
        public static final Any INSTANCE = new Any();

        private Any() {
            super(null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\t\"\u00020\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/code/files/model/LanguageSet$Companion;", "", "<init>", "()V", "of", "Lai/grazie/code/files/model/LanguageSet;", "language", "Lai/grazie/code/files/model/Language;", "languages", "", "(Lai/grazie/code/files/model/Language;[Lai/grazie/code/files/model/Language;)Lai/grazie/code/files/model/LanguageSet;", "code-files-model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageSet of(@NotNull Language language, Language ... languages) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            return new Some(language, Arrays.copyOf(languages, languages.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/grazie/code/files/model/LanguageSet$Completion;", "", "<init>", "()V", "Jet", "code-files-model"})
    public static final class Completion {
        @NotNull
        public static final Completion INSTANCE = new Completion();

        private Completion() {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b1\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0007R\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0007R\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0007R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0007\u00a8\u00066"}, d2={"Lai/grazie/code/files/model/LanguageSet$Completion$Jet;", "", "<init>", "()V", "CPP", "Lai/grazie/code/files/model/LanguageSet;", "getCPP", "()Lai/grazie/code/files/model/LanguageSet;", "CSS", "getCSS", "CSharp", "getCSharp", "Go", "getGo", "Groovy", "getGroovy", "HCL", "getHCL", "HTML", "getHTML", "JSON", "getJSON", "Java", "getJava", "JavaScript", "getJavaScript", "Jupyter", "getJupyter", "Kotlin", "getKotlin", "Markdown", "getMarkdown", "PHP", "getPHP", "Python", "getPython", "Ruby", "getRuby", "Rust", "getRust", "Scala", "getScala", "Shell", "getShell", "Swift", "getSwift", "TOML", "getTOML", "TypeScript", "getTypeScript", "XML", "getXML", "YAML", "getYAML", "code-files-model"})
        public static final class Jet {
            @NotNull
            public static final Jet INSTANCE = new Jet();
            @NotNull
            private static final LanguageSet CPP;
            @NotNull
            private static final LanguageSet CSS;
            @NotNull
            private static final LanguageSet CSharp;
            @NotNull
            private static final LanguageSet Go;
            @NotNull
            private static final LanguageSet Groovy;
            @NotNull
            private static final LanguageSet HCL;
            @NotNull
            private static final LanguageSet HTML;
            @NotNull
            private static final LanguageSet JSON;
            @NotNull
            private static final LanguageSet Java;
            @NotNull
            private static final LanguageSet JavaScript;
            @NotNull
            private static final LanguageSet Jupyter;
            @NotNull
            private static final LanguageSet Kotlin;
            @NotNull
            private static final LanguageSet Markdown;
            @NotNull
            private static final LanguageSet PHP;
            @NotNull
            private static final LanguageSet Python;
            @NotNull
            private static final LanguageSet Ruby;
            @NotNull
            private static final LanguageSet Rust;
            @NotNull
            private static final LanguageSet Scala;
            @NotNull
            private static final LanguageSet Shell;
            @NotNull
            private static final LanguageSet Swift;
            @NotNull
            private static final LanguageSet TOML;
            @NotNull
            private static final LanguageSet TypeScript;
            @NotNull
            private static final LanguageSet XML;
            @NotNull
            private static final LanguageSet YAML;

            private Jet() {
            }

            @NotNull
            public final LanguageSet getCPP() {
                return CPP;
            }

            @NotNull
            public final LanguageSet getCSS() {
                return CSS;
            }

            @NotNull
            public final LanguageSet getCSharp() {
                return CSharp;
            }

            @NotNull
            public final LanguageSet getGo() {
                return Go;
            }

            @NotNull
            public final LanguageSet getGroovy() {
                return Groovy;
            }

            @NotNull
            public final LanguageSet getHCL() {
                return HCL;
            }

            @NotNull
            public final LanguageSet getHTML() {
                return HTML;
            }

            @NotNull
            public final LanguageSet getJSON() {
                return JSON;
            }

            @NotNull
            public final LanguageSet getJava() {
                return Java;
            }

            @NotNull
            public final LanguageSet getJavaScript() {
                return JavaScript;
            }

            @NotNull
            public final LanguageSet getJupyter() {
                return Jupyter;
            }

            @NotNull
            public final LanguageSet getKotlin() {
                return Kotlin;
            }

            @NotNull
            public final LanguageSet getMarkdown() {
                return Markdown;
            }

            @NotNull
            public final LanguageSet getPHP() {
                return PHP;
            }

            @NotNull
            public final LanguageSet getPython() {
                return Python;
            }

            @NotNull
            public final LanguageSet getRuby() {
                return Ruby;
            }

            @NotNull
            public final LanguageSet getRust() {
                return Rust;
            }

            @NotNull
            public final LanguageSet getScala() {
                return Scala;
            }

            @NotNull
            public final LanguageSet getShell() {
                return Shell;
            }

            @NotNull
            public final LanguageSet getSwift() {
                return Swift;
            }

            @NotNull
            public final LanguageSet getTOML() {
                return TOML;
            }

            @NotNull
            public final LanguageSet getTypeScript() {
                return TypeScript;
            }

            @NotNull
            public final LanguageSet getXML() {
                return XML;
            }

            @NotNull
            public final LanguageSet getYAML() {
                return YAML;
            }

            static {
                Language[] languageArray = new Language[]{Language.Companion.getCPP()};
                CPP = Companion.of(Language.Companion.getC(), languageArray);
                languageArray = new Language[]{Language.Companion.getHTML()};
                CSS = Companion.of(Language.Companion.getCSS(), languageArray);
                CSharp = Companion.of(Language.Companion.getCSharp(), new Language[0]);
                Go = Companion.of(Language.Companion.getGo(), new Language[0]);
                Groovy = Companion.of(Language.Companion.getGroovy(), new Language[0]);
                HCL = Companion.of(Language.Companion.getHCL(), new Language[0]);
                languageArray = new Language[]{Language.Companion.getHTML()};
                HTML = Companion.of(Language.Companion.getCSS(), languageArray);
                JSON = Companion.of(Language.Companion.getJSON(), new Language[0]);
                Java = Companion.of(Language.Companion.getJava(), new Language[0]);
                languageArray = new Language[]{Language.Companion.getTypeScript()};
                JavaScript = Companion.of(Language.Companion.getJavaScript(), languageArray);
                Jupyter = Companion.of(Language.Companion.getJupyter(), new Language[0]);
                languageArray = new Language[]{Language.Companion.getKotlinScript()};
                Kotlin = Companion.of(Language.Companion.getKotlin(), languageArray);
                Markdown = Companion.of(Language.Companion.getMarkdown(), new Language[0]);
                PHP = Companion.of(Language.Companion.getPHP(), new Language[0]);
                Python = Companion.of(Language.Companion.getPython(), new Language[0]);
                Ruby = Companion.of(Language.Companion.getRuby(), new Language[0]);
                Rust = Companion.of(Language.Companion.getRust(), new Language[0]);
                Scala = Companion.of(Language.Companion.getScala(), new Language[0]);
                Shell = Companion.of(Language.Companion.getShell(), new Language[0]);
                Swift = Companion.of(Language.Companion.getSwift(), new Language[0]);
                TOML = Companion.of(Language.Companion.getTOML(), new Language[0]);
                languageArray = new Language[]{Language.Companion.getTypeScript()};
                TypeScript = Companion.of(Language.Companion.getJavaScript(), languageArray);
                XML = Companion.of(Language.Companion.getXML(), new Language[0]);
                YAML = Companion.of(Language.Companion.getYAML(), new Language[0]);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lai/grazie/code/files/model/LanguageSet$None;", "Lai/grazie/code/files/model/LanguageSet;", "<init>", "()V", "code-files-model"})
    public static final class None
    extends LanguageSet {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B%\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/grazie/code/files/model/LanguageSet$Some;", "Lai/grazie/code/files/model/LanguageSet;", "languages", "", "Lai/grazie/code/files/model/Language;", "<init>", "(Ljava/util/Set;)V", "language", "", "(Lai/grazie/code/files/model/Language;[Lai/grazie/code/files/model/Language;)V", "getLanguages", "()Ljava/util/Set;", "code-files-model"})
    public static final class Some
    extends LanguageSet {
        @NotNull
        private final Set<Language> languages;

        private Some(Set<? extends Language> languages) {
            super(null);
            this.languages = languages;
            if (!(!((Collection)this.languages).isEmpty())) {
                throw new IllegalStateException("Check failed.");
            }
        }

        @NotNull
        public final Set<Language> getLanguages() {
            return this.languages;
        }

        public Some(@NotNull Language language, Language ... languages) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            this(SetsKt.plus((Set)ArraysKt.toSet((Object[])languages), (Object)language));
        }
    }
}

