/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.vfs;

import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.code.files.vfs.memory.ExtensionsKt;
import ai.grazie.code.files.vfs.memory.VirtualFile;
import ai.grazie.code.files.vfs.memory.VirtualFileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/grazie/code/files/vfs/VirtualSink;", "Lkotlinx/io/RawSink;", "fs", "Lai/grazie/code/files/vfs/memory/VirtualFileSystem;", "path", "Lai/grazie/code/files/vfs/VirtualPath;", "append", "", "<init>", "(Lai/grazie/code/files/vfs/memory/VirtualFileSystem;Lai/grazie/code/files/vfs/VirtualPath;Z)V", "isOpened", "intermediateBuffer", "", "", "targetFile", "Lai/grazie/code/files/vfs/memory/VirtualFile;", "write", "", "source", "Lkotlinx/io/Buffer;", "byteCount", "", "flush", "close", "code-files-vfs"})
@SourceDebugExtension(value={"SMAP\nVirtualSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualSink.kt\nai/grazie/code/files/vfs/VirtualSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class VirtualSink
implements RawSink {
    @NotNull
    private final VirtualFileSystem fs;
    private final boolean append;
    private boolean isOpened;
    @NotNull
    private final List<Byte> intermediateBuffer;
    @NotNull
    private final VirtualFile targetFile;

    public VirtualSink(@NotNull VirtualFileSystem fs, @NotNull VirtualPath path, boolean append) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.fs = fs;
        this.append = append;
        this.isOpened = true;
        this.intermediateBuffer = new ArrayList();
        VirtualFile virtualFile = this.fs.getFile(path);
        if (virtualFile == null) {
            virtualFile = VirtualFileSystem.createFile$default(this.fs, path, null, 2, null);
        }
        this.targetFile = virtualFile;
    }

    public /* synthetic */ VirtualSink(VirtualFileSystem virtualFileSystem, VirtualPath virtualPath, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(virtualFileSystem, virtualPath, bl);
    }

    public void write(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.isOpened) {
            boolean $i$a$-check-VirtualSink$write$22 = false;
            String $i$a$-check-VirtualSink$write$22 = "Virtual Sink is closed. Unable to write to a file sink: '" + this.targetFile.getPath() + "'";
            throw new IllegalStateException($i$a$-check-VirtualSink$write$22.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "Virtual Sink requirement failed. byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (byteCount == 0L) {
            return;
        }
        Buffer writeBuffer = new Buffer();
        source.copyTo(writeBuffer, 0L, byteCount);
        this.intermediateBuffer.addAll(ArraysKt.toList((byte[])SourcesKt.readByteArray((Source)((Source)writeBuffer))));
    }

    public void flush() {
        if (!this.isOpened) {
            boolean bl = false;
            String string = "Virtual Sink is closed. Unable to flush a file sink: '" + this.targetFile.getPath() + "'";
            throw new IllegalStateException(string.toString());
        }
        if (this.intermediateBuffer.isEmpty()) {
            return;
        }
        byte[] newContent = this.append ? ArraysKt.plus((byte[])this.targetFile.getContent(), (byte[])CollectionsKt.toByteArray((Collection)this.intermediateBuffer)) : CollectionsKt.toByteArray((Collection)this.intermediateBuffer);
        ExtensionsKt.writeFile(this.fs, this.targetFile.getPath(), newContent);
        this.intermediateBuffer.clear();
    }

    public void close() {
        if (this.isOpened) {
            this.flush();
            this.isOpened = false;
        }
    }
}

