/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.vfs.provider;

import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.code.files.vfs.VirtualSink;
import ai.grazie.code.files.vfs.VirtualSource;
import ai.grazie.code.files.vfs.memory.ExtensionsKt;
import ai.grazie.code.files.vfs.memory.VirtualEntry;
import ai.grazie.code.files.vfs.memory.VirtualFile;
import ai.grazie.code.files.vfs.memory.VirtualFileSystem;
import ai.grazie.code.files.vfs.memory.VirtualFolder;
import ai.koog.rag.base.files.FileMetadata;
import ai.koog.rag.base.files.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016J)\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0096@\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u00020$2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010/\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u00100J\u001e\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u00104J\u001e\u00105\u001a\u00020$2\u0006\u00102\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u00104J\u0016\u00107\u001a\u00020$2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lai/grazie/code/files/vfs/provider/VfsFileSystemProvider;", "Lai/koog/rag/base/files/FileSystemProvider$ReadWrite;", "Lai/grazie/code/files/vfs/VirtualPath;", "fs", "Lai/grazie/code/files/vfs/memory/VirtualFileSystem;", "<init>", "(Lai/grazie/code/files/vfs/memory/VirtualFileSystem;)V", "toAbsolutePathString", "", "path", "name", "extension", "fromAbsolutePathString", "joinPath", "base", "parts", "", "(Lai/grazie/code/files/vfs/VirtualPath;[Ljava/lang/String;)Lai/grazie/code/files/vfs/VirtualPath;", "metadata", "Lai/koog/rag/base/files/FileMetadata;", "(Lai/grazie/code/files/vfs/VirtualPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFileContentType", "Lai/koog/rag/base/files/FileMetadata$FileContentType;", "list", "", "directory", "parent", "relativize", "root", "exists", "", "readBytes", "", "size", "", "create", "", "type", "Lai/koog/rag/base/files/FileMetadata$FileType;", "(Lai/grazie/code/files/vfs/VirtualPath;Lai/koog/rag/base/files/FileMetadata$FileType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "inputStream", "Lkotlinx/io/Source;", "outputStream", "Lkotlinx/io/Sink;", "append", "(Lai/grazie/code/files/vfs/VirtualPath;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeBytes", "data", "(Lai/grazie/code/files/vfs/VirtualPath;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "move", "source", "target", "(Lai/grazie/code/files/vfs/VirtualPath;Lai/grazie/code/files/vfs/VirtualPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copy", "destination", "delete", "code-files-vfs"})
@SourceDebugExtension(value={"SMAP\nVfsFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsFileSystemProvider.kt\nai/grazie/code/files/vfs/provider/VfsFileSystemProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n12883#2,3:114\n1563#3:117\n1634#3,3:118\n*S KotlinDebug\n*F\n+ 1 VfsFileSystemProvider.kt\nai/grazie/code/files/vfs/provider/VfsFileSystemProvider\n*L\n26#1:114,3\n59#1:117\n59#1:118,3\n*E\n"})
public final class VfsFileSystemProvider
implements FileSystemProvider.ReadWrite<VirtualPath> {
    @NotNull
    private final VirtualFileSystem fs;

    public VfsFileSystemProvider(@NotNull VirtualFileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.fs = fs;
    }

    @Override
    @NotNull
    public String toAbsolutePathString(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.toString();
    }

    @Override
    @NotNull
    public String name(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.getName();
    }

    @Override
    @NotNull
    public String extension(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.getExtension();
    }

    @Override
    @NotNull
    public VirtualPath fromAbsolutePathString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return VirtualPath.Companion.of(path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VirtualPath joinPath(@NotNull VirtualPath base, String ... parts) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        String[] stringArray = parts;
        VirtualPath initial$iv = base;
        boolean $i$f$fold = false;
        VirtualPath accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void part;
            void element$iv;
            void var10_10 = element$iv = $this$fold$iv[i];
            VirtualPath acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.isBlank((CharSequence)((CharSequence)part)) ? acc : acc.resolve((String)part);
        }
        return accumulator$iv;
    }

    @Override
    @Nullable
    public Object metadata(@NotNull VirtualPath path, @NotNull Continuation<? super FileMetadata> $completion) {
        VirtualFile file = this.fs.getFile(path);
        VirtualFolder folder = this.fs.getFolder(path);
        return file != null ? new FileMetadata(FileMetadata.FileType.File, path.isHidden()) : (folder != null ? new FileMetadata(FileMetadata.FileType.Directory, path.isHidden()) : null);
    }

    @Override
    @Nullable
    public Object getFileContentType(@NotNull VirtualPath path, @NotNull Continuation<? super FileMetadata.FileContentType> $completion) {
        VirtualFile file = this.fs.getFile(path);
        if (file == null) {
            throw new IllegalArgumentException("Path is not a file");
        }
        return FileMetadata.FileContentType.Text;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object list(@NotNull VirtualPath directory, @NotNull Continuation<? super List<VirtualPath>> $completion) {
        void $this$mapTo$iv$iv;
        VirtualFolder virtualFolder = this.fs.getFolder(directory);
        if (virtualFolder == null) {
            throw new IllegalStateException(("Directory not found: " + directory).toString());
        }
        VirtualFolder folder = virtualFolder;
        Iterable $this$map$iv = folder.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualEntry virtualEntry = (VirtualEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public VirtualPath parent(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.getParent();
    }

    @Override
    @Nullable
    public String relativize(@NotNull VirtualPath root, @NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.isChildOf(root) ? StringsKt.removePrefix((String)StringsKt.removePrefix((String)path.toString(), (CharSequence)root.toString()), (CharSequence)"/") : null;
    }

    @Override
    @Nullable
    public Object exists(@NotNull VirtualPath path, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((this.fs.getFile(path) != null || this.fs.getFolder(path) != null ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object readBytes(@NotNull VirtualPath path, @NotNull Continuation<? super byte[]> $completion) {
        Object object;
        block3: {
            block2: {
                object = this.fs.getFile(path);
                if (object == null) break block2;
                byte[] byArray = object.getContent();
                object = byArray;
                if (byArray != null) break block3;
            }
            object = new byte[0];
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Object size(@NotNull VirtualPath path, @NotNull Continuation<? super Long> $completion) {
        long l;
        Object object = this.fs.getFile(path);
        if (object != null) {
            byte[] byArray = object.getContent();
            object = byArray;
            if (byArray != null) {
                l = ((Object)object).length;
                return Boxing.boxLong((long)l);
            }
        }
        l = 0L;
        return Boxing.boxLong((long)l);
    }

    @Override
    @Nullable
    public Object create(@NotNull VirtualPath path, @NotNull FileMetadata.FileType type, @NotNull Continuation<? super Unit> $completion) {
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                VirtualEntry virtualEntry = VirtualFileSystem.createFile$default(this.fs, path, null, 2, null);
                break;
            }
            case 2: {
                VirtualEntry virtualEntry = this.fs.createFolders(path);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object inputStream(@NotNull VirtualPath path, @NotNull Continuation<? super Source> $completion) {
        return CoreKt.buffered((RawSource)new VirtualSource(this.fs, path));
    }

    @Override
    @Nullable
    public Object outputStream(@NotNull VirtualPath path, boolean append, @NotNull Continuation<? super Sink> $completion) {
        return CoreKt.buffered((RawSink)new VirtualSink(this.fs, path, append));
    }

    @Override
    @Nullable
    public Object writeBytes(@NotNull VirtualPath path, @NotNull byte[] data2, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.writeFile(this.fs, path, data2);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object move(@NotNull VirtualPath source, @NotNull VirtualPath target, @NotNull Continuation<? super Unit> $completion) {
        this.fs.move(source, target);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object copy(@NotNull VirtualPath source, @NotNull VirtualPath destination, @NotNull Continuation<? super Unit> $completion) {
        this.fs.copy(source, destination);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object delete(@NotNull VirtualPath path, @NotNull Continuation<? super Unit> $completion) {
        this.fs.delete(path);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileMetadata.FileType.values().length];
            try {
                nArray[FileMetadata.FileType.File.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileMetadata.FileType.Directory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

