/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.core.feature.writer;

import ai.koog.agents.core.feature.message.FeatureMessage;
import ai.koog.agents.core.feature.message.FeatureMessageProcessor;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094@\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0013H&J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lai/koog/agents/core/feature/writer/FeatureMessageLogWriter;", "Lai/koog/agents/core/feature/message/FeatureMessageProcessor;", "targetLogger", "Lio/github/oshai/kotlinlogging/KLogger;", "logLevel", "Lai/koog/agents/core/feature/writer/FeatureMessageLogWriter$LogLevel;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;Lai/koog/agents/core/feature/writer/FeatureMessageLogWriter$LogLevel;)V", "getTargetLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "getLogLevel", "()Lai/koog/agents/core/feature/writer/FeatureMessageLogWriter$LogLevel;", "isOpen", "Lkotlinx/coroutines/flow/StateFlow;", "", "()Lkotlinx/coroutines/flow/StateFlow;", "processMessage", "", "message", "Lai/koog/agents/core/feature/message/FeatureMessage;", "(Lai/koog/agents/core/feature/message/FeatureMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toLoggerMessage", "", "isTargetLogLevelEnabled", "targetLogLevel", "Companion", "LogLevel", "agents-core"})
public abstract class FeatureMessageLogWriter
extends FeatureMessageProcessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger targetLogger;
    @NotNull
    private final LogLevel logLevel;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)FeatureMessageLogWriter::logger$lambda$3));

    public FeatureMessageLogWriter(@NotNull KLogger targetLogger, @NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)targetLogger, (String)"targetLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.targetLogger = targetLogger;
        this.logLevel = logLevel;
        if (!this.isTargetLogLevelEnabled(this.logLevel, this.targetLogger)) {
            logger.info((Function0<? extends Object>)((Function0)() -> FeatureMessageLogWriter._init_$lambda$0(this)));
        }
    }

    public /* synthetic */ FeatureMessageLogWriter(KLogger kLogger, LogLevel logLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.INFO;
        }
        this(kLogger, logLevel);
    }

    @NotNull
    protected final KLogger getTargetLogger() {
        return this.targetLogger;
    }

    @NotNull
    protected final LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isOpen() {
        return (StateFlow)StateFlowKt.MutableStateFlow((Object)true);
    }

    @Override
    @Nullable
    protected Object processMessage(@NotNull FeatureMessage message, @NotNull Continuation<? super Unit> $completion) {
        return FeatureMessageLogWriter.processMessage$suspendImpl(this, message, $completion);
    }

    static /* synthetic */ Object processMessage$suspendImpl(FeatureMessageLogWriter $this, FeatureMessage message, Continuation<? super Unit> $completion) {
        String logString = "Received feature message [" + message.getMessageType().getValue() + "]: " + $this.toLoggerMessage(message);
        switch (WhenMappings.$EnumSwitchMapping$0[$this.logLevel.ordinal()]) {
            case 1: {
                $this.targetLogger.info((Function0<? extends Object>)((Function0)() -> FeatureMessageLogWriter.processMessage$lambda$1(logString)));
                break;
            }
            case 2: {
                $this.targetLogger.debug((Function0<? extends Object>)((Function0)() -> FeatureMessageLogWriter.processMessage$lambda$2(logString)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return FeatureMessageLogWriter.close$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object close$suspendImpl(FeatureMessageLogWriter $this, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @NotNull
    public abstract String toLoggerMessage(@NotNull FeatureMessage var1);

    private final boolean isTargetLogLevelEnabled(LogLevel targetLogLevel, KLogger targetLogger) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[targetLogLevel.ordinal()]) {
            case 1: {
                bl = KLogger.DefaultImpls.isInfoEnabled$default(targetLogger, null, 1, null);
                break;
            }
            case 2: {
                bl = KLogger.DefaultImpls.isDebugEnabled$default(targetLogger, null, 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final Object _init_$lambda$0(FeatureMessageLogWriter this$0) {
        return "Please note: Desired log level: '" + this$0.logLevel.name() + "' is disabled for target logger";
    }

    private static final Object processMessage$lambda$1(String $logString) {
        return $logString;
    }

    private static final Object processMessage$lambda$2(String $logString) {
        return $logString;
    }

    private static final Unit logger$lambda$3() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/koog/agents/core/feature/writer/FeatureMessageLogWriter$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "agents-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lai/koog/agents/core/feature/writer/FeatureMessageLogWriter$LogLevel;", "", "<init>", "(Ljava/lang/String;I)V", "INFO", "DEBUG", "agents-core"})
    public static final class LogLevel
    extends Enum<LogLevel> {
        public static final /* enum */ LogLevel INFO = new LogLevel();
        public static final /* enum */ LogLevel DEBUG = new LogLevel();
        private static final /* synthetic */ LogLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String value) {
            return Enum.valueOf(LogLevel.class, value);
        }

        @NotNull
        public static EnumEntries<LogLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = logLevelArray = new LogLevel[]{LogLevel.INFO, LogLevel.DEBUG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

