/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.cache.memory;

import ai.koog.prompt.cache.model.PromptCache;
import ai.koog.prompt.message.Message;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/koog/prompt/cache/memory/InMemoryPromptCache;", "Lai/koog/prompt/cache/model/PromptCache;", "maxEntries", "", "<init>", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "cache", "", "", "Lai/koog/prompt/cache/memory/InMemoryPromptCache$CacheEntry;", "get", "", "Lai/koog/prompt/message/Message$Response;", "request", "Lai/koog/prompt/cache/model/PromptCache$Request;", "(Lai/koog/prompt/cache/model/PromptCache$Request;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "put", "", "response", "(Lai/koog/prompt/cache/model/PromptCache$Request;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "CacheEntry", "prompt-cache-model"})
@SourceDebugExtension(value={"SMAP\nInMemoryPromptCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryPromptCache.kt\nai/koog/prompt/cache/memory/InMemoryPromptCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n2423#2,14:70\n1#3:84\n*S KotlinDebug\n*F\n+ 1 InMemoryPromptCache.kt\nai/koog/prompt/cache/memory/InMemoryPromptCache\n*L\n61#1:70,14\n*E\n"})
public final class InMemoryPromptCache
implements PromptCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer maxEntries;
    @NotNull
    private final Map<String, CacheEntry> cache;

    public InMemoryPromptCache(@Nullable Integer maxEntries) {
        this.maxEntries = maxEntries;
        this.cache = new LinkedHashMap();
    }

    @Override
    @Nullable
    public Object get(@NotNull PromptCache.Request request, @NotNull Continuation<? super List<? extends Message.Response>> $completion) {
        CacheEntry cacheEntry = this.cache.get(request.getAsCacheKey());
        if (cacheEntry == null) {
            return null;
        }
        CacheEntry entry2 = cacheEntry;
        entry2.setAccessed(Clock.System.INSTANCE.now());
        return entry2.getResponse();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object put(@NotNull PromptCache.Request request, @NotNull List<? extends Message.Response> response2, @NotNull Continuation<? super Unit> $completion) {
        String key = request.getAsCacheKey();
        if (this.maxEntries != null && this.cache.size() >= this.maxEntries && !this.cache.containsKey(key)) {
            Object v0;
            void $this$minByOrNull$iv;
            Object object = this.cache.entrySet();
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Map.Entry it = (Map.Entry)minElem$iv;
                    boolean bl = false;
                    Comparable minValue$iv = (Comparable)((CacheEntry)it.getValue()).getAccessed();
                    do {
                        Object e$iv = iterator$iv.next();
                        Map.Entry it2 = (Map.Entry)e$iv;
                        $i$a$-minByOrNull-InMemoryPromptCache$put$2 = false;
                        Comparable v$iv = (Comparable)((CacheEntry)it2.getValue()).getAccessed();
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Map.Entry entry2 = v0;
            if (entry2 != null && (object = (String)entry2.getKey()) != null) {
                Object it = object;
                boolean bl = false;
                this.cache.remove(it);
            }
        }
        this.cache.put(key, new CacheEntry(response2, null, 2, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lai/koog/prompt/cache/memory/InMemoryPromptCache$CacheEntry;", "", "response", "", "Lai/koog/prompt/message/Message$Response;", "accessed", "Lkotlinx/datetime/Instant;", "<init>", "(Ljava/util/List;Lkotlinx/datetime/Instant;)V", "getResponse", "()Ljava/util/List;", "getAccessed", "()Lkotlinx/datetime/Instant;", "setAccessed", "(Lkotlinx/datetime/Instant;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "prompt-cache-model"})
    private static final class CacheEntry {
        @NotNull
        private final List<Message.Response> response;
        @NotNull
        private Instant accessed;

        public CacheEntry(@NotNull List<? extends Message.Response> response2, @NotNull Instant accessed) {
            Intrinsics.checkNotNullParameter(response2, (String)"response");
            Intrinsics.checkNotNullParameter((Object)accessed, (String)"accessed");
            this.response = response2;
            this.accessed = accessed;
        }

        public /* synthetic */ CacheEntry(List list2, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                instant = Clock.System.INSTANCE.now();
            }
            this(list2, instant);
        }

        @NotNull
        public final List<Message.Response> getResponse() {
            return this.response;
        }

        @NotNull
        public final Instant getAccessed() {
            return this.accessed;
        }

        public final void setAccessed(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.accessed = instant;
        }

        @NotNull
        public final List<Message.Response> component1() {
            return this.response;
        }

        @NotNull
        public final Instant component2() {
            return this.accessed;
        }

        @NotNull
        public final CacheEntry copy(@NotNull List<? extends Message.Response> response2, @NotNull Instant accessed) {
            Intrinsics.checkNotNullParameter(response2, (String)"response");
            Intrinsics.checkNotNullParameter((Object)accessed, (String)"accessed");
            return new CacheEntry(response2, accessed);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, List list2, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = cacheEntry.response;
            }
            if ((n & 2) != 0) {
                instant = cacheEntry.accessed;
            }
            return cacheEntry.copy(list2, instant);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(response=" + this.response + ", accessed=" + this.accessed + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.response).hashCode();
            result2 = result2 * 31 + this.accessed.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)other;
            if (!Intrinsics.areEqual(this.response, cacheEntry.response)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.accessed, (Object)cacheEntry.accessed);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lai/koog/prompt/cache/memory/InMemoryPromptCache$Companion;", "Lai/koog/prompt/cache/model/PromptCache$Factory$Named;", "<init>", "()V", "create", "Lai/koog/prompt/cache/model/PromptCache;", "config", "", "prompt-cache-model"})
    @SourceDebugExtension(value={"SMAP\nInMemoryPromptCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryPromptCache.kt\nai/koog/prompt/cache/memory/InMemoryPromptCache$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
    public static final class Companion
    extends PromptCache.Factory.Named {
        private Companion() {
            super("memory");
        }

        @Override
        @NotNull
        public PromptCache create(@NotNull String config) {
            Integer n;
            block6: {
                Integer n2;
                block9: {
                    List<String> parts;
                    block8: {
                        block7: {
                            block5: {
                                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                                parts = this.elements(config);
                                if (!Intrinsics.areEqual((Object)parts.get(0), (Object)"memory")) {
                                    boolean bl = false;
                                    String string = "Invalid cache type: " + parts.get(0) + ". Expected 'memory'.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                if (parts.size() != 1 && !(((CharSequence)parts.get(1)).length() == 0)) break block5;
                                n = null;
                                break block6;
                            }
                            if (!StringsKt.equals((String)parts.get(1), (String)"unlimited", (boolean)true)) break block7;
                            n = null;
                            break block6;
                        }
                        if (StringsKt.startsWith$default((String)parts.get(1), (String)"-", (boolean)false, (int)2, null)) {
                            throw new IllegalStateException(("Invalid memory cache size limit: " + parts.get(1) + ". Expected a positive number or 'unlimited'.").toString());
                        }
                        n2 = StringsKt.toIntOrNull((String)parts.get(1));
                        if (n2 == null) break block8;
                        Integer n3 = n2;
                        int it = ((Number)n3).intValue();
                        boolean bl = false;
                        n2 = it > 0 ? n3 : null;
                        if (n2 != null) break block9;
                    }
                    throw new IllegalStateException(("Invalid memory cache size limit: " + parts.get(1) + ". Expected a positive number or 'unlimited'.").toString());
                }
                n = (int)n2;
            }
            Integer limit = n;
            return new InMemoryPromptCache(limit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

