/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LogbackServiceProvider;
import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import io.github.oshai.kotlinlogging.logback.LogbackExtensionsKt;
import io.github.oshai.kotlinlogging.logback.internal.LogbackLogEvent;
import io.github.oshai.kotlinlogging.slf4j.internal.LocationAwareKLogger;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.KeyValuePair;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00110\u0017\u00a2\u0006\u0002\b\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/oshai/kotlinlogging/logback/internal/LogbackLoggerWrapper;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "Lch/qos/logback/classic/Logger;", "underlyingLogger", "logbackServiceProvider", "Lch/qos/logback/classic/spi/LogbackServiceProvider;", "<init>", "(Lch/qos/logback/classic/Logger;Lch/qos/logback/classic/spi/LogbackServiceProvider;)V", "getUnderlyingLogger", "()Lch/qos/logback/classic/Logger;", "name", "", "getName", "()Ljava/lang/String;", "fqcn", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "isLoggingEnabledFor", "", "kotlin-logging"})
@SourceDebugExtension(value={"SMAP\nLogbackLoggerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogbackLoggerWrapper.kt\nio/github/oshai/kotlinlogging/logback/internal/LogbackLoggerWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,45:1\n1#2:46\n216#3,2:47\n*S KotlinDebug\n*F\n+ 1 LogbackLoggerWrapper.kt\nio/github/oshai/kotlinlogging/logback/internal/LogbackLoggerWrapper\n*L\n36#1:47,2\n*E\n"})
public final class LogbackLoggerWrapper
implements KLogger,
DelegatingKLogger<Logger> {
    @NotNull
    private final Logger underlyingLogger;
    @NotNull
    private final LogbackServiceProvider logbackServiceProvider;
    @NotNull
    private final String fqcn;

    public LogbackLoggerWrapper(@NotNull Logger underlyingLogger, @NotNull LogbackServiceProvider logbackServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        Intrinsics.checkNotNullParameter((Object)logbackServiceProvider, (String)"logbackServiceProvider");
        this.underlyingLogger = underlyingLogger;
        this.logbackServiceProvider = logbackServiceProvider;
        String string = LocationAwareKLogger.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.fqcn = string;
    }

    @Override
    @NotNull
    public Logger getUnderlyingLogger() {
        return this.underlyingLogger;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getUnderlyingLogger().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isLoggingEnabledFor(level, marker)) {
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder $this$at_u24lambda_u242 = kLoggingEventBuilder;
            boolean bl = false;
            LogbackLogEvent logbackEvent = new LogbackLogEvent(this.fqcn, this.getUnderlyingLogger(), level, $this$at_u24lambda_u242);
            Object object = marker;
            if (object != null && (object = LogbackExtensionsKt.toLogback((Marker)object, this.logbackServiceProvider)) != null) {
                Object it = object;
                boolean bl2 = false;
                logbackEvent.addMarker((org.slf4j.Marker)it);
            }
            Map<String, Object> map2 = $this$at_u24lambda_u242.getPayload();
            if (map2 != null) {
                Map<String, Object> $this$forEach$iv = map2;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> element$iv;
                    Map.Entry<String, Object> entry2 = element$iv = iterator.next();
                    boolean bl3 = false;
                    String key = entry2.getKey();
                    Object value = entry2.getValue();
                    logbackEvent.addKeyValuePair(new KeyValuePair(key, value));
                }
            }
            this.getUnderlyingLogger().callAppenders((ILoggingEvent)logbackEvent);
        }
    }

    @Override
    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Marker marker2 = marker;
        return this.getUnderlyingLogger().isEnabledFor(marker2 != null ? LogbackExtensionsKt.toLogback(marker2, this.logbackServiceProvider) : null, LogbackExtensionsKt.toLogbackLevel(level));
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, message);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, throwable, message);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use trace instead", replaceWith=@ReplaceWith(expression="trace(null, marker, msg)", imports={}))
    public void trace(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use trace instead", replaceWith=@ReplaceWith(expression="trace(t, marker, msg)", imports={}))
    public void trace(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace { \"$msg\"}", imports={}))
    public void trace(@Nullable String msg) {
        KLogger.DefaultImpls.trace((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace { \"$msg $arg\"}", imports={}))
    public void trace(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace { \"$msg $arg1 $arg2\"}", imports={}))
    public void trace(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace { \"$msg $arguments\"}", imports={}))
    public void trace(@Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace(t) { \"$msg\"}", imports={}))
    public void trace(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace(marker) { \"$msg\"}", imports={}))
    public void trace(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace(marker) { \"$msg $arg\"}", imports={}))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace(marker) { \"$msg $arg1 $arg2\"}", imports={}))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace(marker) { \"$msg $arguments\"}", imports={}))
    public void trace(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(expression="trace(t, marker) { \"$msg\"}", imports={}))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, t);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, message);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, throwable, message);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use debug instead", replaceWith=@ReplaceWith(expression="debug(null, marker, msg)", imports={}))
    public void debug(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use debug instead", replaceWith=@ReplaceWith(expression="debug(t, marker, msg)", imports={}))
    public void debug(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug { msg }", imports={}))
    public void debug(@Nullable String msg) {
        KLogger.DefaultImpls.debug((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug { \"$msg $arg\"}", imports={}))
    public void debug(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug { \"$msg $arg1 $arg2\"}", imports={}))
    public void debug(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use debug {} instead")
    public void debug(@Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug(t) { \"$msg\"}", imports={}))
    public void debug(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug(marker) { \"$msg\"}", imports={}))
    public void debug(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug(marker) { \"$msg $arg\"}", imports={}))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug(marker) { \"$msg $arg1 $arg2\"}", imports={}))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug(marker) { \"$msg $arguments\"}", imports={}))
    public void debug(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(expression="debug(t, marker) { \"$msg\"}", imports={}))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, t);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, message);
    }

    @Override
    public void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, throwable, message);
    }

    @Override
    public void info(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use info instead", replaceWith=@ReplaceWith(expression="info(null, marker, msg)", imports={}))
    public void info(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use info instead", replaceWith=@ReplaceWith(expression="info(t, marker, msg)", imports={}))
    public void info(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info { msg }", imports={}))
    public void info(@Nullable String msg) {
        KLogger.DefaultImpls.info((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info { \"$msg $arg\"}", imports={}))
    public void info(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.info((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info { \"$msg $arg1 $arg2\"}", imports={}))
    public void info(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.info((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info { \"$msg $arguments\"}", imports={}))
    public void info(@Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.info((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info(t) { \"$msg\"}", imports={}))
    public void info(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.info((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info(marker) { \"$msg\"}", imports={}))
    public void info(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info(marker) { \"$msg $arg\"}", imports={}))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info(marker) { \"$msg $arg1 $arg2\"}", imports={}))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info(marker) { \"$msg $arguments\"}", imports={}))
    public void info(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(expression="info(t, marker) { \"$msg\"}", imports={}))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, t);
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, message);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, throwable, message);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use warn instead", replaceWith=@ReplaceWith(expression="warn(null, marker, msg)", imports={}))
    public void warn(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use warn instead", replaceWith=@ReplaceWith(expression="warn(t, marker, msg)", imports={}))
    public void warn(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn { msg }", imports={}))
    public void warn(@Nullable String msg) {
        KLogger.DefaultImpls.warn((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn { \"$msg $arg\"}", imports={}))
    public void warn(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn { \"$msg $arguments\"}", imports={}))
    public void warn(@Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn { \"$msg $arg1 $arg2\"}", imports={}))
    public void warn(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn(t) { \"$msg\"}", imports={}))
    public void warn(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn(marker) { \"$msg\"}", imports={}))
    public void warn(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn(marker) { \"$msg $arg\"}", imports={}))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn(marker) { \"$msg $arg1 $arg2\"}", imports={}))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn(marker) { \"$msg $arguments\"}", imports={}))
    public void warn(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(expression="warn(t, marker) { \"$msg\"}", imports={}))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, t);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, message);
    }

    @Override
    public void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, throwable, message);
    }

    @Override
    public void error(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use error instead", replaceWith=@ReplaceWith(expression="error(null, marker, msg)", imports={}))
    public void error(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use error instead", replaceWith=@ReplaceWith(expression="error(t, marker, msg)", imports={}))
    public void error(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(expression="error { msg }", imports={}))
    public void error(@Nullable String msg) {
        KLogger.DefaultImpls.error((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(expression="error { \"$msg $arg\"}", imports={}))
    public void error(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.error((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(expression="error { \"$msg $arg1 $arg2\"}", imports={}))
    public void error(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.error((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(expression="error { \"$msg $arguments\"}", imports={}))
    public void error(@Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.error((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use error(t){} instead", replaceWith=@ReplaceWith(expression="error(t) { \"$msg\"}", imports={}))
    public void error(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.error((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(expression="error(marker) { \"$msg\"}", imports={}))
    public void error(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(expression="error(marker) { \"$msg $arg \"}", imports={}))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(expression="error(marker) { \"$msg $arg1 $arg2\"}", imports={}))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(expression="error(marker) { \"$msg $arguments\"}", imports={}))
    public void error(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use error instead", replaceWith=@ReplaceWith(expression="error(t, marker, msg)", imports={}))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, t);
    }

    @Override
    public void atTrace(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atTrace(this, marker, block);
    }

    @Override
    public void atTrace(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atTrace(this, block);
    }

    @Override
    public void atDebug(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atDebug(this, marker, block);
    }

    @Override
    public void atDebug(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atDebug(this, block);
    }

    @Override
    public void atInfo(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atInfo(this, marker, block);
    }

    @Override
    public void atInfo(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atInfo(this, block);
    }

    @Override
    public void atWarn(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atWarn(this, marker, block);
    }

    @Override
    public void atWarn(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atWarn(this, block);
    }

    @Override
    public void atError(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atError(this, marker, block);
    }

    @Override
    public void atError(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atError(this, block);
    }

    @Override
    public void entry(Object ... arguments) {
        KLogger.DefaultImpls.entry(this, arguments);
    }

    @Override
    public void exit() {
        KLogger.DefaultImpls.exit(this);
    }

    @Override
    public <T> T exit(T result2) {
        return KLogger.DefaultImpls.exit(this, result2);
    }

    @Override
    @NotNull
    public <T extends Throwable> T throwing(@NotNull T throwable) {
        return KLogger.DefaultImpls.throwing(this, throwable);
    }

    @Override
    public <T extends Throwable> void catching(@NotNull T throwable) {
        KLogger.DefaultImpls.catching(this, throwable);
    }

    @Override
    public boolean isTraceEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isTraceEnabled(this, marker);
    }

    @Override
    public boolean isTraceEnabled() {
        return KLogger.DefaultImpls.isTraceEnabled(this);
    }

    @Override
    public boolean isDebugEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isDebugEnabled(this, marker);
    }

    @Override
    public boolean isDebugEnabled() {
        return KLogger.DefaultImpls.isDebugEnabled(this);
    }

    @Override
    public boolean isInfoEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isInfoEnabled(this, marker);
    }

    @Override
    public boolean isInfoEnabled() {
        return KLogger.DefaultImpls.isInfoEnabled(this);
    }

    @Override
    public boolean isWarnEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isWarnEnabled(this, marker);
    }

    @Override
    public boolean isWarnEnabled() {
        return KLogger.DefaultImpls.isWarnEnabled(this);
    }

    @Override
    public boolean isErrorEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isErrorEnabled(this, marker);
    }

    @Override
    public boolean isErrorEnabled() {
        return KLogger.DefaultImpls.isErrorEnabled(this);
    }

    @Override
    public boolean isLoggingOff(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isLoggingOff(this, marker);
    }

    @Override
    public boolean isLoggingOff() {
        return KLogger.DefaultImpls.isLoggingOff(this);
    }
}

