/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.slf4j.internal;

import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.KMarkerFactory;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import io.github.oshai.kotlinlogging.internal.MessageInvokerKt;
import io.github.oshai.kotlinlogging.slf4j.Slf4jExtensionsKt;
import io.github.oshai.kotlinlogging.slf4j.internal.Slf4jLogger;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J3\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J\"\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\"\u0010$\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001f\u0010%\u001a\u00020\u001d\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u0002H&H\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010+\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010,\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010-\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010.\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010/\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J%\u00100\u001a\u00020\u001d2\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010302\"\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\u001dH\u0016J!\u00105\u001a\u0002H&\"\n\b\u0000\u0010&*\u0004\u0018\u0001032\u0006\u00106\u001a\u0002H&H\u0016\u00a2\u0006\u0002\u00107J\u001f\u00108\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u0002H&H\u0016\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u00020\u001d2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\u0018\u0010@\u001a\u00020\u001d2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\u0018\u0010A\u001a\u00020\u001d2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\u0018\u0010B\u001a\u00020\u001d2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\u0018\u0010C\u001a\u00020\u001d2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\"\u0010=\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\"\u0010@\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\"\u0010A\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\"\u0010B\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J\"\u0010C\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J,\u0010=\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J,\u0010@\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J,\u0010A\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J,\u0010B\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J,\u0010C\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030?H\u0016J+\u0010D\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J+\u0010E\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J!\u0010E\u001a\u00020\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J+\u0010F\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J!\u0010F\u001a\u00020\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J+\u0010G\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J!\u0010G\u001a\u00020\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J+\u0010H\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016J!\u0010H\u001a\u00020\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b!H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/github/oshai/kotlinlogging/slf4j/internal/LocationAwareKLogger;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "Lorg/slf4j/spi/LocationAwareLogger;", "Lio/github/oshai/kotlinlogging/slf4j/internal/Slf4jLogger;", "underlyingLogger", "<init>", "(Lorg/slf4j/spi/LocationAwareLogger;)V", "getUnderlyingLogger", "()Lorg/slf4j/spi/LocationAwareLogger;", "name", "", "getName", "()Ljava/lang/String;", "fqcn", "ENTRY", "Lorg/slf4j/Marker;", "EXIT", "THROWING", "CATCHING", "EXITONLY", "EXITMESSAGE", "isLoggingEnabledFor", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "at", "", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "logWithPayload", "kLoggingEventBuilder", "logWithoutPayload", "catching", "T", "", "throwable", "(Ljava/lang/Throwable;)V", "isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isLoggingOff", "entry", "arguments", "", "", "([Ljava/lang/Object;)V", "exit", "result", "(Ljava/lang/Object;)Ljava/lang/Object;", "throwing", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "buildMessagePattern", "len", "", "trace", "message", "Lkotlin/Function0;", "debug", "info", "warn", "error", "atTrace", "atDebug", "atInfo", "atWarn", "atError", "kotlin-logging"})
@SourceDebugExtension(value={"SMAP\nLocationAwareKLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationAwareKLogger.kt\nio/github/oshai/kotlinlogging/slf4j/internal/LocationAwareKLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,300:1\n1#2:301\n216#3,2:302\n13409#4,2:304\n*S KotlinDebug\n*F\n+ 1 LocationAwareKLogger.kt\nio/github/oshai/kotlinlogging/slf4j/internal/LocationAwareKLogger\n*L\n60#1:302,2\n61#1:304,2\n*E\n"})
public final class LocationAwareKLogger
extends Slf4jLogger<LocationAwareLogger>
implements KLogger,
DelegatingKLogger<LocationAwareLogger> {
    @NotNull
    private final LocationAwareLogger underlyingLogger;
    @NotNull
    private final String fqcn;
    @NotNull
    private final org.slf4j.Marker ENTRY;
    @NotNull
    private final org.slf4j.Marker EXIT;
    @NotNull
    private final org.slf4j.Marker THROWING;
    @NotNull
    private final org.slf4j.Marker CATCHING;
    @NotNull
    private final String EXITONLY;
    @NotNull
    private final String EXITMESSAGE;

    public LocationAwareKLogger(@NotNull LocationAwareLogger underlyingLogger) {
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        this.underlyingLogger = underlyingLogger;
        String string = LocationAwareKLogger.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.fqcn = string;
        this.ENTRY = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("ENTRY"));
        this.EXIT = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("EXIT"));
        this.THROWING = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("THROWING"));
        this.CATCHING = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("CATCHING"));
        this.EXITONLY = "exit";
        this.EXITMESSAGE = "exit with ({})";
    }

    @Override
    @NotNull
    public LocationAwareLogger getUnderlyingLogger() {
        return this.underlyingLogger;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getUnderlyingLogger().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.isLoggingEnabledFor(this.getUnderlyingLogger(), level, marker);
    }

    @Override
    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isLoggingEnabledFor(level, marker)) {
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder $this$at_u24lambda_u240 = kLoggingEventBuilder;
            boolean bl = false;
            if ($this$at_u24lambda_u240.getPayload() != null) {
                this.logWithPayload($this$at_u24lambda_u240, level, marker);
            } else {
                this.logWithoutPayload($this$at_u24lambda_u240, level, marker);
            }
        }
    }

    private final void logWithPayload(KLoggingEventBuilder kLoggingEventBuilder, Level level, Marker marker) {
        Object[] $this$forEach$iv;
        LoggingEventBuilder builder = this.getUnderlyingLogger().atLevel(Slf4jExtensionsKt.toSlf4j(level));
        Object object = marker;
        if (object != null && (object = Slf4jExtensionsKt.toSlf4j((Marker)object)) != null) {
            Object it = object;
            boolean bl = false;
            builder.addMarker((org.slf4j.Marker)it);
        }
        Object[] objectArray = kLoggingEventBuilder.getPayload();
        if (objectArray != null) {
            $this$forEach$iv = objectArray;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry2 = element$iv = iterator.next();
                boolean bl = false;
                String key = entry2.getKey();
                Object value = entry2.getValue();
                builder.addKeyValue(key, value);
            }
        }
        Object[] objectArray2 = kLoggingEventBuilder.getArguments();
        if (objectArray2 != null) {
            $this$forEach$iv = objectArray2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object arg = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                builder.addArgument(arg);
            }
        }
        builder.setCause(kLoggingEventBuilder.getCause());
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)((Object)builder)).setCallerBoundary(this.fqcn);
        }
        builder.log(kLoggingEventBuilder.getMessage());
    }

    private final void logWithoutPayload(KLoggingEventBuilder kLoggingEventBuilder, Level level, Marker marker) {
        Marker marker2 = marker;
        this.getUnderlyingLogger().log(marker2 != null ? Slf4jExtensionsKt.toSlf4j(marker2) : null, this.fqcn, Slf4jExtensionsKt.toSlf4j(level).toInt(), kLoggingEventBuilder.getMessage(), kLoggingEventBuilder.getArguments(), kLoggingEventBuilder.getCause());
    }

    @Override
    public <T extends Throwable> void catching(@NotNull T throwable) {
        Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
        if (this.getUnderlyingLogger().isErrorEnabled()) {
            this.getUnderlyingLogger().log(this.CATCHING, this.fqcn, 40, "catching", null, throwable);
        }
    }

    @Override
    public boolean isTraceEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.TRACE, marker);
    }

    @Override
    public boolean isDebugEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.DEBUG, marker);
    }

    @Override
    public boolean isInfoEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.INFO, marker);
    }

    @Override
    public boolean isWarnEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.WARN, marker);
    }

    @Override
    public boolean isErrorEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.ERROR, marker);
    }

    @Override
    public boolean isLoggingOff(@Nullable Marker marker) {
        return !this.isLoggingEnabledFor(Level.ERROR, marker);
    }

    @Override
    public void entry(Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (this.getUnderlyingLogger().isTraceEnabled(this.ENTRY)) {
            FormattingTuple tp = MessageFormatter.arrayFormat(this.buildMessagePattern(arguments.length), arguments);
            this.getUnderlyingLogger().log(this.ENTRY, this.fqcn, 0, tp.getMessage(), null, null);
        }
    }

    @Override
    public void exit() {
        if (this.getUnderlyingLogger().isTraceEnabled(this.EXIT)) {
            this.getUnderlyingLogger().log(this.EXIT, this.fqcn, 0, this.EXITONLY, null, null);
        }
    }

    @Override
    public <T> T exit(T result2) {
        if (this.getUnderlyingLogger().isTraceEnabled(this.EXIT)) {
            FormattingTuple tp = MessageFormatter.format(this.EXITMESSAGE, result2);
            Object[] objectArray = new Object[]{result2};
            this.getUnderlyingLogger().log(this.EXIT, this.fqcn, 0, tp.getMessage(), objectArray, tp.getThrowable());
        }
        return result2;
    }

    @Override
    @NotNull
    public <T extends Throwable> T throwing(@NotNull T throwable) {
        Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
        this.getUnderlyingLogger().log(this.THROWING, this.fqcn, 40, "throwing", null, throwable);
        return throwable;
    }

    private final String buildMessagePattern(int len) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, len)), (CharSequence)", ", (CharSequence)"entry with (", (CharSequence)")", (int)0, null, LocationAwareKLogger::buildMessagePattern$lambda$4, (int)24, null);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.TRACE, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.trace$lambda$5(message, arg_0)));
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.DEBUG, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.debug$lambda$6(message, arg_0)));
    }

    @Override
    public void info(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.INFO, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.info$lambda$7(message, arg_0)));
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.WARN, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.warn$lambda$8(message, arg_0)));
    }

    @Override
    public void error(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.ERROR, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.error$lambda$9(message, arg_0)));
    }

    @Override
    public void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.at$default(this, Level.TRACE, null, arg_0 -> LocationAwareKLogger.trace$lambda$10(message, throwable, arg_0), 2, null);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.DEBUG, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.debug$lambda$11(message, throwable, arg_0)));
    }

    @Override
    public void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.INFO, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.info$lambda$12(message, throwable, arg_0)));
    }

    @Override
    public void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.WARN, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.warn$lambda$13(message, throwable, arg_0)));
    }

    @Override
    public void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.ERROR, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.error$lambda$14(message, throwable, arg_0)));
    }

    @Override
    public void trace(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.TRACE, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.trace$lambda$15(message, throwable, arg_0)));
    }

    @Override
    public void debug(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.DEBUG, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.debug$lambda$16(message, throwable, arg_0)));
    }

    @Override
    public void info(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.INFO, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.info$lambda$17(message, throwable, arg_0)));
    }

    @Override
    public void warn(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.WARN, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.warn$lambda$18(message, throwable, arg_0)));
    }

    @Override
    public void error(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.ERROR, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)arg_0 -> LocationAwareKLogger.error$lambda$19(message, throwable, arg_0)));
    }

    @Override
    public void atTrace(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.TRACE, marker, block);
    }

    @Override
    public void atDebug(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.DEBUG, marker, block);
    }

    @Override
    public void atDebug(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.DEBUG, null, block);
    }

    @Override
    public void atInfo(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.INFO, marker, block);
    }

    @Override
    public void atInfo(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.INFO, null, block);
    }

    @Override
    public void atWarn(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.WARN, marker, block);
    }

    @Override
    public void atWarn(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.WARN, null, block);
    }

    @Override
    public void atError(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.ERROR, marker, block);
    }

    @Override
    public void atError(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.ERROR, null, block);
    }

    private static final CharSequence buildMessagePattern$lambda$4(int it) {
        return "{}";
    }

    private static final Unit trace$lambda$5(Function0 $message, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        return Unit.INSTANCE;
    }

    private static final Unit debug$lambda$6(Function0 $message, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        return Unit.INSTANCE;
    }

    private static final Unit info$lambda$7(Function0 $message, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        return Unit.INSTANCE;
    }

    private static final Unit warn$lambda$8(Function0 $message, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        return Unit.INSTANCE;
    }

    private static final Unit error$lambda$9(Function0 $message, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        return Unit.INSTANCE;
    }

    private static final Unit trace$lambda$10(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit debug$lambda$11(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit info$lambda$12(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit warn$lambda$13(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit error$lambda$14(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit trace$lambda$15(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit debug$lambda$16(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit info$lambda$17(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit warn$lambda$18(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit error$lambda$19(Function0 $message, Throwable $throwable, KLoggingEventBuilder $this$at) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)$message));
        $this$at.setCause($throwable);
        return Unit.INSTANCE;
    }
}

