/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FormBodyPart;
import org.apache.hc.client5.http.entity.mime.Header;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class FormBodyPartBuilder {
    private String name;
    private ContentBody body;
    private final Header header = new Header();
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;
    private CharsetEncoder iso8859_1Encoder;

    public static FormBodyPartBuilder create(String name2, ContentBody body, HttpMultipartMode mode) {
        return new FormBodyPartBuilder(name2, body, mode);
    }

    public static FormBodyPartBuilder create(String name2, ContentBody body) {
        return new FormBodyPartBuilder(name2, body, HttpMultipartMode.STRICT);
    }

    public static FormBodyPartBuilder create() {
        return new FormBodyPartBuilder();
    }

    FormBodyPartBuilder(String name2, ContentBody body, HttpMultipartMode mode) {
        this();
        this.name = name2;
        this.body = body;
        this.mode = mode != null ? mode : HttpMultipartMode.STRICT;
    }

    FormBodyPartBuilder() {
    }

    public FormBodyPartBuilder setName(String name2) {
        this.name = name2;
        return this;
    }

    public FormBodyPartBuilder setBody(ContentBody body) {
        this.body = body;
        return this;
    }

    public FormBodyPartBuilder addField(String name2, String value, List<NameValuePair> parameters) {
        Args.notNull(name2, "Field name");
        this.header.addField(new MimeField(name2, value, parameters));
        return this;
    }

    public FormBodyPartBuilder addField(String name2, String value) {
        Args.notNull(name2, "Field name");
        this.header.addField(new MimeField(name2, value));
        return this;
    }

    public FormBodyPartBuilder setField(String name2, String value) {
        Args.notNull(name2, "Field name");
        this.header.setField(new MimeField(name2, value));
        return this;
    }

    public FormBodyPartBuilder removeFields(String name2) {
        Args.notNull(name2, "Field name");
        this.header.removeFields(name2);
        return this;
    }

    private boolean canEncodeToISO8859_1(String input) {
        if (this.iso8859_1Encoder == null) {
            this.iso8859_1Encoder = StandardCharsets.ISO_8859_1.newEncoder();
        }
        return this.iso8859_1Encoder.canEncode(input);
    }

    private static String encodeRFC5987(String filename) {
        return "UTF-8''" + PercentCodec.RFC5987.encode(filename);
    }

    public FormBodyPart build() {
        Asserts.notBlank(this.name, "Name");
        Asserts.notNull(this.body, "Content body");
        Header headerCopy = new Header();
        List<MimeField> fields = this.header.getFields();
        for (MimeField field : fields) {
            headerCopy.addField(field);
        }
        if (headerCopy.getField("Content-Disposition") == null) {
            ArrayList<NameValuePair> fieldParameters = new ArrayList<NameValuePair>();
            fieldParameters.add(new BasicNameValuePair("name", this.name));
            if (this.body.getFilename() != null) {
                String filename = this.body.getFilename();
                fieldParameters.add(new BasicNameValuePair("filename", filename));
                if (this.mode != HttpMultipartMode.LEGACY && !this.canEncodeToISO8859_1(filename)) {
                    fieldParameters.add(new BasicNameValuePair("filename*", FormBodyPartBuilder.encodeRFC5987(filename)));
                }
            }
            headerCopy.addField(new MimeField("Content-Disposition", "form-data", fieldParameters));
        }
        if (headerCopy.getField("Content-Type") == null) {
            ContentType contentType = this.body instanceof AbstractContentBody ? ((AbstractContentBody)this.body).getContentType() : null;
            if (contentType != null) {
                headerCopy.addField(new MimeField("Content-Type", contentType.toString()));
            } else {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.body.getMimeType());
                if (this.body.getCharset() != null) {
                    buffer.append("; charset=");
                    buffer.append(this.body.getCharset());
                }
                headerCopy.addField(new MimeField("Content-Type", buffer.toString()));
            }
        }
        return new FormBodyPart(this.name, this.body, headerCopy);
    }
}

