/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.Socket;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestClientConnControl;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.util.Args;

public class ProxyClient {
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final AuthenticationHandler authenticator;
    private final AuthExchange proxyAuthExchange;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<ManagedHttpClientConnection> connFactory, Http1Config h1Config, CharCodingConfig charCodingConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.builder().http1Config(h1Config).charCodingConfig(charCodingConfig).build();
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new DefaultHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new DefaultAuthenticationStrategy();
        this.authenticator = new AuthenticationHandler();
        this.proxyAuthExchange = new AuthExchange();
        this.authSchemeRegistry = RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).register("Digest", (BasicSchemeFactory)((Object)DigestSchemeFactory.INSTANCE)).build();
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null, null);
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        int status;
        ClassicHttpResponse response2;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        Args.check(target.getPort() > 0, "A valid port number must be provided for the tunnel CONNECT request.");
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.createConnection(null);
        HttpClientContext context2 = HttpClientContext.create();
        BasicClassicHttpRequest connect2 = new BasicClassicHttpRequest(Method.CONNECT, proxy, target.toHostString());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context2.setRequest(connect2);
        context2.setRoute(route);
        context2.setCredentialsProvider(credsProvider);
        context2.setAuthSchemeRegistry(this.authSchemeRegistry);
        context2.setRequestConfig(this.requestConfig);
        this.requestExec.preProcess(connect2, this.httpProcessor, context2);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, connect2, this.proxyAuthExchange, context2);
            response2 = this.requestExec.execute(connect2, conn, context2);
            status = response2.getCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response2);
            }
            if (!this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response2, this.proxyAuthExchange, context2) && !this.authenticator.isChallengeExpected(this.proxyAuthExchange) || !this.authenticator.handleResponse(proxy, ChallengeType.PROXY, response2, this.proxyAuthStrategy, this.proxyAuthExchange, context2)) break;
            if (this.reuseStrategy.keepAlive(connect2, response2, context2)) {
                HttpEntity entity = response2.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect2.removeHeaders("Proxy-Authorization");
        }
        status = response2.getCode();
        if (status > 299) {
            EntityUtils.consume(response2.getEntity());
            conn.close();
            throw new HttpException("Tunnel refused: " + new StatusLine(response2));
        }
        return conn.getSocket();
    }
}

