/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.CompletedFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
@Experimental
public class H2SharingConnPool<T, C extends HttpConnection>
implements ManagedConnPool<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(H2SharingConnPool.class);
    private final ManagedConnPool<T, C> pool;
    private final ConcurrentMap<T, PerRoutePool<T, C>> perRouteCache;
    private final AtomicBoolean closed;

    public H2SharingConnPool(ManagedConnPool<T, C> pool) {
        this.pool = Args.notNull(pool, "Connection pool");
        this.perRouteCache = new ConcurrentHashMap<T, PerRoutePool<T, C>>();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            this.perRouteCache.clear();
            this.pool.close(closeMode);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.perRouteCache.clear();
            this.pool.close();
        }
    }

    PerRoutePool<T, C> getPerRoutePool(T route) {
        return this.perRouteCache.computeIfAbsent(route, r -> new PerRoutePool());
    }

    @Override
    public Future<PoolEntry<T, C>> lease(final T route, final Object state, Timeout requestTimeout, final FutureCallback<PoolEntry<T, C>> callback2) {
        PoolEntry entry2;
        PerRoutePool perRoutePool;
        Asserts.check(!this.closed.get(), "Connection pool shut down");
        if (state == null && (perRoutePool = (PerRoutePool)this.perRouteCache.get(route)) != null && (entry2 = perRoutePool.lease()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sharing connection {} for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(entry2.getConnection()), (Object)perRoutePool.getCount(entry2));
            }
            CompletedFuture future = new CompletedFuture(entry2);
            if (callback2 != null) {
                callback2.completed(entry2);
            }
            return future;
        }
        LOG.debug("No shared connection available");
        return this.pool.lease(route, state, requestTimeout, new CallbackContribution<PoolEntry<T, C>>(callback2){

            @Override
            public void completed(PoolEntry<T, C> entry2) {
                if (state == null) {
                    ProtocolVersion ver;
                    HttpConnection connection = (HttpConnection)entry2.getConnection();
                    ProtocolVersion protocolVersion = ver = connection != null ? connection.getProtocolVersion() : null;
                    if (ver == HttpVersion.HTTP_2_0) {
                        PerRoutePool perRoutePool = H2SharingConnPool.this.getPerRoutePool(route);
                        long count2 = perRoutePool.track(entry2);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Connection {} can be shared for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(entry2.getConnection()), (Object)count2);
                        }
                    }
                }
                if (callback2 != null) {
                    callback2.completed(entry2);
                }
            }
        });
    }

    @Override
    public void release(PoolEntry<T, C> entry2, boolean reusable) {
        long count2;
        if (entry2 == null) {
            return;
        }
        if (this.closed.get()) {
            this.pool.release(entry2, reusable);
            return;
        }
        T route = entry2.getRoute();
        PerRoutePool perRoutePool = (PerRoutePool)this.perRouteCache.get(route);
        if (perRoutePool != null && (count2 = perRoutePool.release(entry2, reusable)) > 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection {} is being shared for message exchange multiplexing (lease count = {})", (Object)ConnPoolSupport.getId(entry2.getConnection()), (Object)count2);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing connection {} back to the pool", (Object)ConnPoolSupport.getId(entry2.getConnection()));
        }
        this.pool.release(entry2, reusable);
    }

    @Override
    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(T route, int max) {
        this.pool.setMaxPerRoute(route, max);
    }

    @Override
    public int getMaxPerRoute(T route) {
        return this.pool.getMaxPerRoute(route);
    }

    @Override
    public void closeIdle(TimeValue idleTime) {
        this.pool.closeIdle(idleTime);
    }

    @Override
    public void closeExpired() {
        this.pool.closeExpired();
    }

    @Override
    public Set<T> getRoutes() {
        return this.pool.getRoutes();
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(T route) {
        return this.pool.getStats(route);
    }

    public String toString() {
        return this.pool.toString();
    }

    static class PerRoutePool<T, C extends HttpConnection> {
        private final Map<PoolEntry<T, C>, AtomicLong> entryMap = new HashMap<PoolEntry<T, C>, AtomicLong>();
        private final Lock lock = new ReentrantLock();

        PerRoutePool() {
        }

        AtomicLong getCounter(PoolEntry<T, C> entry2) {
            return this.entryMap.computeIfAbsent(entry2, e -> new AtomicLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long track(PoolEntry<T, C> entry2) {
            this.lock.lock();
            try {
                AtomicLong counter2 = this.getCounter(entry2);
                long l = counter2.incrementAndGet();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PoolEntry<T, C> lease() {
            this.lock.lock();
            try {
                PoolEntry entry2 = this.entryMap.entrySet().stream().min(Comparator.comparingLong(e -> ((AtomicLong)e.getValue()).get())).map(Map.Entry::getKey).orElse(null);
                if (entry2 == null) {
                    PoolEntry<T, C> poolEntry = null;
                    return poolEntry;
                }
                AtomicLong counter2 = this.getCounter(entry2);
                counter2.incrementAndGet();
                PoolEntry poolEntry = entry2;
                return poolEntry;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long release(PoolEntry<T, C> entry2, boolean reusable) {
            this.lock.lock();
            try {
                HttpConnection connection = (HttpConnection)entry2.getConnection();
                if (!reusable || connection == null || !connection.isOpen()) {
                    this.entryMap.remove(entry2);
                    long l = 0L;
                    return l;
                }
                AtomicLong counter2 = this.entryMap.compute(entry2, (e, c) -> {
                    if (c == null) {
                        return null;
                    }
                    long count2 = c.decrementAndGet();
                    return count2 > 0L ? c : null;
                });
                long l = counter2 != null ? counter2.get() : 0L;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getCount(PoolEntry<T, C> entry2) {
            this.lock.lock();
            try {
                AtomicLong counter2 = this.entryMap.get(entry2);
                long l = counter2 == null ? 0L : counter2.get();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

