/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConformance
implements HttpResponseInterceptor {
    public static final ResponseConformance INSTANCE = new ResponseConformance();

    @Override
    public void process(HttpResponse response2, EntityDetails entity, HttpContext context2) throws HttpException, IOException {
        Args.notNull(response2, "HTTP response");
        int status = response2.getCode();
        switch (status) {
            case 204: 
            case 304: {
                if (entity == null) break;
                throw new ProtocolException("Response " + status + " must not enclose an entity");
            }
        }
    }
}

