/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.ml.llm.LLMOnHoverButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0016\u0010$\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\"\u0010%\u001a\u00020\u001c2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0!H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0!0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*\u00a8\u0006:"}, d2={"Lcom/intellij/ml/llm/LLMStatePresentation;", "S", "", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "initialPresentation", "Lcom/intellij/ml/llm/LLMOnHoverButton;", "initialState", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/LLMOnHoverButton;Ljava/lang/Object;)V", "value", "state", "getState", "()Ljava/lang/Object;", "setState", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "currentPresentation", "getCurrentPresentation", "()Lcom/intellij/ml/llm/LLMOnHoverButton;", "setCurrentPresentation", "(Lcom/intellij/ml/llm/LLMOnHoverButton;)V", "isInside", "", "presentationChangedListeners", "", "Lkotlin/Function0;", "", "getPresentationChangedListeners", "()Ljava/util/List;", "disposeListeners", "stateChangedListeners", "Lkotlin/Function2;", "addPresentationChangedListener", "listener", "addDisposeListener", "addStateChangedListener", "onDispose", "width", "", "getWidth", "()I", "height", "getHeight", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "mouseMoved", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseExited", "intellij.ml.llm.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLLMInlayPresentations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMInlayPresentations.kt\ncom/intellij/ml/llm/LLMStatePresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,589:1\n1869#2,2:590\n1869#2,2:592\n1869#2,2:594\n1869#2,2:596\n*S KotlinDebug\n*F\n+ 1 LLMInlayPresentations.kt\ncom/intellij/ml/llm/LLMStatePresentation\n*L\n93#1:590,2\n120#1:592,2\n142#1:594,2\n151#1:596,2\n*E\n"})
public abstract class LLMStatePresentation<S>
extends BasePresentation {
    @NotNull
    private final Editor editor;
    private S state;
    @NotNull
    private LLMOnHoverButton currentPresentation;
    private boolean isInside;
    @NotNull
    private final List<Function0<Unit>> presentationChangedListeners;
    @NotNull
    private final List<Function0<Unit>> disposeListeners;
    @NotNull
    private final List<Function2<S, S, Unit>> stateChangedListeners;

    public LLMStatePresentation(@NotNull Editor editor, @NotNull LLMOnHoverButton initialPresentation, S initialState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)initialPresentation, (String)"initialPresentation");
        this.editor = editor;
        this.state = initialState;
        this.currentPresentation = initialPresentation;
        this.presentationChangedListeners = new ArrayList();
        this.disposeListeners = new ArrayList();
        this.stateChangedListeners = new ArrayList();
    }

    public final S getState() {
        return this.state;
    }

    public final void setState(S value) {
        Iterable $this$forEach$iv = this.stateChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke(this.state, value);
        }
        this.state = value;
    }

    @NotNull
    protected final LLMOnHoverButton getCurrentPresentation() {
        return this.currentPresentation;
    }

    protected final void setCurrentPresentation(@NotNull LLMOnHoverButton lLMOnHoverButton) {
        Intrinsics.checkNotNullParameter((Object)lLMOnHoverButton, (String)"<set-?>");
        this.currentPresentation = lLMOnHoverButton;
    }

    @NotNull
    protected final List<Function0<Unit>> getPresentationChangedListeners() {
        return this.presentationChangedListeners;
    }

    public void addPresentationChangedListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.presentationChangedListeners.add(listener2);
    }

    public void addDisposeListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.disposeListeners.add(listener2);
    }

    public void addStateChangedListener(@NotNull Function2<? super S, ? super S, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.stateChangedListeners.add(listener2);
    }

    public void onDispose() {
        Iterable $this$forEach$iv = this.disposeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public int getWidth() {
        return this.currentPresentation.getPresentation().getWidth();
    }

    public int getHeight() {
        return this.currentPresentation.getPresentation().getHeight();
    }

    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.currentPresentation.getPresentation().paint(g, attributes);
    }

    @NotNull
    public String toString() {
        return "LLMStatePresentation(" + this.currentPresentation.getPresentation() + ")";
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (!this.isInside) {
            this.isInside = true;
            boolean onHover = this.currentPresentation.mouseEvent(this.editor, true, Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()), event, translated);
            if (onHover) {
                Iterable $this$forEach$iv = this.presentationChangedListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
        }
        super.mouseMoved(event, translated);
    }

    public void mouseExited() {
        if (this.isInside) {
            this.isInside = false;
            boolean onHover = this.currentPresentation.mouseEvent(this.editor, false, Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()), null, null);
            if (onHover) {
                Iterable $this$forEach$iv = this.presentationChangedListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
        }
        super.mouseExited();
    }
}

