/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm;

import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionScaledIconPainter;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/LLMTextWithIconPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Ljavax/swing/Icon;)V", "iconPainter", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionScaledIconPainter;", "iconGap", "", "width", "getWidth", "()I", "height", "getHeight", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "size", "Ljava/awt/Dimension;", "intellij.ml.llm.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLLMInlayPresentations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMInlayPresentations.kt\ncom/intellij/ml/llm/LLMTextWithIconPresentation\n+ 2 graphicsUtil.kt\ncom/intellij/util/ui/GraphicsUtilKt\n*L\n1#1,589:1\n7#2,8:590\n*S KotlinDebug\n*F\n+ 1 LLMInlayPresentations.kt\ncom/intellij/ml/llm/LLMTextWithIconPresentation\n*L\n461#1:590,8\n*E\n"})
public final class LLMTextWithIconPresentation
extends BasePresentation {
    @NotNull
    private final Editor editor;
    @NotNull
    private final InlayPresentation textPresentation;
    @NotNull
    private final Icon icon;
    @NotNull
    private final CodeVisionScaledIconPainter iconPainter;
    private final int iconGap;

    public LLMTextWithIconPresentation(@NotNull Editor editor, @NotNull InlayPresentation textPresentation, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textPresentation, (String)"textPresentation");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.editor = editor;
        this.textPresentation = textPresentation;
        this.icon = icon;
        this.iconPainter = new CodeVisionScaledIconPainter(0.0, 0.0, 3, null);
        this.iconGap = JBUI.scale((int)2);
    }

    public int getWidth() {
        return this.size().width;
    }

    public int getHeight() {
        return this.size().height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        void x$iv;
        void $this$withTranslated$iv;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        int y = ((EditorImpl)editor).getAscent();
        float scaleFactor = this.iconPainter.scaleFactor(this.icon.getIconHeight(), this.size().height);
        this.iconPainter.paint(this.editor, (Graphics)g, this.icon, new Point(0, y), scaleFactor);
        int x = this.iconPainter.width(this.icon, scaleFactor) + this.iconGap;
        Graphics2D graphics2D = g;
        int n = x;
        int y$iv = 0;
        boolean $i$f$withTranslated = false;
        $this$withTranslated$iv.translate((int)x$iv, y$iv);
        try {
            boolean bl = false;
            this.textPresentation.paint(g, attributes);
        }
        finally {
            $this$withTranslated$iv.translate((int)(-x$iv), -y$iv);
        }
    }

    @NotNull
    public String toString() {
        return "LLMTextWithIcon(" + this.textPresentation + ")";
    }

    private final Dimension size() {
        Dimension textSize = new Dimension(this.textPresentation.getWidth(), this.textPresentation.getHeight());
        float scaleFactor = this.iconPainter.scaleFactor(this.icon.getIconHeight(), textSize.height);
        int width = this.iconPainter.width(this.icon, scaleFactor) + this.iconGap;
        return new Dimension(width + textSize.width, textSize.height);
    }
}

