/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.clients.telemetry;

import ai.grazie.model.task.data.TaskStreamData;
import ai.grazie.model.task.data.TaskStreamExecutionMetadata;
import ai.grazie.model.task.data.TaskStreamFunctionCall;
import ai.grazie.model.task.data.TaskStreamQuotaMetaData;
import ai.grazie.model.task.data.TaskStreamText;
import ai.grazie.utils.attributes.Attributes;
import ai.grazie.utils.mpp.money.Credit;
import ai.grazie.utils.mpp.money.Money;
import com.intellij.ml.llm.core.clients.telemetry.AiaSpanAttributeKey;
import io.opentelemetry.api.trace.Span;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/clients/telemetry/AiaTaskStreamAttributeBuilder;", "", "<init>", "()V", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "functionCallName", "", "functionCallContent", "attributes", "Lai/grazie/utils/attributes/Attributes;", "quotaSpent", "Lai/grazie/utils/mpp/money/Credit;", "add", "", "streamingChunk", "Lai/grazie/model/task/data/TaskStreamData;", "buildAndSetSpanAttributes", "span", "Lio/opentelemetry/api/trace/Span;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAiaTaskRequestStreamingWrappers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiaTaskRequestStreamingWrappers.kt\ncom/intellij/ml/llm/core/clients/telemetry/AiaTaskStreamAttributeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class AiaTaskStreamAttributeBuilder {
    @NotNull
    private final StringBuilder textBuilder = new StringBuilder();
    @Nullable
    private String functionCallName;
    @NotNull
    private final StringBuilder functionCallContent = new StringBuilder();
    @NotNull
    private Attributes attributes = Attributes.Companion.getEmpty();
    @NotNull
    private Credit quotaSpent = Credit.Companion.getZERO();

    public final void add(@NotNull TaskStreamData streamingChunk) {
        Intrinsics.checkNotNullParameter((Object)streamingChunk, (String)"streamingChunk");
        TaskStreamData taskStreamData = streamingChunk;
        if (taskStreamData instanceof TaskStreamText) {
            this.textBuilder.append(((TaskStreamText)streamingChunk).getContent());
        } else if (taskStreamData instanceof TaskStreamFunctionCall) {
            String string = ((TaskStreamFunctionCall)streamingChunk).getName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.functionCallName = it;
            }
            this.functionCallContent.append(((TaskStreamFunctionCall)streamingChunk).getContent());
        } else if (taskStreamData instanceof TaskStreamExecutionMetadata) {
            this.attributes = this.attributes.plus(((TaskStreamExecutionMetadata)streamingChunk).getAttributes());
        } else if (taskStreamData instanceof TaskStreamQuotaMetaData) {
            this.quotaSpent = (Credit)this.quotaSpent.plus((Money)((TaskStreamQuotaMetaData)streamingChunk).getSpent());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void buildAndSetSpanAttributes(@NotNull Span span) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            span.setAttribute("gen_ai.usage.cost", this.quotaSpent.getAmount().asDouble());
            String string = this.textBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String text = string;
            int completionIndex = 0;
            if (((CharSequence)text).length() > 0) {
                AiaSpanAttributeKey.Completion keys = new AiaSpanAttributeKey.Completion(completionIndex);
                span.setAttribute(keys.getRole(), "assistant");
                span.setAttribute(keys.getContent(), text);
                ++completionIndex;
            }
            String string2 = this.functionCallName;
            if (string2 == null) break block1;
            String name = string2;
            boolean bl = false;
            AiaSpanAttributeKey.Completion keys = new AiaSpanAttributeKey.Completion(completionIndex);
            span.setAttribute(keys.getRole(), "tool");
            span.setAttribute(keys.getName(), name);
            span.setAttribute(keys.getContent(), this.functionCallContent.toString());
        }
    }
}

