/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptLibrary;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.promptLibrary.AIAssistantStoredPrompt;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariable;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariableKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="AIAssistantPromptLibraryStorage", storages={@Storage(value="AIAssistantPromptLibraryStorage.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0010J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage$State;", "<init>", "()V", "myState", "getState", "loadState", "", "state", "save", "", "prompt", "Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantStoredPrompt;", "saveAll", "prompts", "", "get", "id", "", "getAll", "noStateLoaded", "runMigrations", "Companion", "State", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIAssistantPromptLibraryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantPromptLibraryStorage.kt\ncom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n126#2:125\n153#2,3:126\n3301#3,10:129\n1869#3,2:139\n1056#3:141\n1878#3,3:142\n*S KotlinDebug\n*F\n+ 1 AIAssistantPromptLibraryStorage.kt\ncom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage\n*L\n71#1:125\n71#1:126,3\n97#1:129,10\n98#1:139,2\n99#1:141\n99#1:142,3\n*E\n"})
public final class AIAssistantPromptLibraryStorage
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State myState = new State();
    @NotNull
    private static final String FIND_PROBLEMS_ID = "builtin_findproblems";
    @NotNull
    private static final String NEW_CHAT_ID = "builtin_newchat";

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.runMigrations(state);
        this.myState = state;
    }

    public final boolean save(@NotNull AIAssistantStoredPrompt prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Map<String, AIAssistantStoredPrompt> map2 = this.myState.getPrompts();
        boolean exists = map2.containsKey(prompt.getId());
        map2.put(prompt.getId(), prompt);
        return exists;
    }

    public final void saveAll(@NotNull List<AIAssistantStoredPrompt> prompts) {
        Intrinsics.checkNotNullParameter(prompts, (String)"prompts");
        Map<String, AIAssistantStoredPrompt> map2 = this.myState.getPrompts();
        map2.clear();
        for (AIAssistantStoredPrompt prompt : prompts) {
            map2.put(prompt.getId(), prompt);
        }
    }

    @Nullable
    public final AIAssistantStoredPrompt get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.myState.getPrompts().get(id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AIAssistantStoredPrompt> getAll() {
        void $this$mapTo$iv$iv;
        Map<String, AIAssistantStoredPrompt> $this$map$iv = this.myState.getPrompts();
        boolean $i$f$map = false;
        Map<String, AIAssistantStoredPrompt> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((AIAssistantStoredPrompt)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    public void noStateLoaded() {
        Object[] objectArray = new AIAssistantStoredPrompt[2];
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{AIAssistantPromptLibraryVariableKt.getDollarVariable(AIAssistantPromptLibraryVariable.SELECTION)};
        objectArray[0] = AIAssistantPromptLibraryStorage.noStateLoaded$create$default(FIND_PROBLEMS_ID, ConstantsKt.getPrivacyConst((String)"Find potential problems in %s").format(pSStringConvertibleArray), 100500, false, 8, null);
        objectArray[1] = AIAssistantPromptLibraryStorage.noStateLoaded$create(NEW_CHAT_ID, AIAssistantPromptLibraryVariableKt.getDollarVariable(AIAssistantPromptLibraryVariable.SELECTION), 100500, true);
        List defaultPrompts = CollectionsKt.listOf((Object[])objectArray);
        Map<String, AIAssistantStoredPrompt> p = this.myState.getPrompts();
        for (AIAssistantStoredPrompt prompt : defaultPrompts) {
            p.put(prompt.getId(), prompt);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runMigrations(State state) {
        if (state.getVersion() <= 2) {
            state.getPrompts().remove("builtin_refactoring");
        }
        if (state.getVersion() <= 3) {
            void $this$forEachIndexed$iv;
            AIAssistantStoredPrompt it;
            Iterable $this$partition$iv = state.getPrompts().values();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it = (AIAssistantStoredPrompt)element$iv;
                boolean bl = false;
                boolean bl2 = it.isBuiltIn() ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List builtInPrompts = (List)pair.component1();
            List customPrompts = (List)pair.component2();
            Iterable $this$forEach$iv = builtInPrompts;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AIAssistantStoredPrompt)element$iv;
                boolean bl = false;
                it.setPriority(100500);
            }
            Iterable $this$sortedBy$iv = customPrompts;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AIAssistantStoredPrompt it = (AIAssistantStoredPrompt)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (AIAssistantStoredPrompt)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void prompt;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AIAssistantStoredPrompt aIAssistantStoredPrompt = (AIAssistantStoredPrompt)item$iv;
                int idx = n;
                boolean bl = false;
                prompt.setPriority(idx);
            }
        }
        state.setVersion(3);
    }

    private static final AIAssistantStoredPrompt noStateLoaded$create(String id, PSString prompt, int priority, boolean waitForInput) {
        String string = Companion.localizeId(id);
        Intrinsics.checkNotNull((Object)string);
        return new AIAssistantStoredPrompt(id, string, prompt, waitForInput, true, false, true, true, priority);
    }

    static /* synthetic */ AIAssistantStoredPrompt noStateLoaded$create$default(String string, PSString pSString, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return AIAssistantPromptLibraryStorage.noStateLoaded$create(string, pSString, n, bl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0015\u0010\f\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage;", "FIND_PROBLEMS_ID", "", "getFIND_PROBLEMS_ID", "()Ljava/lang/String;", "NEW_CHAT_ID", "getNEW_CHAT_ID", "localizeId", "Lorg/jetbrains/annotations/Nls;", "id", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nAIAssistantPromptLibraryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantPromptLibraryStorage.kt\ncom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,124:1\n42#2,3:125\n*S KotlinDebug\n*F\n+ 1 AIAssistantPromptLibraryStorage.kt\ncom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage$Companion\n*L\n20#1:125,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIAssistantPromptLibraryStorage getInstance() {
            boolean $i$f$service = false;
            Class<AIAssistantPromptLibraryStorage> serviceClass$iv = AIAssistantPromptLibraryStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AIAssistantPromptLibraryStorage)object;
        }

        @NotNull
        public final String getFIND_PROBLEMS_ID() {
            return FIND_PROBLEMS_ID;
        }

        @NotNull
        public final String getNEW_CHAT_ID() {
            return NEW_CHAT_ID;
        }

        @Nullable
        public final String localizeId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String string = id;
            return Intrinsics.areEqual((Object)string, (Object)this.getFIND_PROBLEMS_ID()) ? LLMBundle.message("prompt.builtin_findproblems", new Object[0]) : (Intrinsics.areEqual((Object)string, (Object)this.getNEW_CHAT_ID()) ? LLMBundle.message("prompt.builtin_newchat", new Object[0]) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage$State;", "", "<init>", "()V", "version", "", "getVersion", "()I", "setVersion", "(I)V", "prompts", "", "", "Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantStoredPrompt;", "getPrompts", "()Ljava/util/Map;", "setPrompts", "(Ljava/util/Map;)V", "intellij.ml.llm.core"})
    public static final class State {
        private int version = 3;
        @NotNull
        private Map<String, AIAssistantStoredPrompt> prompts = new LinkedHashMap();

        public final int getVersion() {
            return this.version;
        }

        public final void setVersion(int n) {
            this.version = n;
        }

        @NotNull
        public final Map<String, AIAssistantStoredPrompt> getPrompts() {
            return this.prompts;
        }

        public final void setPrompts(@NotNull Map<String, AIAssistantStoredPrompt> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.prompts = map2;
        }
    }
}

