/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.providers;

import ai.grazie.model.cloud.ContentType;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileInfo;
import com.intellij.ml.llm.core.providers.AiaLlmProviderType;
import com.intellij.ml.llm.core.providers.LlmCustomModelsSettingsManager;
import com.intellij.ml.llm.core.providers.ThirdPartyAIProvider;
import com.intellij.ml.llm.core.providers.ThirdPartyLLMProfileId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0011H\u0016J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u0019R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/core/providers/AiaThirdPartyProfileInfo;", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileInfo;", "id", "Lcom/intellij/ml/llm/core/providers/ThirdPartyLLMProfileId;", "providerType", "Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;", "<init>", "(Lcom/intellij/ml/llm/core/providers/ThirdPartyLLMProfileId;Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;)V", "getId", "()Lcom/intellij/ml/llm/core/providers/ThirdPartyLLMProfileId;", "getProviderType", "()Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;", "modelName", "", "getModelName", "()Ljava/lang/String;", "deprecated", "", "getDeprecated", "()Z", "experimental", "getExperimental", "contextLimit", "", "getContextLimit", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "maxOutputTokens", "getMaxOutputTokens", "profileIdInJBAIFormat", "getProfileIdInJBAIFormat", "supportsChat", "supportsResponses", "supportsContentType", "type", "Lai/grazie/model/cloud/ContentType;", "supportsToolCalling", "supportsSystemMessage", "supportsReasoningEffort", "intellij.ml.llm.core"})
public abstract class AiaThirdPartyProfileInfo
implements AiaLlmProfileInfo {
    @NotNull
    private final ThirdPartyLLMProfileId id;
    @NotNull
    private final AiaLlmProviderType providerType;
    @NotNull
    private final String modelName;
    private final boolean deprecated;
    private final boolean experimental;
    @Nullable
    private final Integer contextLimit;
    @Nullable
    private final Integer maxOutputTokens;
    @Nullable
    private final String profileIdInJBAIFormat;

    public AiaThirdPartyProfileInfo(@NotNull ThirdPartyLLMProfileId id, @NotNull AiaLlmProviderType providerType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)providerType), (String)"providerType");
        this.id = id;
        this.providerType = providerType;
        this.modelName = this.getId().getId();
        this.contextLimit = LlmCustomModelsSettingsManager.Companion.getInstance().getModelContextSize();
    }

    @Override
    @NotNull
    public ThirdPartyLLMProfileId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public AiaLlmProviderType getProviderType() {
        return this.providerType;
    }

    @Override
    @NotNull
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public boolean getDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental;
    }

    @Override
    @Nullable
    public Integer getContextLimit() {
        return this.contextLimit;
    }

    @Override
    @Nullable
    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Nullable
    public String getProfileIdInJBAIFormat() {
        return this.profileIdInJBAIFormat;
    }

    @Override
    public boolean supportsChat() {
        return true;
    }

    @Override
    public boolean supportsResponses() {
        return false;
    }

    @Override
    public boolean supportsContentType(@NotNull ContentType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return true;
    }

    @Override
    public boolean supportsToolCalling() {
        Object object = ThirdPartyAIProvider.Companion.findById(this.getId().getProviderId());
        return object != null && (object = object.getSettings()) != null ? object.isToolEnabled() : false;
    }

    @Override
    public boolean supportsSystemMessage() {
        return true;
    }

    @Override
    public boolean supportsReasoningEffort() {
        return false;
    }
}

