/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.providers;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="LLMThirdPartyAIProvidersSettings", storages={@Storage(value="llm.third.party.ai.providers.xml", roamingType=RoamingType.DISABLED, exportable=true)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/providers/ThirdPartyAIProvidersSettingsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/core/providers/ThirdPartyAIProvidersSettingsManager$State;", "<init>", "()V", "state", "_enabledProvidersFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "", "enabledProvidersFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getEnabledProvidersFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "getState", "loadState", "", "isProviderEnabled", "", "providerId", "enableProvider", "disableProvider", "enableOnlyOneProvider", "State", "Companion", "intellij.ml.llm.core"})
public final class ThirdPartyAIProvidersSettingsManager
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State();
    @NotNull
    private final MutableStateFlow<Set<String>> _enabledProvidersFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
    @NotNull
    private final StateFlow<Set<String>> enabledProvidersFlow = (StateFlow)this._enabledProvidersFlow;
    @NotNull
    private static final String THIRD_PARTY_ACKNOWLEDGEMENT_KEY = "llm.third.party.ai.services.acknowledgement.accepted";

    @NotNull
    public final StateFlow<Set<String>> getEnabledProvidersFlow() {
        return this.enabledProvidersFlow;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.state = state;
        this._enabledProvidersFlow.setValue((Object)CollectionsKt.toSet((Iterable)state.getEnabledThirdPartyAIProviders()));
    }

    public final boolean isProviderEnabled(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        return Companion.isThirdPartyAIServicesAcknowledgementAccepted() && this.state.getEnabledThirdPartyAIProviders().contains(providerId);
    }

    public final void enableProvider(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        if (Companion.isThirdPartyAIServicesAcknowledgementAccepted()) {
            this.state.getEnabledThirdPartyAIProviders().add(providerId);
            this.state.intIncrementModificationCount();
            this._enabledProvidersFlow.setValue((Object)CollectionsKt.toSet((Iterable)this.state.getEnabledThirdPartyAIProviders()));
        }
    }

    public final void disableProvider(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.state.getEnabledThirdPartyAIProviders().remove(providerId);
        this.state.intIncrementModificationCount();
        this._enabledProvidersFlow.setValue((Object)CollectionsKt.toSet((Iterable)this.state.getEnabledThirdPartyAIProviders()));
    }

    public final void enableOnlyOneProvider(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        if (Companion.isThirdPartyAIServicesAcknowledgementAccepted()) {
            this.state.getEnabledThirdPartyAIProviders().clear();
            this.state.getEnabledThirdPartyAIProviders().add(providerId);
            this.state.intIncrementModificationCount();
            this._enabledProvidersFlow.setValue((Object)CollectionsKt.toSet((Iterable)this.state.getEnabledThirdPartyAIProviders()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/providers/ThirdPartyAIProvidersSettingsManager$Companion;", "", "<init>", "()V", "THIRD_PARTY_ACKNOWLEDGEMENT_KEY", "", "isThirdPartyAIServicesAcknowledgementAccepted", "", "acceptThirdPartyAIServicesAcknowledgement", "", "setThirdPartyAIServicesAcknowledgementAccepted", "accepted", "askForThirdPartyAIServiceAcknowledgementIfNeeded", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nThirdPartyAIProvidersSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThirdPartyAIProvidersSettingsManager.kt\ncom/intellij/ml/llm/core/providers/ThirdPartyAIProvidersSettingsManager$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n13#2:115\n13#2:116\n*S KotlinDebug\n*F\n+ 1 ThirdPartyAIProvidersSettingsManager.kt\ncom/intellij/ml/llm/core/providers/ThirdPartyAIProvidersSettingsManager$Companion\n*L\n76#1:115\n95#1:116\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isThirdPartyAIServicesAcknowledgementAccepted() {
            return PropertiesComponent.getInstance().getBoolean(ThirdPartyAIProvidersSettingsManager.THIRD_PARTY_ACKNOWLEDGEMENT_KEY, false);
        }

        public final void acceptThirdPartyAIServicesAcknowledgement() {
            if (!this.isThirdPartyAIServicesAcknowledgementAccepted()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ThirdPartyAIProvidersSettingsManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Third Party AI Services Acknowledgement accepted", new Throwable());
            }
            PropertiesComponent.getInstance().setValue(ThirdPartyAIProvidersSettingsManager.THIRD_PARTY_ACKNOWLEDGEMENT_KEY, true, false);
        }

        @TestOnly
        public final void setThirdPartyAIServicesAcknowledgementAccepted(boolean accepted) {
            PropertiesComponent.getInstance().setValue(ThirdPartyAIProvidersSettingsManager.THIRD_PARTY_ACKNOWLEDGEMENT_KEY, accepted, false);
        }

        public final void askForThirdPartyAIServiceAcknowledgementIfNeeded(@Nullable Project project) {
            if (this.isThirdPartyAIServicesAcknowledgementAccepted()) {
                return;
            }
            if (AppMode.isHeadless()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ThirdPartyAIProvidersSettingsManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Can't ask to accept third party AI services acknowledgement in headless mode.");
                throw new ProcessCanceledException();
            }
            Object[] objectArray = new Object[]{LLMBundle.message("settings.configurable.display.name", new Object[0]) + " > " + LLMBundle.message("settings.group.third.party.ai.providers", new Object[0])};
            boolean result2 = ((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(LLMBundle.message("dialog.third.party.data.sharing.disclaimer.title", new Object[0]), LLMBundle.message("dialog.third.party.data.sharing.disclaimer.message", objectArray)).asWarning()).ask(project);
            if (!result2) {
                throw new ProcessCanceledException();
            }
            this.acceptThirdPartyAIServicesAcknowledgement();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/providers/ThirdPartyAIProvidersSettingsManager$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "enabledThirdPartyAIProviders", "", "", "getEnabledThirdPartyAIProviders", "()Ljava/util/Set;", "enabledThirdPartyAIProviders$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.ml.llm.core"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty enabledThirdPartyAIProviders$delegate = this.stringSet().provideDelegate((Object)this, $$delegatedProperties[0]);

        @XCollection
        @NotNull
        public final Set<String> getEnabledThirdPartyAIProviders() {
            return (Set)this.enabledThirdPartyAIProviders$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(State.class, "enabledThirdPartyAIProviders", "getEnabledThirdPartyAIProviders()Ljava/util/Set;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

