/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.quota;

import ai.grazie.quota.Quota;
import ai.grazie.utils.mpp.money.Money;
import ai.grazie.utils.mpp.time.Timestamp;
import com.intellij.ml.llm.core.quota.IQuotaManager2;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0004J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/quota/QuotaManager2Base;", "Lcom/intellij/ml/llm/core/quota/IQuotaManager2;", "<init>", "()V", "isEnough", "", "Lai/grazie/quota/Quota;", "current", "Ljava/math/BigDecimal;", "maximum", "until", "Lkotlinx/datetime/Instant;", "intellij.ml.llm.core"})
public abstract class QuotaManager2Base
implements IQuotaManager2 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isEnough(@NotNull Quota $this$isEnough) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnough, (String)"<this>");
        if ($this$isEnough.getCurrent().compareTo((Money)$this$isEnough.getMaximum()) >= 0) return false;
        Timestamp timestamp = $this$isEnough.getUntil();
        if (timestamp == null) return true;
        if (timestamp.after(Timestamp.Companion.now())) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isEnough(@NotNull BigDecimal current, @NotNull BigDecimal maximum, @Nullable Instant until) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)maximum, (String)"maximum");
        if (current.compareTo(maximum) >= 0) return false;
        Instant instant = until;
        if (instant == null) return true;
        int n = instant.compareTo(Clock.System.INSTANCE.now());
        if (n <= 0) return false;
        return true;
    }
}

