/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus.jcp;

import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ml.llm.core.statistics.fus.jcp.ChineseIPCheckService;
import com.intellij.ml.llm.core.statistics.fus.jcp.JcpAnalyticsSender;
import com.intellij.ml.llm.core.statistics.fus.jcp.JcpTokenProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.LicensingFacade;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.analytics.EventAgent;
import org.jetbrains.analytics.EventData;
import org.jetbrains.analytics.EventLogMetadata;
import org.jetbrains.analytics.lifecycle.AnalyticsClient;
import org.jetbrains.analytics.lifecycle.AnalyticsConfig;
import org.jetbrains.analytics.utils.AsBuildNumberKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClient;", "Lcom/intellij/openapi/Disposable;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "jcpTokenProvider", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpTokenProvider;", "analyticsClient", "Lorg/jetbrains/analytics/lifecycle/AnalyticsClient;", "currentJcpToken", "", "isTokenAllowedToSendToJcp", "", "checkIsAllowedToSendToJcp", "token", "submitEvent", "", "event", "Lorg/jetbrains/analytics/EventData;", "dispose", "Companion", "intellij.ml.llm.core"})
public final class JcpAnalyticsClient
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JcpTokenProvider jcpTokenProvider;
    @NotNull
    private final AnalyticsClient analyticsClient;
    @Nullable
    private String currentJcpToken;
    private boolean isTokenAllowedToSendToJcp;
    @NotNull
    private static final String JCP_ANALYTICS_BATCH_SIZE_KEY = "llm.jcp.analytics.batch.size";
    @NotNull
    private static final String JCP_ANALYTICS_EVENTS_THRESHOLD_KEY = "llm.jcp.analytics.events.threshold";
    @NotNull
    private static final String JCP_ANALYTICS_ENABLED = "llm.jcp.analytics.enabled";
    private static final boolean analyticsEnabled = Registry.Companion.is("llm.jcp.analytics.enabled", true);
    @NotNull
    private static final AnalyticsConfig defaultConfig;
    private static final int METADATA_CUSTOMER_COUNTRY_FLAG_POSITION = 28;

    public JcpAnalyticsClient(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.jcpTokenProvider = new JcpTokenProvider(cs);
        this.analyticsClient = new AnalyticsClient(defaultConfig, new JcpAnalyticsSender(this.jcpTokenProvider), null, 4, null);
        if (analyticsEnabled) {
            this.analyticsClient.start(cs);
        }
    }

    private final boolean checkIsAllowedToSendToJcp(String token) {
        if (token == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)token, (Object)this.currentJcpToken)) {
            return this.isTokenAllowedToSendToJcp;
        }
        this.currentJcpToken = token;
        this.isTokenAllowedToSendToJcp = this.analyticsClient.isAllowedToSendToJcp(token);
        return this.isTokenAllowedToSendToJcp;
    }

    public final void submitEvent(@NotNull EventData event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!analyticsEnabled) {
            return;
        }
        if (!this.checkIsAllowedToSendToJcp(this.jcpTokenProvider.getToken())) {
            return;
        }
        this.analyticsClient.recordEvent(event);
    }

    public void dispose() {
        this.analyticsClient.stop();
    }

    static {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String string2 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringWithoutProductCode(...)");
        EventLogMetadata eventLogMetadata = new EventLogMetadata(null, null, null, null, new EventAgent(string, AsBuildNumberKt.asBuildNumber(string2)));
        int n = JcpAnalyticsClient.Companion.getEventsThreshold();
        int n2 = JcpAnalyticsClient.Companion.getBatchSize();
        String[] stringArray = new String[]{"llm-jcp-outbox"};
        Path path = Paths.get(((Object)PathManager.getSystemDir()).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        defaultConfig = new AnalyticsConfig(eventLogMetadata, n, n2, null, null, null, path, 0, null, null, 0.0, 1976, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClient$Companion;", "", "<init>", "()V", "JCP_ANALYTICS_BATCH_SIZE_KEY", "", "JCP_ANALYTICS_EVENTS_THRESHOLD_KEY", "JCP_ANALYTICS_ENABLED", "batchSize", "", "getBatchSize", "()I", "eventsThreshold", "getEventsThreshold", "analyticsEnabled", "", "defaultConfig", "Lorg/jetbrains/analytics/lifecycle/AnalyticsConfig;", "isAllowedToSendData", "isAllowedToSendData$intellij_ml_llm_core", "isChineseUserBasedOnLicenseMetadata", "isChineseUserBasedOnLicenseMetadata$intellij_ml_llm_core", "METADATA_CUSTOMER_COUNTRY_FLAG_POSITION", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getBatchSize() {
            return Registry.Companion.intValue(JcpAnalyticsClient.JCP_ANALYTICS_BATCH_SIZE_KEY);
        }

        private final int getEventsThreshold() {
            return Registry.Companion.intValue(JcpAnalyticsClient.JCP_ANALYTICS_EVENTS_THRESHOLD_KEY);
        }

        public final boolean isAllowedToSendData$intellij_ml_llm_core() {
            boolean isChineseIp = ChineseIPCheckService.Companion.getInstance().getHasChineseIP();
            return !isChineseIp && !this.isChineseUserBasedOnLicenseMetadata$intellij_ml_llm_core() && RegionSettings.getRegion() != Region.CHINA;
        }

        public final boolean isChineseUserBasedOnLicenseMetadata$intellij_ml_llm_core() {
            Object object = LicensingFacade.getInstance();
            if (object == null || (object = ((LicensingFacade)object).metadata) == null) {
                return true;
            }
            Object metadata = object;
            if (((String)metadata).length() <= 28) {
                return true;
            }
            return ((String)metadata).charAt(28) == 'C';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

