/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.ui.activation.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.activation.data.model.AieProvisionStatus;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivationTrackUnknown;
import com.intellij.ml.llm.activation.state.model.IdeLicenseAiAllowancePending;
import com.intellij.ml.llm.activation.state.model.IdeLicenseAiAllowanceStep;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.settings.LlmSettingsUtils;
import com.intellij.ml.llm.core.statistics.fus.AiaLlmLoginFlowEventLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u001a%\u0010\u0000\u001a\u00020\u0005*\u00020\u00072\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u001a\u001c\u0010\b\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"showOnlyIfByokEnabled", "Lcom/intellij/openapi/ui/DialogPanel;", "init", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lkotlin/ExtensionFunctionType;", "Lcom/intellij/ui/dsl/builder/Row;", "byokButton", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\naiaUiElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 aiaUiElements.kt\ncom/intellij/ml/llm/core/ui/activation/util/AiaUiElementsKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,71:1\n42#2,3:72\n*S KotlinDebug\n*F\n+ 1 aiaUiElements.kt\ncom/intellij/ml/llm/core/ui/activation/util/AiaUiElementsKt\n*L\n44#1:72,3\n*E\n"})
public final class AiaUiElementsKt {
    @NotNull
    public static final DialogPanel showOnlyIfByokEnabled(@NotNull Function1<? super Panel, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (!Registry.Companion.is("llm.byok.enabled")) {
            return BuilderKt.panel(AiaUiElementsKt::showOnlyIfByokEnabled$lambda$0);
        }
        return BuilderKt.panel(arg_0 -> AiaUiElementsKt.showOnlyIfByokEnabled$lambda$1(init, arg_0));
    }

    public static final void showOnlyIfByokEnabled(@NotNull Row $this$showOnlyIfByokEnabled, @NotNull Function1<? super Row, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)$this$showOnlyIfByokEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (!Registry.Companion.is("llm.byok.enabled")) {
            return;
        }
        init.invoke((Object)$this$showOnlyIfByokEnabled);
    }

    public static final void byokButton(@NotNull Row $this$byokButton, @NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)$this$byokButton, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        AiaUiElementsKt.showOnlyIfByokEnabled($this$byokButton, (Function1<? super Row, Unit>)((Function1)arg_0 -> AiaUiElementsKt.byokButton$lambda$0(scope, project, arg_0)));
    }

    private static final Unit showOnlyIfByokEnabled$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        return Unit.INSTANCE;
    }

    private static final Unit showOnlyIfByokEnabled$lambda$1(Function1 $init, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $init.invoke((Object)$this$panel);
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0(CoroutineScope $scope, Project $project, Row $this$showOnlyIfByokEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$showOnlyIfByokEnabled, (String)"$this$showOnlyIfByokEnabled");
        boolean $i$f$service = false;
        Class<AiaActivationManager> serviceClass$iv = AiaActivationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AiaActivationManager activationManager = (AiaActivationManager)object;
        StateFlow activationState = FlowKt.stateIn((Flow)activationManager.getActivationState(), (CoroutineScope)$scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)activationManager.getActivation());
        ComponentPredicate isDisabledPredicate = ComponentPredicateKt.predicate((StateFlow)activationState, (CoroutineScope)$scope, AiaUiElementsKt::byokButton$lambda$0$1);
        ComponentPredicate isDisabledByPolicyPredicate = ComponentPredicateKt.predicate((StateFlow)activationState, (CoroutineScope)$scope, AiaUiElementsKt::byokButton$lambda$0$2);
        $this$showOnlyIfByokEnabled.panel(arg_0 -> AiaUiElementsKt.byokButton$lambda$0$3(isDisabledByPolicyPredicate, isDisabledPredicate, $project, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean byokButton$lambda$0$isDisabledByPolicy(AiaActivation activation2) {
        boolean bl;
        if (LlmSettingsUtils.INSTANCE.isProhibitedByProvisioner(activation2.getJbActivation(), (Function1<? super AieProvisionStatus.AieActivated, Boolean>)((Function1)AiaUiElementsKt::byokButton$lambda$0$isDisabledByPolicy$0))) {
            bl = true;
        } else {
            IdeLicenseAiAllowanceStep ideLicenseAiAllowanceStep = activation2.getThirdPartyActivation().getAiAllowanceStep();
            bl = (ideLicenseAiAllowanceStep != null ? (IdeLicenseAiAllowancePending)Outcome.incompleteOrNull-impl((Object)ideLicenseAiAllowanceStep.getOutcome-X8CKn68()) : null) instanceof IdeLicenseAiAllowancePending.IdeLicenseAiProhibited;
        }
        return bl;
    }

    private static final boolean byokButton$lambda$0$isDisabledByPolicy$0(AieProvisionStatus.AieActivated it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isThirdPartyProvidersAllowed();
    }

    private static final boolean byokButton$lambda$0$1(AiaActivation activation2) {
        Intrinsics.checkNotNullParameter((Object)activation2, (String)"activation");
        return activation2.getJbActivation() instanceof AiaActivationTrackUnknown || AiaUiElementsKt.byokButton$lambda$0$isDisabledByPolicy(activation2);
    }

    private static final boolean byokButton$lambda$0$2(AiaActivation activation2) {
        Intrinsics.checkNotNullParameter((Object)activation2, (String)"activation");
        return AiaUiElementsKt.byokButton$lambda$0$isDisabledByPolicy(activation2);
    }

    private static final Unit byokButton$lambda$0$3(ComponentPredicate $isDisabledByPolicyPredicate, ComponentPredicate $isDisabledPredicate, Project $project, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiaUiElementsKt.byokButton$lambda$0$3$0($isDisabledPredicate, $project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, AiaUiElementsKt::byokButton$lambda$0$3$1, (int)1, null).visibleIf($isDisabledByPolicyPredicate);
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$3$0(ComponentPredicate $isDisabledPredicate, Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(LLMBundle.message("panel.byok.button", new Object[0]), arg_0 -> AiaUiElementsKt.byokButton$lambda$0$3$0$0($project, arg_0)).enabledIf(ComponentPredicateKt.not((ComponentPredicate)$isDisabledPredicate));
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$3$0$0(Project $project, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AiaLlmLoginFlowEventLogger.logLoginByokClicked();
            AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance($project).getPanel();
            if (aIAContainerPanelFacade == null) break block0;
            aIAContainerPanelFacade.showByokSettings();
        }
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$3$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        $this$row.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Row.comment$default((Row)$this$row, (String)LLMBundle.message("panel.byok.button.disabled.by.aie", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }
}

