/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie;

import ai.grazie.model.cloud.exceptions.HTTPStatusException;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIAssistantForbiddenException;
import com.intellij.ml.llm.grazie.AIAssistantChatException;
import com.intellij.ml.llm.grazie.ErrorStateAction;
import com.intellij.ml.llm.grazie.ErrorStateDescriptor;
import com.intellij.ml.llm.grazie.GrazieError;
import com.intellij.ml.llm.grazie.GrazieErrorDescription;
import com.intellij.ml.llm.grazie.GrazieErrorEnum;
import com.intellij.ml.llm.grazie.OutOfQuotaError;
import com.intellij.ml.llm.grazie.client.GrazieApiClientProvider;
import com.intellij.ml.llm.tokenizer.TokenLimitExceededException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.http.HttpConnectTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u001a/\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u0006*\u00020\u00042\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\bH\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getErrorDescriptor", "Lcom/intellij/ml/llm/grazie/ErrorStateDescriptor;", "", "findCause", "T", "predicate", "Lkotlin/Function1;", "(Ljava/lang/Throwable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getErrorState", "error", "extractGrazieReason", "Lcom/intellij/ml/llm/grazie/GrazieErrorEnum;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nGrazieErrorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieErrorUtil.kt\ncom/intellij/ml/llm/grazie/GrazieErrorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,342:1\n1#2:343\n170#3,6:344\n57#4:350\n35#4,2:351\n*S KotlinDebug\n*F\n+ 1 GrazieErrorUtil.kt\ncom/intellij/ml/llm/grazie/GrazieErrorUtilKt\n*L\n313#1:344,6\n28#1:350\n28#1:351,2\n*E\n"})
public final class GrazieErrorUtilKt {
    @NotNull
    private static final Logger logger;

    @Nullable
    public static final ErrorStateDescriptor getErrorDescriptor(@NotNull Throwable $this$getErrorDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getErrorDescriptor, (String)"<this>");
        return (ErrorStateDescriptor)GrazieErrorUtilKt.findCause($this$getErrorDescriptor, GrazieErrorUtilKt::getErrorDescriptor$lambda$0);
    }

    private static final <T> T findCause(Throwable $this$findCause, Function1<? super Throwable, ? extends T> predicate) {
        for (Throwable cur = $this$findCause; cur != null; cur = cur.getCause()) {
            Object cause = predicate.invoke((Object)cur);
            if (cause == null) continue;
            return (T)cause;
        }
        return null;
    }

    private static final ErrorStateDescriptor getErrorState(Throwable error) {
        ErrorStateDescriptor errorStateDescriptor;
        if (error instanceof UnresolvedAddressException || error instanceof HttpConnectTimeoutException || error instanceof ConnectException) {
            Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.no.internet.connection", objectArray), LLMBundle.message("llm.link.try.again", new Object[0]), ErrorStateAction.DefaultRetry.INSTANCE);
        } else if (error instanceof HTTPStatusException.Forbidden) {
            Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.failed.to.log.in.forbidden.403", objectArray), LLMBundle.message("llm.error.manage.license", new Object[0]), ErrorStateAction.ShowLicensePickerView.INSTANCE);
        } else if (error instanceof HTTPStatusException.Unauthorized || error instanceof HTTPStatusException.AccessProhibited || GrazieApiClientProvider.Companion.isAuthorizationException(error)) {
            Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.failed.to.log.in.unauthorized.401", objectArray), LLMBundle.message("llm.error.manage.license", new Object[0]), ErrorStateAction.ShowLicensePickerView.INSTANCE);
        } else if (error instanceof HTTPStatusException.NotFound) {
            Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.not.found.404", objectArray), LLMBundle.message("llm.error.manage.license", new Object[0]), ErrorStateAction.ShowLicensePickerView.INSTANCE);
        } else if (error instanceof HTTPStatusException.BadRequest) {
            GrazieErrorEnum reason;
            Object $i$a$-runCatching-GrazieErrorUtilKt$getErrorState$reason$22;
            try {
                boolean $i$a$-runCatching-GrazieErrorUtilKt$getErrorState$reason$22 = false;
                $i$a$-runCatching-GrazieErrorUtilKt$getErrorState$reason$22 = Result.constructor-impl((Object)((Object)GrazieErrorUtilKt.extractGrazieReason(error)));
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-GrazieErrorUtilKt$getErrorState$reason$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            GrazieErrorEnum grazieErrorEnum = reason = (GrazieErrorEnum)((Object)LoggerKt.getOrLogException((Object)$i$a$-runCatching-GrazieErrorUtilKt$getErrorState$reason$22, (Logger)logger));
            errorStateDescriptor = (grazieErrorEnum == null ? -1 : WhenMappings.$EnumSwitchMapping$0[grazieErrorEnum.ordinal()]) == 1 ? (ErrorStateDescriptor)new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.too.long", new Object[0]), reason) : (ErrorStateDescriptor)new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.unknown.link", new Object[0]), LLMBundle.message("llm.link.try.again", new Object[0]), ErrorStateAction.DefaultRetry.INSTANCE);
        } else if (error instanceof HTTPStatusException.TooManyRequests) {
            Object[] reason = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.overloaded.429", reason), LLMBundle.message("llm.link.try.again", new Object[0]), ErrorStateAction.DefaultRetry.INSTANCE);
        } else if (error instanceof HTTPStatusException.UnavailableForLegalReasons) {
            Object[] reason = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.location", reason), null, 2, null);
        } else if (error instanceof HTTPStatusException.Conflict) {
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.conflict", new Object[0]), LLMBundle.message("llm.link.try.again", new Object[0]), ErrorStateAction.DefaultRetry.INSTANCE);
        } else if (error instanceof HTTPStatusException.UnprocessableContent) {
            Object[] reason = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.unprocessable", reason), null, 2, null);
        } else if (error instanceof HTTPStatusException.ContentTooLarge) {
            errorStateDescriptor = new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.too.large", new Object[0]), null, 2, null);
        } else if (error instanceof HTTPStatusException.InternalServerError) {
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.internal.server.error.500", new Object[0]), LLMBundle.message("llm.link.try.again", new Object[0]), ErrorStateAction.DefaultRetry.INSTANCE);
        } else if (error instanceof TokenLimitExceededException) {
            errorStateDescriptor = new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.too.large", new Object[0]), null, 2, null);
        } else if (error instanceof HTTPStatusException && ((HTTPStatusException)error).isServerError()) {
            errorStateDescriptor = new ErrorStateDescriptor.Actionable(LLMBundle.message("llm.error.server", new Object[0]), LLMBundle.message("llm.link.try.again", new Object[0]), ErrorStateAction.DefaultRetry.INSTANCE);
        } else if (error instanceof AIAssistantForbiddenException && !((AIAssistantForbiddenException)error).getLevel().isProjectLevel()) {
            Object[] reason = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.killswitch.machine", reason), null, 2, null);
        } else if (error instanceof AIAssistantForbiddenException && ((AIAssistantForbiddenException)error).getLevel().isProjectLevel()) {
            Object[] reason = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            errorStateDescriptor = new ErrorStateDescriptor.Informative(LLMBundle.message("llm.error.killswitch.project", reason), null, 2, null);
        } else {
            int code;
            OutOfQuotaError quotaError;
            errorStateDescriptor = error instanceof HTTPStatusException ? ((quotaError = OutOfQuotaError.Companion.fromCode(code = ((HTTPStatusException)error).getStatus())) != null ? ErrorStateDescriptor.Companion.OutOfPrompts(quotaError) : (ErrorStateDescriptor)ErrorStateDescriptor.Companion.getDefault()) : (error instanceof AIAssistantChatException ? (ErrorStateDescriptor)new ErrorStateDescriptor.Actionable(((AIAssistantChatException)error).getMessage(), ((AIAssistantChatException)error).getLinkMessage(), ((AIAssistantChatException)error).getAction()) : null);
        }
        return errorStateDescriptor;
    }

    private static final GrazieErrorEnum extractGrazieReason(Throwable error) {
        String string;
        int jsonEnd;
        int jsonStart;
        String message;
        block7: {
            int n;
            if (error == null || !(error instanceof HTTPStatusException)) {
                return GrazieErrorEnum.Unknown;
            }
            String string2 = ((HTTPStatusException)error).getMessage();
            if (string2 == null) {
                return GrazieErrorEnum.Unknown;
            }
            message = string2;
            jsonStart = StringsKt.indexOf$default((CharSequence)message, (char)'{', (int)0, (boolean)false, (int)6, null);
            CharSequence $this$indexOfLast$iv = message;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '}')) continue;
                    n = index$iv;
                    break block7;
                } while (0 <= n2);
            }
            n = jsonEnd = -1;
        }
        if (jsonStart < 0 || jsonEnd < 1) {
            return GrazieErrorEnum.Unknown;
        }
        String jsonString = StringsKt.substring((String)message, (IntRange)new IntRange(jsonStart, jsonEnd));
        try {
            GrazieErrorDescription grazieErrorDescription = ((GrazieError)new Gson().fromJson(jsonString, GrazieError.class)).getError();
            string = grazieErrorDescription != null ? grazieErrorDescription.getCode() : null;
        }
        catch (JsonSyntaxException e) {
            logger.warn("Can't parse Grazie error description: " + jsonString, (Throwable)e);
            return GrazieErrorEnum.Unknown;
        }
        String result2 = string;
        return Intrinsics.areEqual((Object)result2, (Object)"context_length_exceeded") ? GrazieErrorEnum.ContentLengthExceeded : GrazieErrorEnum.Unknown;
    }

    private static final ErrorStateDescriptor getErrorDescriptor$lambda$0(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GrazieErrorUtilKt.getErrorState(it);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GrazieErrorUtilKt.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GrazieErrorEnum.values().length];
            try {
                nArray[GrazieErrorEnum.ContentLengthExceeded.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

