/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie.tasks.python;

import ai.grazie.model.task.exec.TaskParameters;
import ai.grazie.model.task.exec.TaskParametersBuilder;
import ai.grazie.model.task.id.TaskName;
import ai.grazie.model.task.id.TaskNameDescriptor;
import ai.grazie.model.task.id.TaskSchemaDescriptor;
import ai.grazie.model.task.id.TaskTag;
import ai.grazie.model.task.id.TaskTagDescriptor;
import ai.grazie.utils.attributes.AttributeDescriptor;
import com.intellij.ml.llm.core.promptlog.CodeSnippet;
import com.intellij.ml.llm.tasks.GrazieTaskCall;
import com.intellij.ml.llm.tasks.context.TaskContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/python/PythonConvertLoopToComprehensionTask;", "Lai/grazie/model/task/id/TaskNameDescriptor;", "<init>", "()V", "name", "Lai/grazie/model/task/id/TaskName;", "getName", "()Lai/grazie/model/task/id/TaskName;", "default", "Lcom/intellij/ml/llm/tasks/GrazieTaskCall;", "loopContext", "Lcom/intellij/ml/llm/core/promptlog/CodeSnippet;", "loopCode", "LLM", "intellij.ml.llm.core"})
public final class PythonConvertLoopToComprehensionTask
implements TaskNameDescriptor {
    @NotNull
    public static final PythonConvertLoopToComprehensionTask INSTANCE = new PythonConvertLoopToComprehensionTask();
    @NotNull
    private static final TaskName name = new TaskName("python-convert-loop-to-list-comprehension");

    private PythonConvertLoopToComprehensionTask() {
    }

    @NotNull
    public TaskName getName() {
        return name;
    }

    @NotNull
    public final GrazieTaskCall default(@NotNull CodeSnippet loopContext, @NotNull CodeSnippet loopCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)loopContext), (String)"loopContext");
        Intrinsics.checkNotNullParameter((Object)((Object)loopCode), (String)"loopCode");
        return new GrazieTaskCall(this.getName().tag(LLM.Default.INSTANCE.getTag()), TaskParameters.Companion.build(arg_0 -> PythonConvertLoopToComprehensionTask.default$lambda$0(loopContext, loopCode, arg_0)), TaskContext.Companion.getEmpty());
    }

    private static final Unit default$lambda$0(CodeSnippet $loopContext, CodeSnippet $loopCode, TaskParametersBuilder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.add((AttributeDescriptor)LLM.Schema.INSTANCE.getLoopContext(), (Object)$loopContext.toString());
        $this$build.add((AttributeDescriptor)LLM.Schema.INSTANCE.getLoopCode(), (Object)$loopCode.toString());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/python/PythonConvertLoopToComprehensionTask$LLM;", "", "<init>", "()V", "composePrompt", "", "loopContext", "loopCode", "Default", "Schema", "intellij.ml.llm.core"})
    public static final class LLM {
        @NotNull
        public static final LLM INSTANCE = new LLM();

        private LLM() {
        }

        @NotNull
        public final String composePrompt(@NotNull String loopContext, @NotNull String loopCode) {
            Intrinsics.checkNotNullParameter((Object)loopContext, (String)"loopContext");
            Intrinsics.checkNotNullParameter((Object)loopCode, (String)"loopCode");
            return ((Object)StringsKt.trim((CharSequence)("\nReplace loop constructs such as for and while with equivalent comprehensions in the highlighted Python code, preserving the original functionality.\nIf it is impossible to convert, respond with: \"CANNOT, Reason: <reason>\", but keep it one line long.\nYou may use methods such as `sum`, `min`, `functools.reduce`\nReturn only the snippet containing the change.\nFor example:\nA:\n```python\nassert all(n % i == 0 for i in div(n))\n```\nA:\n```\nCANNOT, Reason: This loop cannot be converted because of differing iterator increments between if branches.\n```\nQ:\nSurrounding Context:\n```python\ndef even_fact(n):\n    efact = 1\n    for i in range(10):\n        if i % 2 == 0:\n            efact *= i\n    return efact\n```\nCode to transform:\n```python\nfor i in range(10):\n    if i % 2 == 0:\n        efact *= i\n```\nA:\n```python\nefact *= functools.reduce(operator.mul, i for i in range(10) if i % 2 == 0, 1)\n```\nQ:\nSurrounding Context:\n```python\nresult = []\nfor i in generator()\n    result.append(i.trim())\n```\nCode to transform:\n```python\nfor i in generator():\n    result.append(i.trim())\n```\nA:\n```python\nresult.extend(i.trim() for i in generator())\n```\n===\nQ:\nSurrounding Context: " + loopContext + "\nCode to transform: " + loopCode + "\nA:"))).toString();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/python/PythonConvertLoopToComprehensionTask$LLM$Default;", "Lai/grazie/model/task/id/TaskTagDescriptor$Stable;", "<init>", "()V", "tag", "Lai/grazie/model/task/id/TaskTag;", "getTag", "()Lai/grazie/model/task/id/TaskTag;", "intellij.ml.llm.core"})
        public static final class Default
        implements TaskTagDescriptor.Stable {
            @NotNull
            public static final Default INSTANCE = new Default();

            private Default() {
            }

            @NotNull
            public TaskTag getTag() {
                return new TaskTag("default");
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/python/PythonConvertLoopToComprehensionTask$LLM$Schema;", "Lai/grazie/model/task/id/TaskSchemaDescriptor;", "<init>", "()V", "loopContext", "Lai/grazie/utils/attributes/AttributeDescriptor$Text;", "getLoopContext", "()Lai/grazie/utils/attributes/AttributeDescriptor$Text;", "loopCode", "getLoopCode", "all", "", "getAll", "()Ljava/util/List;", "intellij.ml.llm.core"})
        public static final class Schema
        implements TaskSchemaDescriptor {
            @NotNull
            public static final Schema INSTANCE = new Schema();
            @NotNull
            private static final AttributeDescriptor.Text loopContext = new AttributeDescriptor.Text("loopContext");
            @NotNull
            private static final AttributeDescriptor.Text loopCode = new AttributeDescriptor.Text("loopCode");
            @NotNull
            private static final List<AttributeDescriptor.Text> all;

            private Schema() {
            }

            @NotNull
            public final AttributeDescriptor.Text getLoopContext() {
                return loopContext;
            }

            @NotNull
            public final AttributeDescriptor.Text getLoopCode() {
                return loopCode;
            }

            @NotNull
            public List<AttributeDescriptor.Text> getAll() {
                return all;
            }

            static {
                Object[] objectArray = new AttributeDescriptor.Text[2];
                objectArray[0] = loopContext;
                objectArray[1] = loopCode;
                all = CollectionsKt.listOf((Object[])objectArray);
            }
        }
    }
}

