/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.responseParser;

import com.intellij.ml.llm.responseParser.ResponseParserConstants;
import com.intellij.ml.llm.responseParser.ResponseParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\n\u0018\u0000 \u00182\u00020\u0001:\b\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser;", "", "<init>", "()V", "consume", "", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Event;", "s", "", "finalize", "resetState", "", "delimiters", "Ljava/util/Stack;", "previousLine", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Line;", "currentLine", "previousLineIsRootCodeBlockEnd", "", "configureCurrentLineAsCodeDelimiter", "processCurrentLine", "events", "", "configureCurrentLineTypeIfPossible", "Companion", "Event", "Text", "RootCodeStart", "RootCodeEnd", "NaturalLanguageStart", "LineType", "Line", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nResponseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseParser.kt\ncom/intellij/ml/llm/responseParser/ResponseParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n1#2:477\n2746#3,3:478\n2746#3,3:481\n1761#3,3:484\n*S KotlinDebug\n*F\n+ 1 ResponseParser.kt\ncom/intellij/ml/llm/responseParser/ResponseParser\n*L\n336#1:478,3\n337#1:481,3\n368#1:484,3\n*E\n"})
public final class ResponseParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Stack<String> delimiters = new Stack();
    @NotNull
    private Line previousLine = new Line();
    @NotNull
    private Line currentLine = new Line();

    @NotNull
    public final List<Event> consume(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        List result2 = new ArrayList();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            this.currentLine.getText().append(c);
            if (c != '\n') continue;
            this.processCurrentLine(result2);
            this.previousLine = this.currentLine;
            this.currentLine = new Line();
        }
        this.processCurrentLine(result2);
        return result2;
    }

    @NotNull
    public final List<Event> finalize() {
        if (((CharSequence)this.currentLine.getText()).length() == 0) {
            return CollectionsKt.emptyList();
        }
        String leadingNewline = this.previousLine.endsWithNewline() ? "" : "\n";
        Pair<String, String> pair = this.currentLine.splitByCodeFenceDelimiter();
        String delimitersText = (String)pair.component1();
        String restText = (String)pair.component2();
        if (this.delimiters.size() != 1 || !Intrinsics.areEqual((Object)CollectionsKt.last((List)this.delimiters), (Object)ResponseParser.Companion.isolateDelimiter(delimitersText))) {
            return CollectionsKt.listOf((Object)new Text(leadingNewline + this.currentLine.getText()));
        }
        this.delimiters.pop();
        if (StringsKt.isBlank((CharSequence)restText)) {
            return CollectionsKt.listOf((Object)new RootCodeEnd(leadingNewline + delimitersText + restText));
        }
        Object[] objectArray = new Event[]{new RootCodeEnd(leadingNewline + delimitersText), NaturalLanguageStart.INSTANCE, new Text(restText)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final void resetState() {
        this.delimiters.clear();
        this.previousLine = new Line();
        this.currentLine = new Line();
    }

    private final boolean previousLineIsRootCodeBlockEnd() {
        return this.previousLine.getLineType() == LineType.CodeEnd && this.previousLine.getCodeDepth() == 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void configureCurrentLineAsCodeDelimiter() {
        boolean bl = this.currentLine.endsWithNewline();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.previousLine.getCodeDepth() == 0 || this.previousLineIsRootCodeBlockEnd()) {
            this.currentLine.setLineType(LineType.CodeStart);
            this.currentLine.setCodeDepth(1);
            return;
        }
        boolean bl2 = bl = !((Collection)this.delimiters).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (StringsKt.isBlank((CharSequence)this.currentLine.readLanguageIdentifier())) {
            String string = this.currentLine.getText().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (Intrinsics.areEqual((Object)ResponseParser.Companion.isolateDelimiter(string), (Object)CollectionsKt.last((List)this.delimiters))) {
                this.currentLine.setLineType(LineType.CodeEnd);
                this.currentLine.setCodeDepth(this.delimiters.size());
                return;
            }
        }
        this.currentLine.setLineType(LineType.CodeStart);
        this.currentLine.setCodeDepth(this.previousLine.getCodeDepth() + 1);
    }

    private final void processCurrentLine(List<Event> events) {
        Object event;
        if (this.currentLine.getLineType() == LineType.Unknown) {
            boolean shouldCarryOverNewlineFromPreviousLine;
            this.configureCurrentLineTypeIfPossible();
            if (this.currentLine.getLineType() == LineType.Unknown) {
                return;
            }
            boolean bl = shouldCarryOverNewlineFromPreviousLine = (this.previousLine.getLineType() == LineType.Code && this.previousLine.getCodeDepth() == 1 || this.previousLine.getLineType() == LineType.CodeEnd && this.previousLine.getCodeDepth() > 1) && (this.currentLine.getLineType() != LineType.CodeEnd || this.currentLine.getCodeDepth() > 1);
            if (shouldCarryOverNewlineFromPreviousLine) {
                ResponseParser.processCurrentLine$addPayloadToLastOrNewTextEvent(events, "\n");
            }
            event = switch (WhenMappings.$EnumSwitchMapping$0[this.currentLine.getLineType().ordinal()]) {
                case 1 -> {
                    RootCodeStart v3;
                    if (this.currentLine.getCodeDepth() == 1) {
                        String v1 = this.currentLine.readLanguageIdentifier();
                        String v2 = this.currentLine.getText().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
                        v3 = new RootCodeStart(v1, v2);
                    } else {
                        v3 = null;
                    }
                    yield v3;
                }
                case 2 -> this.previousLine.getLineType() != LineType.NatLang ? NaturalLanguageStart.INSTANCE : null;
                default -> null;
            };
            Event event2 = event;
            if (event2 != null) {
                Event it = event2;
                boolean bl2 = false;
                events.add(it);
            }
        }
        if (!this.currentLine.endsWithNewline()) {
            if (((CharSequence)this.currentLine.getText()).length() == 0) {
                return;
            }
            String string = this.currentLine.getText().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            ResponseParser.processCurrentLine$addPayloadToLastOrNewTextEvent(events, string);
            StringsKt.clear((StringBuilder)this.currentLine.getText());
            return;
        }
        if (this.currentLine.getLineType() == LineType.Code && this.currentLine.getCodeDepth() == 1 || this.currentLine.getLineType() == LineType.CodeEnd && this.currentLine.getCodeDepth() > 1) {
            this.currentLine.getText().deleteCharAt(this.currentLine.getText().length() - 1);
        }
        if (this.currentLine.getLineType() == LineType.NatLang || this.currentLine.getLineType() == LineType.Code || this.currentLine.getCodeDepth() > 1) {
            String string = this.currentLine.getText().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            ResponseParser.processCurrentLine$addPayloadToLastOrNewTextEvent(events, string);
        }
        if (this.currentLine.getLineType() == LineType.CodeStart) {
            String string = this.currentLine.getText().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.delimiters.push(ResponseParser.Companion.isolateDelimiter(string));
        } else if (this.currentLine.getLineType() == LineType.CodeEnd) {
            Object object = CollectionsKt.last((List)this.delimiters);
            String string = this.currentLine.getText().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            boolean bl = Intrinsics.areEqual((Object)object, (Object)ResponseParser.Companion.isolateDelimiter(string));
            if (_Assertions.ENABLED && !bl) {
                event = "Assertion failed";
                throw new AssertionError(event);
            }
            this.delimiters.pop();
            if (this.delimiters.isEmpty()) {
                boolean bl3;
                Pair<String, String> pair = this.currentLine.splitByCodeFenceDelimiter();
                String delimitersText = (String)pair.component1();
                String restText = (String)pair.component2();
                boolean bl4 = bl3 = ((CharSequence)delimitersText).length() > 0;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl5 = false;
                    String string2 = "Delimiters cannot be empty here!";
                    throw new AssertionError((Object)string2);
                }
                events.add(new RootCodeEnd("\n" + delimitersText + "\n"));
                if (!StringsKt.isBlank((CharSequence)restText)) {
                    this.currentLine.getText().replace(0, this.currentLine.getText().length(), delimitersText + "\n");
                    this.previousLine = this.currentLine;
                    this.currentLine = new Line();
                    this.currentLine.getText().append(restText);
                    this.processCurrentLine(events);
                }
            }
        }
    }

    private final void configureCurrentLineTypeIfPossible() {
        boolean bl;
        block28: {
            String it;
            String currentLineText;
            block31: {
                block30: {
                    boolean bl2;
                    block27: {
                        boolean $i$f$none;
                        Iterable $this$none$iv;
                        block29: {
                            boolean bl3;
                            block26: {
                                boolean bl4;
                                boolean bl5 = bl4 = this.currentLine.getLineType() == LineType.Unknown;
                                if (_Assertions.ENABLED && !bl4) {
                                    String string = "Assertion failed";
                                    throw new AssertionError((Object)string);
                                }
                                String string = this.currentLine.getText().toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                currentLineText = ResponseParser.Companion.trimStartKeepNewLine(string);
                                if (currentLineText.length() != 1) break block29;
                                $this$none$iv = ResponseParserConstants.INSTANCE.getMaybeCodeBlockDelimiters1();
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl3 = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        it = (String)element$iv;
                                        boolean bl6 = false;
                                        if (!Intrinsics.areEqual((Object)it, (Object)currentLineText)) continue;
                                        bl3 = false;
                                        break block26;
                                    }
                                    bl3 = true;
                                }
                            }
                            if (bl3) break block30;
                        }
                        if (currentLineText.length() != 2) break block31;
                        $this$none$iv = ResponseParserConstants.INSTANCE.getMaybeCodeBlockDelimiters2();
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (String)element$iv;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)currentLineText)) continue;
                                bl2 = false;
                                break block27;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) break block31;
                }
                LineType currentLineType = switch (WhenMappings.$EnumSwitchMapping$0[this.previousLine.getLineType().ordinal()]) {
                    case 3 -> {
                        if (this.previousLine.getCodeDepth() == 1) {
                            yield LineType.NatLang;
                        }
                        yield LineType.Code;
                    }
                    case 2, 4 -> LineType.NatLang;
                    default -> LineType.Code;
                };
                this.currentLine.setLineType(currentLineType);
                if (this.currentLine.getLineType() == LineType.Code) {
                    this.currentLine.setCodeDepth(this.delimiters.size());
                }
                return;
            }
            if (currentLineText.length() < 3) {
                return;
            }
            Iterable $this$any$iv = ResponseParserConstants.INSTANCE.getCodeBlockDelimiters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl8 = false;
                    if (!StringsKt.startsWith$default((String)currentLineText, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block28;
                }
                bl = false;
            }
        }
        if (bl) {
            if (this.currentLine.endsWithNewline()) {
                this.configureCurrentLineAsCodeDelimiter();
            }
            return;
        }
        if (this.previousLine.getLineType() == LineType.CodeStart) {
            this.currentLine.setLineType(LineType.Code);
            this.currentLine.setCodeDepth(this.previousLine.getCodeDepth());
            return;
        }
        if (this.previousLine.getLineType() == LineType.NatLang || this.previousLine.getLineType() == LineType.Unknown) {
            this.currentLine.setLineType(LineType.NatLang);
            return;
        }
        if (this.previousLineIsRootCodeBlockEnd()) {
            this.currentLine.setLineType(LineType.NatLang);
            return;
        }
        this.currentLine.setLineType(LineType.Code);
        this.currentLine.setCodeDepth(this.delimiters.size());
    }

    private static final void processCurrentLine$addPayloadToLastOrNewTextEvent(List<Event> $events, String payload) {
        Text candidate;
        if (((CharSequence)payload).length() == 0) {
            return;
        }
        Object object = CollectionsKt.lastOrNull($events);
        Text text = candidate = object instanceof Text ? (Text)object : null;
        if (candidate != null) {
            $events.set(CollectionsKt.getLastIndex($events), new Text(candidate.getPayload() + payload));
        } else {
            $events.add(new Text(payload));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$Companion;", "", "<init>", "()V", "isolateDelimiter", "", "s", "trimStartKeepNewLine", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nResponseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseParser.kt\ncom/intellij/ml/llm/responseParser/ResponseParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,476:1\n2746#2,3:477\n648#3,5:480\n413#3,4:485\n*S KotlinDebug\n*F\n+ 1 ResponseParser.kt\ncom/intellij/ml/llm/responseParser/ResponseParser$Companion\n*L\n407#1:477,3\n411#1:480,5\n415#1:485,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String isolateDelimiter(String s) {
            String string;
            char c;
            block9: {
                Character firstChar;
                block11: {
                    block10: {
                        boolean bl;
                        block8: {
                            firstChar = StringsKt.firstOrNull((CharSequence)s);
                            if (firstChar == null) break block10;
                            Iterable $this$none$iv = ResponseParserConstants.INSTANCE.getCodeBlockDelimiterCharacters();
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    char it = ((Character)element$iv).charValue();
                                    boolean bl2 = false;
                                    Character c2 = firstChar;
                                    if (!(c2 != null && it == c2.charValue())) continue;
                                    bl = false;
                                    break block8;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block11;
                    }
                    return "";
                }
                c = firstChar.charValue();
                String $this$takeWhile$iv = StringsKt.drop((String)s, (int)1);
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    Character c3 = firstChar;
                    if (c3 != null && it == c3.charValue()) continue;
                    String string2 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = string2.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block9;
                }
                string = $this$takeWhile$iv;
            }
            String string4 = string;
            return c + string4;
        }

        private final String trimStartKeepNewLine(String $this$trimStartKeepNewLine) {
            String string;
            block1: {
                String $this$dropWhile$iv = $this$trimStartKeepNewLine;
                boolean $i$f$dropWhile = false;
                int n = ((CharSequence)$this$dropWhile$iv).length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$dropWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ' ' || it == '\t') continue;
                    String string2 = $this$dropWhile$iv.substring(index$iv);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    break block1;
                }
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0004\u0002\u0003\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$Event;", "", "Lcom/intellij/ml/llm/responseParser/ResponseParser$NaturalLanguageStart;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$RootCodeEnd;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$RootCodeStart;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Text;", "intellij.ml.llm.core"})
    public static sealed interface Event
    permits NaturalLanguageStart, RootCodeEnd, RootCodeStart, Text {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019J\u0006\u0010\u001b\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$Line;", "", "<init>", "()V", "lineType", "Lcom/intellij/ml/llm/responseParser/ResponseParser$LineType;", "codeDepth", "", "getCodeDepth", "setCodeDepth", "", "i", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getText", "()Ljava/lang/StringBuilder;", "setText", "(Ljava/lang/StringBuilder;)V", "getLineType", "setLineType", "l", "endsWithNewline", "", "splitByCodeFenceDelimiter", "Lkotlin/Pair;", "", "readLanguageIdentifier", "toString", "intellij.ml.llm.core"})
    public static final class Line {
        @NotNull
        private LineType lineType = LineType.Unknown;
        private int codeDepth;
        @NotNull
        private StringBuilder text = new StringBuilder();

        public final int getCodeDepth() {
            return this.codeDepth;
        }

        public final void setCodeDepth(int i) {
            this.codeDepth = i;
        }

        @NotNull
        public final StringBuilder getText() {
            return this.text;
        }

        public final void setText(@NotNull StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
            this.text = stringBuilder;
        }

        @NotNull
        public final LineType getLineType() {
            return this.lineType;
        }

        public final void setLineType(@NotNull LineType l) {
            Intrinsics.checkNotNullParameter((Object)((Object)l), (String)"l");
            this.lineType = l;
        }

        public final boolean endsWithNewline() {
            return StringsKt.endsWith$default((CharSequence)this.text, (CharSequence)"\n", (boolean)false, (int)2, null);
        }

        @NotNull
        public final Pair<String, String> splitByCodeFenceDelimiter() {
            Object object = Regex.find$default((Regex)ResponseParserKt.access$getCodeFenceStartRegex$p(), (CharSequence)this.text, (int)0, (int)2, null);
            if (object == null || (object = object.getValue()) == null) {
                return new Pair((Object)"", (Object)this.text.toString());
            }
            Object delimiters = object;
            return new Pair(delimiters, (Object)this.text.substring(((String)delimiters).length()));
        }

        @NotNull
        public final String readLanguageIdentifier() {
            boolean bl = this.endsWithNewline();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "text = \"" + this.text + "\"";
                throw new AssertionError((Object)string);
            }
            Object object = Regex.find$default((Regex)ResponseParserKt.access$getCodeFenceLineRegex$p(), (CharSequence)this.text, (int)0, (int)2, null);
            if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
                object = "";
            }
            return object;
        }

        @NotNull
        public String toString() {
            return "Line(lineType=" + this.lineType + ", codeDepth=" + this.codeDepth + ", text=" + this.text + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$LineType;", "", "<init>", "(Ljava/lang/String;I)V", "NatLang", "CodeStart", "Code", "CodeEnd", "Unknown", "intellij.ml.llm.core"})
    public static final class LineType
    extends Enum<LineType> {
        public static final /* enum */ LineType NatLang = new LineType();
        public static final /* enum */ LineType CodeStart = new LineType();
        public static final /* enum */ LineType Code = new LineType();
        public static final /* enum */ LineType CodeEnd = new LineType();
        public static final /* enum */ LineType Unknown = new LineType();
        private static final /* synthetic */ LineType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LineType[] values() {
            return (LineType[])$VALUES.clone();
        }

        public static LineType valueOf(String value) {
            return Enum.valueOf(LineType.class, value);
        }

        @NotNull
        public static EnumEntries<LineType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lineTypeArray = new LineType[]{LineType.NatLang, LineType.CodeStart, LineType.Code, LineType.CodeEnd, LineType.Unknown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$NaturalLanguageStart;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Event;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.core"})
    public static final class NaturalLanguageStart
    implements Event {
        @NotNull
        public static final NaturalLanguageStart INSTANCE = new NaturalLanguageStart();

        private NaturalLanguageStart() {
        }

        @NotNull
        public String toString() {
            return "NaturalLanguageStart";
        }

        public int hashCode() {
            return 231156903;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NaturalLanguageStart)) {
                return false;
            }
            NaturalLanguageStart cfr_ignored_0 = (NaturalLanguageStart)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$RootCodeEnd;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Event;", "originalText", "", "<init>", "(Ljava/lang/String;)V", "getOriginalText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.core"})
    public static final class RootCodeEnd
    implements Event {
        @NotNull
        private final String originalText;

        public RootCodeEnd(@NotNull String originalText) {
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            this.originalText = originalText;
        }

        @NotNull
        public final String getOriginalText() {
            return this.originalText;
        }

        @NotNull
        public final String component1() {
            return this.originalText;
        }

        @NotNull
        public final RootCodeEnd copy(@NotNull String originalText) {
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            return new RootCodeEnd(originalText);
        }

        public static /* synthetic */ RootCodeEnd copy$default(RootCodeEnd rootCodeEnd, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = rootCodeEnd.originalText;
            }
            return rootCodeEnd.copy(string);
        }

        @NotNull
        public String toString() {
            return "RootCodeEnd(originalText=" + this.originalText + ")";
        }

        public int hashCode() {
            return this.originalText.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootCodeEnd)) {
                return false;
            }
            RootCodeEnd rootCodeEnd = (RootCodeEnd)other;
            return Intrinsics.areEqual((Object)this.originalText, (Object)rootCodeEnd.originalText);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$RootCodeStart;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Event;", "languageIdentifier", "", "originalText", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getLanguageIdentifier", "()Ljava/lang/String;", "getOriginalText", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.core"})
    public static final class RootCodeStart
    implements Event {
        @NotNull
        private final String languageIdentifier;
        @NotNull
        private final String originalText;

        public RootCodeStart(@NotNull String languageIdentifier, @NotNull String originalText) {
            Intrinsics.checkNotNullParameter((Object)languageIdentifier, (String)"languageIdentifier");
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            this.languageIdentifier = languageIdentifier;
            this.originalText = originalText;
        }

        @NotNull
        public final String getLanguageIdentifier() {
            return this.languageIdentifier;
        }

        @NotNull
        public final String getOriginalText() {
            return this.originalText;
        }

        @NotNull
        public final String component1() {
            return this.languageIdentifier;
        }

        @NotNull
        public final String component2() {
            return this.originalText;
        }

        @NotNull
        public final RootCodeStart copy(@NotNull String languageIdentifier, @NotNull String originalText) {
            Intrinsics.checkNotNullParameter((Object)languageIdentifier, (String)"languageIdentifier");
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            return new RootCodeStart(languageIdentifier, originalText);
        }

        public static /* synthetic */ RootCodeStart copy$default(RootCodeStart rootCodeStart, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = rootCodeStart.languageIdentifier;
            }
            if ((n & 2) != 0) {
                string2 = rootCodeStart.originalText;
            }
            return rootCodeStart.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "RootCodeStart(languageIdentifier=" + this.languageIdentifier + ", originalText=" + this.originalText + ")";
        }

        public int hashCode() {
            int result2 = this.languageIdentifier.hashCode();
            result2 = result2 * 31 + this.originalText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootCodeStart)) {
                return false;
            }
            RootCodeStart rootCodeStart = (RootCodeStart)other;
            if (!Intrinsics.areEqual((Object)this.languageIdentifier, (Object)rootCodeStart.languageIdentifier)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.originalText, (Object)rootCodeStart.originalText);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/responseParser/ResponseParser$Text;", "Lcom/intellij/ml/llm/responseParser/ResponseParser$Event;", "payload", "", "<init>", "(Ljava/lang/String;)V", "getPayload", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.core"})
    public static final class Text
    implements Event {
        @NotNull
        private final String payload;

        public Text(@NotNull String payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            this.payload = payload;
        }

        @NotNull
        public final String getPayload() {
            return this.payload;
        }

        @NotNull
        public final String component1() {
            return this.payload;
        }

        @NotNull
        public final Text copy(@NotNull String payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            return new Text(payload);
        }

        public static /* synthetic */ Text copy$default(Text text, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = text.payload;
            }
            return text.copy(string);
        }

        @NotNull
        public String toString() {
            return "Text(payload=" + this.payload + ")";
        }

        public int hashCode() {
            return this.payload.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Text)) {
                return false;
            }
            Text text = (Text)other;
            return Intrinsics.areEqual((Object)this.payload, (Object)text.payload);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineType.values().length];
            try {
                nArray[LineType.CodeStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.NatLang.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.CodeEnd.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.Unknown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

