/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.file;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/util/file/LLMFileUtil;", "", "<init>", "()V", "newFileOpenedDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onFileClose", "Lkotlin/Function0;", "", "intellij.ml.llm.core"})
public final class LLMFileUtil {
    @NotNull
    public static final LLMFileUtil INSTANCE = new LLMFileUtil();

    private LLMFileUtil() {
    }

    @RequiresEdt
    @NotNull
    public final Disposable newFileOpenedDisposable(@NotNull Project project, @NotNull VirtualFile file, @NotNull Function0<Unit> onFileClose) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(onFileClose, (String)"onFileClose");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable fileOpenedDisposable = disposable;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (!fileEditorManager.isFileOpen(file)) {
            Disposer.dispose((Disposable)fileOpenedDisposable);
            return fileOpenedDisposable;
        }
        FileEditorManagerListener listener2 = new FileEditorManagerListener(file, onFileClose, fileOpenedDisposable){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Function0<Unit> $onFileClose;
            final /* synthetic */ Disposable $fileOpenedDisposable;
            {
                this.$file = $file;
                this.$onFileClose = $onFileClose;
                this.$fileOpenedDisposable = $fileOpenedDisposable;
            }

            public void fileClosed(FileEditorManager source, VirtualFile closedFile) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)closedFile, (String)"closedFile");
                if (Intrinsics.areEqual((Object)closedFile, (Object)this.$file) && !source.isFileOpen(closedFile) && !Intrinsics.areEqual((Object)this.$file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN), (Object)true)) {
                    this.$onFileClose.invoke();
                    Disposer.dispose((Disposable)this.$fileOpenedDisposable, (boolean)false);
                }
            }
        };
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(fileOpenedDisposable);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)listener2);
        return fileOpenedDisposable;
    }

    public static /* synthetic */ Disposable newFileOpenedDisposable$default(LLMFileUtil lLMFileUtil, Project project, VirtualFile virtualFile, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = LLMFileUtil::newFileOpenedDisposable$lambda$0;
        }
        return lLMFileUtil.newFileOpenedDisposable(project, virtualFile, (Function0<Unit>)function0);
    }

    private static final Unit newFileOpenedDisposable$lambda$0() {
        return Unit.INSTANCE;
    }
}

