/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.swing;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.llmInstaller.ui.LLMInstallerUIUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.render.LabelBasedRenderer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aV\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00030\u0001\"\u0004\b\u0000\u0010\u000226\u0010\u0004\u001a2\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00030\u0005\u001a4\u0010\u000b\u001a\u00020\f2,\u0010\r\u001a(\u0012\u0004\u0012\u00020\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\u0002\b\u0012\u001a*\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0014\"\b\b\u0000\u0010\u0002*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a#\u0010\u0013\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0015*\u0002H\u00022\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a8\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014*\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u000f\b\u0002\u0010\u001f\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b 2\b\b\u0002\u0010!\u001a\u00020\"\u001a8\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014*\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u000f\b\u0002\u0010\u001f\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b 2\b\b\u0002\u0010!\u001a\u00020\"\u00a8\u0006$"}, d2={"createCardPanel", "Lcom/intellij/ui/CardLayoutPanel;", "T", "Ljavax/swing/JComponent;", "componentProvider", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "Lcom/intellij/openapi/Disposable;", "disposable", "labelRenderer", "Ljavax/swing/tree/TreeCellRenderer;", "configure", "Ljavax/swing/JLabel;", "Ljavax/swing/tree/TreeNode;", "treeNode", "", "Lkotlin/ExtensionFunctionType;", "defaultStyle", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JButton;", "isDefaultStyle", "", "(Ljavax/swing/JButton;Z)Ljavax/swing/JButton;", "errorWithIcon", "Ljavax/swing/JEditorPane;", "Lcom/intellij/ui/dsl/builder/Row;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "componentAccessibleName", "Lorg/jetbrains/annotations/Nls;", "action", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "errorWithoutIcon", "intellij.ml.llm.core"})
public final class SwingUtilsKt {
    @NotNull
    public static final <T> CardLayoutPanel<T, T, JComponent> createCardPanel(@NotNull Function2<? super T, ? super Disposable, ? extends JComponent> componentProvider) {
        Intrinsics.checkNotNullParameter(componentProvider, (String)"componentProvider");
        return new CardLayoutPanel<T, T, JComponent>(componentProvider){
            private final Map<T, Disposable> disposables;
            final /* synthetic */ Function2<T, Disposable, JComponent> $componentProvider;
            {
                this.$componentProvider = $componentProvider;
                this.disposables = new LinkedHashMap<K, V>();
            }

            protected T prepare(T key) {
                return key;
            }

            protected JComponent create(T key) {
                Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)this));
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disp = disposable;
                this.disposables.put(key, disp);
                return (JComponent)this.$componentProvider.invoke(key, (Object)disp);
            }

            protected void dispose(T key, JComponent value) {
                Disposable disposable = this.disposables.get(key);
                if (disposable == null) {
                    return;
                }
                Disposable disposable2 = disposable;
                Disposer.dispose((Disposable)disposable2);
            }
        };
    }

    @NotNull
    public static final TreeCellRenderer labelRenderer(@NotNull Function2<? super JLabel, ? super TreeNode, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        return (TreeCellRenderer)new LabelBasedRenderer.Tree(configure){
            final /* synthetic */ Function2<JLabel, TreeNode, Unit> $configure;
            {
                this.$configure = $configure;
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
                TreeNode node;
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
                TreeNode treeNode = node = value instanceof TreeNode ? (TreeNode)value : null;
                if (node != null) {
                    this.$configure.invoke((Object)((Object)this), (Object)node);
                }
                return (Component)((Object)this);
            }
        };
    }

    @NotNull
    public static final <T extends JButton> Cell<T> defaultStyle(@NotNull Cell<? extends T> $this$defaultStyle, boolean isDefaultStyle) {
        Intrinsics.checkNotNullParameter($this$defaultStyle, (String)"<this>");
        return $this$defaultStyle.applyToComponent(arg_0 -> SwingUtilsKt.defaultStyle$lambda$0(isDefaultStyle, arg_0));
    }

    public static /* synthetic */ Cell defaultStyle$default(Cell cell, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return SwingUtilsKt.defaultStyle(cell, bl);
    }

    @NotNull
    public static final <T extends JButton> T defaultStyle(@NotNull T $this$defaultStyle, boolean isDefaultStyle) {
        T t;
        Intrinsics.checkNotNullParameter($this$defaultStyle, (String)"<this>");
        T $this$defaultStyle_u24lambda_u241 = t = $this$defaultStyle;
        boolean bl = false;
        ((JComponent)$this$defaultStyle_u24lambda_u241).putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, isDefaultStyle);
        return t;
    }

    public static /* synthetic */ JButton defaultStyle$default(JButton jButton, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return SwingUtilsKt.defaultStyle(jButton, bl);
    }

    @NotNull
    public static final Cell<JEditorPane> errorWithIcon(@NotNull Row $this$errorWithIcon, @NotNull String text, @Nullable String componentAccessibleName, @NotNull HyperlinkEventAction action) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$errorWithIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Icon icon = AllIcons.General.Error;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
        $this$errorWithIcon.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Cell it = cell = LLMInstallerUIUtilKt.patchMinimumSize((Cell)Row.text$default((Row)$this$errorWithIcon, (String)text, (int)0, (HyperlinkEventAction)action, (int)2, null)).applyToComponent(SwingUtilsKt::errorWithIcon$lambda$0);
        boolean bl = false;
        if (componentAccessibleName != null) {
            it.accessibleName(componentAccessibleName);
        }
        return cell;
    }

    public static /* synthetic */ Cell errorWithIcon$default(Row row, String string, String string2, HyperlinkEventAction hyperlinkEventAction, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            hyperlinkEventAction = HyperlinkEventAction.HTML_HYPERLINK_INSTANCE;
        }
        return SwingUtilsKt.errorWithIcon(row, string, string2, hyperlinkEventAction);
    }

    @NotNull
    public static final Cell<JEditorPane> errorWithoutIcon(@NotNull Row $this$errorWithoutIcon, @NotNull String text, @Nullable String componentAccessibleName, @NotNull HyperlinkEventAction action) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$errorWithoutIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Cell it = cell = LLMInstallerUIUtilKt.patchMinimumSize((Cell)Row.text$default((Row)$this$errorWithoutIcon, (String)text, (int)0, (HyperlinkEventAction)action, (int)2, null)).applyToComponent(SwingUtilsKt::errorWithoutIcon$lambda$0);
        boolean bl = false;
        if (componentAccessibleName != null) {
            it.accessibleName(componentAccessibleName);
        }
        return cell;
    }

    public static /* synthetic */ Cell errorWithoutIcon$default(Row row, String string, String string2, HyperlinkEventAction hyperlinkEventAction, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            hyperlinkEventAction = HyperlinkEventAction.HTML_HYPERLINK_INSTANCE;
        }
        return SwingUtilsKt.errorWithoutIcon(row, string, string2, hyperlinkEventAction);
    }

    private static final Unit defaultStyle$lambda$0(boolean $isDefaultStyle, JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        SwingUtilsKt.defaultStyle($this$applyToComponent, $isDefaultStyle);
        return Unit.INSTANCE;
    }

    private static final Unit errorWithIcon$lambda$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground(UIUtil.getErrorForeground());
        return Unit.INSTANCE;
    }

    private static final Unit errorWithoutIcon$lambda$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground(UIUtil.getErrorForeground());
        return Unit.INSTANCE;
    }
}

