/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.AnnotationHelper;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinition;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SubtypeResolver;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jackson.JsonIdentityReferenceDefinitionProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonSubTypesResolver
implements SubtypeResolver,
CustomDefinitionProviderV2 {
    private final CustomDefinition.DefinitionType wrappingSubtypeDefinitionType;
    private final boolean shouldInlineNestedSubtypes;
    private final Optional<JsonIdentityReferenceDefinitionProvider> identityReferenceProvider;

    public JsonSubTypesResolver() {
        this(Collections.emptyList());
    }

    public JsonSubTypesResolver(Collection<JacksonOption> options) {
        this.wrappingSubtypeDefinitionType = options.contains((Object)JacksonOption.ALWAYS_REF_SUBTYPES) ? CustomDefinition.DefinitionType.ALWAYS_REF : CustomDefinition.DefinitionType.STANDARD;
        this.shouldInlineNestedSubtypes = options.contains((Object)JacksonOption.INLINE_TRANSFORMED_SUBTYPES);
        this.identityReferenceProvider = options.contains((Object)JacksonOption.JSONIDENTITY_REFERENCE_ALWAYS_AS_ID) ? Optional.of(new JsonIdentityReferenceDefinitionProvider()) : Optional.empty();
    }

    private boolean skipSubtypeResolution(MemberScope<?, ?> member) {
        return member.getType() == null || this.identityReferenceProvider.flatMap(idRefProvider -> idRefProvider.getIdentityReferenceType(member)).isPresent();
    }

    private boolean skipSubtypeResolution(ResolvedType declaredType, TypeContext context) {
        return this.identityReferenceProvider.flatMap(idRefProvider -> idRefProvider.getIdentityReferenceType(declaredType, context)).isPresent();
    }

    @Override
    public List<ResolvedType> findSubtypes(ResolvedType declaredType, SchemaGenerationContext context) {
        if (this.skipSubtypeResolution(declaredType, context.getTypeContext())) {
            return null;
        }
        JsonSubTypes subtypesAnnotation = AnnotationHelper.resolveAnnotation(declaredType.getErasedType(), JsonSubTypes.class, JacksonModule.NESTED_ANNOTATION_CHECK).orElse(null);
        return this.lookUpSubtypesFromAnnotation(declaredType, subtypesAnnotation, context.getTypeContext());
    }

    public List<ResolvedType> findTargetTypeOverrides(MemberScope<?, ?> property) {
        if (this.skipSubtypeResolution(property)) {
            return null;
        }
        JsonSubTypes subtypesAnnotation = property.getAnnotationConsideringFieldAndGetter(JsonSubTypes.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        return this.lookUpSubtypesFromAnnotation(property.getType(), subtypesAnnotation, property.getContext());
    }

    public List<ResolvedType> lookUpSubtypesFromAnnotation(ResolvedType declaredType, JsonSubTypes subtypesAnnotation, TypeContext context) {
        if (subtypesAnnotation == null) {
            return null;
        }
        return Stream.of(subtypesAnnotation.value()).map(entry -> this.resolveSubtype(declaredType, (JsonSubTypes.Type)entry, context)).collect(Collectors.toList());
    }

    private ResolvedType resolveSubtype(ResolvedType declaredType, JsonSubTypes.Type annotatedSubtype, TypeContext context) {
        try {
            return context.resolveSubtype(declaredType, annotatedSubtype.value());
        }
        catch (IllegalArgumentException ex) {
            return context.resolve(annotatedSubtype.value(), new Type[0]);
        }
    }

    @Override
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        if (javaType == null) {
            return null;
        }
        TypeContext typeContext = context.getTypeContext();
        ResolvedType typeWithTypeInfo = typeContext.getTypeWithAnnotation(javaType, JsonTypeInfo.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        if (typeWithTypeInfo == null || AnnotationHelper.resolveAnnotation(javaType.getErasedType(), JsonSubTypes.class, JacksonModule.NESTED_ANNOTATION_CHECK).isPresent() || this.skipSubtypeResolution(javaType, typeContext)) {
            return null;
        }
        Class<?> erasedTypeWithTypeInfo = typeWithTypeInfo.getErasedType();
        List<Annotation> annotationsList = Arrays.asList(erasedTypeWithTypeInfo.getAnnotations());
        JsonTypeInfo typeInfoAnnotation = typeContext.getAnnotationFromList(JsonTypeInfo.class, annotationsList, JacksonModule.NESTED_ANNOTATION_CHECK);
        JsonSubTypes subTypesAnnotation = typeContext.getAnnotationFromList(JsonSubTypes.class, annotationsList, JacksonModule.NESTED_ANNOTATION_CHECK);
        TypeScope scope = typeContext.createTypeScope(javaType);
        ObjectNode definition = this.createSubtypeDefinition(scope, typeInfoAnnotation, subTypesAnnotation, context);
        if (definition == null) {
            return null;
        }
        return new CustomDefinition(definition, this.wrappingSubtypeDefinitionType, CustomDefinition.AttributeInclusion.NO);
    }

    public CustomPropertyDefinition provideCustomPropertySchemaDefinition(MemberScope<?, ?> scope, SchemaGenerationContext context) {
        if (this.skipSubtypeResolution(scope) || AnnotationHelper.resolveAnnotation(scope.getType().getErasedType(), JsonSubTypes.class, JacksonModule.NESTED_ANNOTATION_CHECK).isPresent()) {
            return null;
        }
        JsonTypeInfo typeInfoAnnotation = scope.getAnnotationConsideringFieldAndGetter(JsonTypeInfo.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        if (typeInfoAnnotation == null) {
            return null;
        }
        if (typeInfoAnnotation.use() == JsonTypeInfo.Id.NONE) {
            ObjectNode definition = context.getGeneratorConfig().createObjectNode();
            definition.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)context.createStandardDefinitionReference(scope.getType(), this));
            return new CustomPropertyDefinition(definition, CustomDefinition.AttributeInclusion.YES);
        }
        JsonSubTypes subTypesAnnotation = scope.getAnnotationConsideringFieldAndGetter(JsonSubTypes.class, JacksonModule.NESTED_ANNOTATION_CHECK);
        ObjectNode definition = this.createSubtypeDefinition(scope, typeInfoAnnotation, subTypesAnnotation, context);
        if (definition == null) {
            return null;
        }
        return new CustomPropertyDefinition(definition, CustomDefinition.AttributeInclusion.NO);
    }

    private String getTypeIdentifier(ResolvedType javaType, JsonTypeInfo typeInfoAnnotation, JsonSubTypes subTypesAnnotation) {
        String typeIdentifier;
        Class<?> erasedTargetType = javaType.getErasedType();
        switch (typeInfoAnnotation.use()) {
            case NAME: {
                typeIdentifier = JsonSubTypesResolver.getNameFromSubTypeAnnotation(erasedTargetType, subTypesAnnotation).orElseGet(() -> JsonSubTypesResolver.getNameFromTypeNameAnnotation(erasedTargetType).orElseGet(() -> JsonSubTypesResolver.getUnqualifiedClassName(erasedTargetType)));
                break;
            }
            case CLASS: {
                typeIdentifier = erasedTargetType.getName();
                break;
            }
            default: {
                typeIdentifier = null;
            }
        }
        return typeIdentifier;
    }

    private static Optional<String> getNameFromSubTypeAnnotation(Class<?> erasedTargetType, JsonSubTypes subTypesAnnotation) {
        if (subTypesAnnotation == null) {
            return Optional.empty();
        }
        return Stream.of(subTypesAnnotation.value()).filter(subTypeAnnotation -> erasedTargetType.equals(subTypeAnnotation.value())).findFirst().map(JsonSubTypes.Type::name).filter(name -> !name.isEmpty());
    }

    private static Optional<String> getNameFromTypeNameAnnotation(Class<?> erasedTargetType) {
        return AnnotationHelper.resolveAnnotation(erasedTargetType, JsonTypeName.class, JacksonModule.NESTED_ANNOTATION_CHECK).map(JsonTypeName::value).filter(name -> !name.isEmpty());
    }

    private static String getUnqualifiedClassName(Class<?> erasedTargetType) {
        Class<?> declaringClass = erasedTargetType.getDeclaringClass();
        if (declaringClass == null) {
            return erasedTargetType.getSimpleName();
        }
        return JsonSubTypesResolver.getUnqualifiedClassName(declaringClass) + '$' + erasedTargetType.getSimpleName();
    }

    private ObjectNode createSubtypeDefinition(TypeScope scope, JsonTypeInfo typeInfoAnnotation, JsonSubTypes subTypesAnnotation, SchemaGenerationContext context) {
        ResolvedType javaType = scope.getType();
        String typeIdentifier = this.getTypeIdentifier(javaType, typeInfoAnnotation, subTypesAnnotation);
        if (typeIdentifier == null) {
            return null;
        }
        ObjectNode attributesToInclude = this.getAttributesToInclude(scope, context);
        ObjectNode definition = context.getGeneratorConfig().createObjectNode();
        SubtypeDefinitionDetails subtypeDetails = new SubtypeDefinitionDetails(javaType, attributesToInclude, context, typeIdentifier, definition);
        switch (typeInfoAnnotation.include()) {
            case WRAPPER_ARRAY: {
                this.createSubtypeDefinitionForWrapperArrayTypeInfo(subtypeDetails);
                break;
            }
            case WRAPPER_OBJECT: {
                this.createSubtypeDefinitionForWrapperObjectTypeInfo(subtypeDetails);
                break;
            }
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                this.createSubtypeDefinitionForPropertyTypeInfo(subtypeDetails, typeInfoAnnotation);
                break;
            }
            default: {
                return null;
            }
        }
        return definition;
    }

    private void createSubtypeDefinitionForWrapperArrayTypeInfo(SubtypeDefinitionDetails details) {
        details.getDefinition().put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_ARRAY));
        ArrayNode itemsArray = details.getDefinition().withArray(details.getKeyword(SchemaKeyword.TAG_PREFIX_ITEMS));
        itemsArray.addObject().put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_STRING)).put(details.getKeyword(SchemaKeyword.TAG_CONST), details.getTypeIdentifier());
        if (details.getAttributesToInclude() == null || details.getAttributesToInclude().isEmpty()) {
            itemsArray.add((JsonNode)this.createNestedSubtypeSchema(details.getJavaType(), details.getContext()));
        } else {
            itemsArray.addObject().withArray(details.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)this.createNestedSubtypeSchema(details.getJavaType(), details.getContext())).add((JsonNode)details.getAttributesToInclude());
        }
    }

    private void createSubtypeDefinitionForWrapperObjectTypeInfo(SubtypeDefinitionDetails details) {
        details.getDefinition().put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT));
        ObjectNode propertiesNode = details.getDefinition().putObject(details.getKeyword(SchemaKeyword.TAG_PROPERTIES));
        ObjectNode nestedSubtypeSchema = this.createNestedSubtypeSchema(details.getJavaType(), details.getContext());
        if (details.getAttributesToInclude() == null || details.getAttributesToInclude().isEmpty()) {
            propertiesNode.set(details.getTypeIdentifier(), (JsonNode)nestedSubtypeSchema);
        } else {
            propertiesNode.putObject(details.getTypeIdentifier()).withArray(details.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)nestedSubtypeSchema).add((JsonNode)details.getAttributesToInclude());
        }
        details.getDefinition().withArray(details.getKeyword(SchemaKeyword.TAG_REQUIRED)).add(details.getTypeIdentifier());
    }

    private void createSubtypeDefinitionForPropertyTypeInfo(SubtypeDefinitionDetails details, JsonTypeInfo typeInfoAnnotation) {
        String propertyName = Optional.ofNullable(typeInfoAnnotation.property()).filter(name -> !name.isEmpty()).orElseGet(() -> typeInfoAnnotation.use().getDefaultPropertyName());
        ObjectNode additionalPart = details.getDefinition().withArray(details.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)this.createNestedSubtypeSchema(details.getJavaType(), details.getContext())).addObject();
        if (details.getAttributesToInclude() != null && !details.getAttributesToInclude().isEmpty()) {
            additionalPart.setAll(details.getAttributesToInclude());
        }
        additionalPart.put(details.getKeyword(SchemaKeyword.TAG_TYPE), details.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT)).putObject(details.getKeyword(SchemaKeyword.TAG_PROPERTIES)).putObject(propertyName).put(details.getKeyword(SchemaKeyword.TAG_CONST), details.getTypeIdentifier());
        if (!details.getJavaType().getErasedType().equals(typeInfoAnnotation.defaultImpl())) {
            additionalPart.withArray(details.getKeyword(SchemaKeyword.TAG_REQUIRED)).add(propertyName);
        }
    }

    private ObjectNode createNestedSubtypeSchema(ResolvedType javaType, SchemaGenerationContext context) {
        if (this.shouldInlineNestedSubtypes) {
            return context.createStandardDefinition(javaType, this);
        }
        return context.createStandardDefinitionReference(javaType, this);
    }

    private ObjectNode getAttributesToInclude(TypeScope scope, SchemaGenerationContext context) {
        Object attributesToInclude = scope instanceof FieldScope ? AttributeCollector.collectFieldAttributes((FieldScope)scope, context) : (scope instanceof MethodScope ? AttributeCollector.collectMethodAttributes((MethodScope)scope, context) : null);
        return attributesToInclude;
    }

    private static class SubtypeDefinitionDetails {
        private final ResolvedType javaType;
        private final ObjectNode attributesToInclude;
        private final SchemaGenerationContext context;
        private final String typeIdentifier;
        private final ObjectNode definition;

        SubtypeDefinitionDetails(ResolvedType javaType, ObjectNode attributesToInclude, SchemaGenerationContext context, String typeIdentifier, ObjectNode definition) {
            this.javaType = javaType;
            this.attributesToInclude = attributesToInclude;
            this.context = context;
            this.typeIdentifier = typeIdentifier;
            this.definition = definition;
        }

        ResolvedType getJavaType() {
            return this.javaType;
        }

        ObjectNode getAttributesToInclude() {
            return this.attributesToInclude;
        }

        SchemaGenerationContext getContext() {
            return this.context;
        }

        String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        ObjectNode getDefinition() {
            return this.definition;
        }

        String getKeyword(SchemaKeyword keyword) {
            return this.context.getKeyword(keyword);
        }
    }
}

