/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestConnControl();

    @Override
    public void process(HttpRequest request2, EntityDetails entity2, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        String method = request2.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (!request2.containsHeader("Connection")) {
            if (request2.containsHeader("Upgrade")) {
                request2.addHeader("Connection", "upgrade");
            } else {
                request2.addHeader("Connection", "keep-alive");
            }
        }
    }
}

