/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.miniAiChat;

import com.intellij.idea.ActionsBundle;
import com.intellij.ml.llm.grazie.ErrorStateDescriptor;
import com.intellij.ml.llm.grazie.GrazieErrorUtilKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.AiaLLMHandler;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.EditingState;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.InProgressState;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.LLMHandler;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MagicButtonController;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniAiChatPopup;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniAiChatStopAction;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniAiChatSubmitAction;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatActionWithRoundedButton;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatBundle;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatController;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatCustomUiPanel;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatErrorState;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatState;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.MiniChatUtils;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.SubmittableState;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.agentOrchestration.AgentLLMHandler;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.uiUtils.SequentialLifetimesWithCurrent;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.uiUtils.UtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\u0018\u0000 u2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001uB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010V\u001a\u000206J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0010J\u000e\u0010Z\u001a\u0002062\u0006\u0010[\u001a\u00020\\J\u001c\u0010]\u001a\u0002062\u0014\u0010^\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010(0_J\u000e\u0010`\u001a\u0002062\u0006\u0010-\u001a\u00020(JF\u0010a\u001a\u0002062\u000b\u0010b\u001a\u00070\u0010\u00a2\u0006\u0002\bc2\u0006\u0010d\u001a\u00020X2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010f2\u0013\b\u0002\u0010g\u001a\r\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u00110h2\b\b\u0002\u0010i\u001a\u00020XJ\"\u0010j\u001a\u0002062\u0006\u0010k\u001a\u00020f2\b\b\u0002\u0010d\u001a\u00020X2\b\b\u0002\u0010i\u001a\u00020XJ\u0006\u0010l\u001a\u000206J\u0006\u0010m\u001a\u000206J\u0010\u0010n\u001a\u0002062\b\u0010o\u001a\u0004\u0018\u00010(J\b\u0010r\u001a\u000206H\u0016J\u0006\u0010s\u001a\u00020\u0019J\u0006\u0010t\u001a\u000206R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\r\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020(0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0013R\"\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0013\"\u0004\b2\u00103R(\u00104\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u000206\u0018\u0001050\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0013\"\u0004\b8\u00103R\u0018\u00109\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00118F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0016\u0010<\u001a\u0004\u0018\u00010=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0016\u0010@\u001a\u0004\u0018\u00010A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020M\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0011\u0010P\u001a\u00020Q\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010T\u001a\u00020M\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010OR\u0011\u0010p\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010*\u00a8\u0006v"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatController;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MagicButtonController;", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatController;", "project", "Lcom/intellij/openapi/project/Project;", "popup", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatPopup;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatPopup;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPopup", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatPopup;", "initialPlaceholder", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getInitialPlaceholder", "()Ljava/util/concurrent/atomic/AtomicReference;", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "sessionLifetimes", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/uiUtils/SequentialLifetimesWithCurrent;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "requestLifetimes", "getRequestLifetimes", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/uiUtils/SequentialLifetimesWithCurrent;", "lifetime", "getLifetime", "llmHandler", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/LLMHandler;", "getLlmHandler", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/LLMHandler;", "setLlmHandler", "(Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/LLMHandler;)V", "initialState", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatState;", "getInitialState", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatState;", "setInitialState", "(Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatState;)V", "state", "getState", "lastPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "getLastPrompt", "setLastPrompt", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "retryAction", "Lkotlin/Function0;", "", "getRetryAction", "setRetryAction", "lastPromptNlsSafe", "getLastPromptNlsSafe", "()Ljava/lang/String;", "defaultAction", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatActionWithRoundedButton;", "getDefaultAction", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatActionWithRoundedButton;", "escAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getEscAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "submitAction", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatSubmitAction;", "getSubmitAction", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatSubmitAction;", "clearAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "getClearAction", "()Lcom/intellij/openapi/project/DumbAwareAction;", "submitPanel", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatCustomUiPanel;", "getSubmitPanel", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniChatCustomUiPanel;", "stopAction", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatStopAction;", "getStopAction", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatStopAction;", "stopPanel", "getStopPanel", "submit", "trySubmit", "", "prompt", "stop", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "changeState", "action", "Lkotlin/Function1;", "setState", "reportError", "message", "Lorg/jetbrains/annotations/Nls;", "allowTryAgain", "throwable", "", "additionalInfo", "", "cleanEverything", "reportException", "t", "clean", "cleanNoResetSession", "changeInitialState", "newInitialState", "properInitialState", "getProperInitialState", "dispose", "getNewRequestLifetime", "resetSession", "Companion", "intellij.ml.llm.minichat"})
public final class MiniAiChatController
implements Disposable,
MagicButtonController,
MiniChatController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MiniAiChatPopup popup;
    @NotNull
    private final AtomicReference<String> initialPlaceholder;
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final SequentialLifetimesWithCurrent sessionLifetimes;
    @NotNull
    private final SequentialLifetimesWithCurrent requestLifetimes;
    @NotNull
    private LLMHandler llmHandler;
    @NotNull
    private MiniChatState initialState;
    @NotNull
    private final AtomicReference<MiniChatState> state;
    @NotNull
    private AtomicReference<PSString> lastPrompt;
    @NotNull
    private AtomicReference<Function0<Unit>> retryAction;
    @NotNull
    private final MiniAiChatSubmitAction submitAction;
    @NotNull
    private final DumbAwareAction clearAction;
    @NotNull
    private final MiniChatCustomUiPanel submitPanel;
    @NotNull
    private final MiniAiChatStopAction stopAction;
    @NotNull
    private final MiniChatCustomUiPanel stopPanel;
    @NotNull
    private static final Key<MiniAiChatController> MINI_AI_CHAT_POPUP;

    public MiniAiChatController(@NotNull Project project, @NotNull MiniAiChatPopup popup) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)popup), (String)"popup");
        this.project = project;
        this.popup = popup;
        this.initialPlaceholder = new AtomicReference<String>(MiniChatUtils.INSTANCE.getInitialPlaceholder());
        this.lifetimeDef = new LifetimeDefinition();
        this.sessionLifetimes = new SequentialLifetimesWithCurrent(this.lifetimeDef.getLifetime());
        this.requestLifetimes = new SequentialLifetimesWithCurrent(this.lifetimeDef.getLifetime());
        this.llmHandler = Registry.Companion.is("llm.riderNext.miniChat.agent.orchestration") ? (LLMHandler)new AgentLLMHandler(this.project, this) : (LLMHandler)new AiaLLMHandler(this.project, this);
        this.initialState = EditingState.INSTANCE;
        this.state = new AtomicReference<EditingState>(EditingState.INSTANCE);
        this.lastPrompt = new AtomicReference<Object>(null);
        this.retryAction = new AtomicReference<Object>(null);
        this.submitAction = new MiniAiChatSubmitAction(this);
        String string = ActionsBundle.message((String)"action.TextComponent.ClearAction.text", (Object[])new Object[0]);
        this.clearAction = new DumbAwareAction(this, string){
            final /* synthetic */ MiniAiChatController this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getPopup().getPromptComponent().getEditorTextField().setText("");
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                String string = this.this$0.getPopup().getPromptComponent().getEditorTextField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                presentation.setEnabledAndVisible(((CharSequence)string).length() > 0);
            }
        };
        this.submitPanel = new MiniChatCustomUiPanel(this){
            private final Component component;
            final /* synthetic */ MiniAiChatController this$0;
            {
                this.this$0 = $receiver;
                this.component = (Component)UtilsKt.createToolbar$default(new BorderLayoutPanel(), CollectionsKt.listOf((Object)((Object)$receiver.getSubmitAction())), null, null, 6, null);
            }

            public Component getComponent() {
                return this.component;
            }

            public MiniChatActionWithRoundedButton getDefaultAction() {
                return this.this$0.getSubmitAction();
            }

            public AnAction getEscAction() {
                return (AnAction)this.this$0.getClearAction();
            }

            public int getDefaultActionPriority() {
                return 100;
            }
        };
        this.stopAction = new MiniAiChatStopAction(this);
        this.stopPanel = new MiniChatCustomUiPanel(this){
            private final Component component;
            final /* synthetic */ MiniAiChatController this$0;
            {
                this.this$0 = $receiver;
                this.component = (Component)UtilsKt.createToolbar$default(new BorderLayoutPanel(), CollectionsKt.listOf((Object)((Object)$receiver.getStopAction())), null, null, 6, null);
            }

            public Component getComponent() {
                return this.component;
            }

            public AnAction getEscAction() {
                return (AnAction)this.this$0.getStopAction();
            }
        };
        Disposer.register((Disposable)this.popup, (Disposable)this);
        Registry.Companion.get("llm.riderNext.miniChat.agent.orchestration").addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.clean();
                this.setLlmHandler(Registry.Companion.is("llm.riderNext.miniChat.agent.orchestration") ? (LLMHandler)new AgentLLMHandler(this.getProject(), this) : (LLMHandler)new AiaLLMHandler(this.getProject(), this));
            }
        }, (Disposable)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final MiniAiChatPopup getPopup() {
        return this.popup;
    }

    @NotNull
    public final AtomicReference<String> getInitialPlaceholder() {
        return this.initialPlaceholder;
    }

    @Override
    @NotNull
    public Lifetime getSessionLifetime() {
        return this.sessionLifetimes.getCurrent();
    }

    @Override
    @NotNull
    public SequentialLifetimesWithCurrent getRequestLifetimes() {
        return this.requestLifetimes;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetimeDef.getLifetime();
    }

    @NotNull
    public final LLMHandler getLlmHandler() {
        return this.llmHandler;
    }

    public final void setLlmHandler(@NotNull LLMHandler lLMHandler) {
        Intrinsics.checkNotNullParameter((Object)lLMHandler, (String)"<set-?>");
        this.llmHandler = lLMHandler;
    }

    @NotNull
    public final MiniChatState getInitialState() {
        return this.initialState;
    }

    public final void setInitialState(@NotNull MiniChatState miniChatState) {
        Intrinsics.checkNotNullParameter((Object)miniChatState, (String)"<set-?>");
        this.initialState = miniChatState;
    }

    @NotNull
    public final AtomicReference<MiniChatState> getState() {
        return this.state;
    }

    @NotNull
    public final AtomicReference<PSString> getLastPrompt() {
        return this.lastPrompt;
    }

    public final void setLastPrompt(@NotNull AtomicReference<PSString> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.lastPrompt = atomicReference;
    }

    @Override
    @NotNull
    public AtomicReference<Function0<Unit>> getRetryAction() {
        return this.retryAction;
    }

    @Override
    public void setRetryAction(@NotNull AtomicReference<Function0<Unit>> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.retryAction = atomicReference;
    }

    @Nullable
    public final String getLastPromptNlsSafe() {
        PSString pSString = this.lastPrompt.get();
        return pSString != null ? (String)pSString.unwrap() : null;
    }

    @Override
    @Nullable
    public MiniChatActionWithRoundedButton getDefaultAction() {
        MiniChatActionWithRoundedButton miniChatActionWithRoundedButton;
        MiniChatActionWithRoundedButton defaultAction2;
        MiniChatActionWithRoundedButton defaultAction1;
        MiniChatCustomUiPanel miniChatCustomUiPanel = this.popup.getPromptComponent().getCustomButtonPanel();
        int priority1 = miniChatCustomUiPanel != null ? miniChatCustomUiPanel.getDefaultActionPriority() : Integer.MIN_VALUE;
        MiniChatCustomUiPanel miniChatCustomUiPanel2 = this.popup.getCustomTopPanel();
        int priority2 = miniChatCustomUiPanel2 != null ? miniChatCustomUiPanel2.getDefaultActionPriority() : Integer.MIN_VALUE;
        MiniChatCustomUiPanel miniChatCustomUiPanel3 = this.popup.getPromptComponent().getCustomButtonPanel();
        MiniChatActionWithRoundedButton miniChatActionWithRoundedButton2 = defaultAction1 = miniChatCustomUiPanel3 != null ? miniChatCustomUiPanel3.getDefaultAction() : null;
        if (Intrinsics.areEqual((Object)((Object)defaultAction1), (Object)((Object)this.submitAction))) {
            String string = this.popup.getPromptComponent().getEditorTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                defaultAction1 = null;
            }
        }
        MiniChatCustomUiPanel miniChatCustomUiPanel4 = this.popup.getCustomTopPanel();
        MiniChatActionWithRoundedButton miniChatActionWithRoundedButton3 = defaultAction2 = miniChatCustomUiPanel4 != null ? miniChatCustomUiPanel4.getDefaultAction() : null;
        if (priority1 > priority2) {
            miniChatActionWithRoundedButton = defaultAction1;
            if (miniChatActionWithRoundedButton == null) {
                miniChatActionWithRoundedButton = defaultAction2;
            }
        } else {
            miniChatActionWithRoundedButton = defaultAction2;
            if (miniChatActionWithRoundedButton == null) {
                miniChatActionWithRoundedButton = defaultAction1;
            }
        }
        return miniChatActionWithRoundedButton;
    }

    @Override
    @Nullable
    public AnAction getEscAction() {
        AnAction anAction;
        AnAction escAction2;
        AnAction escAction1;
        MiniChatCustomUiPanel miniChatCustomUiPanel = this.popup.getPromptComponent().getCustomButtonPanel();
        int priority1 = miniChatCustomUiPanel != null ? miniChatCustomUiPanel.getDefaultActionPriority() : Integer.MIN_VALUE;
        MiniChatCustomUiPanel miniChatCustomUiPanel2 = this.popup.getCustomTopPanel();
        int priority2 = miniChatCustomUiPanel2 != null ? miniChatCustomUiPanel2.getDefaultActionPriority() : Integer.MIN_VALUE;
        MiniChatCustomUiPanel miniChatCustomUiPanel3 = this.popup.getPromptComponent().getCustomButtonPanel();
        Object object = escAction1 = miniChatCustomUiPanel3 != null ? miniChatCustomUiPanel3.getEscAction() : null;
        if (Intrinsics.areEqual((Object)escAction1, (Object)this.clearAction)) {
            String string = this.popup.getPromptComponent().getEditorTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                escAction1 = null;
            }
        }
        MiniChatCustomUiPanel miniChatCustomUiPanel4 = this.popup.getCustomTopPanel();
        Object object2 = escAction2 = miniChatCustomUiPanel4 != null ? miniChatCustomUiPanel4.getEscAction() : null;
        if (priority1 > priority2) {
            anAction = escAction1;
            if (anAction == null) {
                anAction = escAction2;
            }
        } else {
            anAction = escAction2;
            if (anAction == null) {
                anAction = escAction1;
            }
        }
        return anAction;
    }

    @NotNull
    public final MiniAiChatSubmitAction getSubmitAction() {
        return this.submitAction;
    }

    @NotNull
    public final DumbAwareAction getClearAction() {
        return this.clearAction;
    }

    @NotNull
    public final MiniChatCustomUiPanel getSubmitPanel() {
        return this.submitPanel;
    }

    @NotNull
    public final MiniAiChatStopAction getStopAction() {
        return this.stopAction;
    }

    @NotNull
    public final MiniChatCustomUiPanel getStopPanel() {
        return this.stopPanel;
    }

    public final void submit() {
        PSString psText = SharedExtensionsKtKt.getPrivacySafe((TextAccessor)((TextAccessor)this.popup.getPromptComponent().getEditorTextField())).getText();
        if (psText == null || ((CharSequence)psText).length() == 0) {
            return;
        }
        String string = this.popup.getPromptComponent().getEditorTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.popup.updateHistory$intellij_ml_llm_minichat(string);
        this.lastPrompt.set(psText);
        MiniChatState currentState = this.state.get();
        if (currentState instanceof SubmittableState) {
            this.getRetryAction().set(((SubmittableState)currentState).getRetryAction(this, psText));
            ((SubmittableState)currentState).submit(this, psText);
        }
    }

    public final boolean trySubmit(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (!this.state.get().isInitialState()) {
            return false;
        }
        this.popup.getPromptComponent().getEditorTextField().setText(prompt);
        this.submit();
        return true;
    }

    public final void stop(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        MiniChatState currentState = this.state.get();
        if (currentState instanceof InProgressState) {
            ((InProgressState)currentState).cancel(this, dataContext);
            this.getRequestLifetimes().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changeState(@NotNull Function1<? super MiniChatState, ? extends MiniChatState> action) {
        block5: {
            MiniChatState newState;
            MiniChatState $i$a$-synchronized-MiniAiChatController$changeState$newState$22;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            MiniAiChatController miniAiChatController = this;
            synchronized (miniAiChatController) {
                MiniChatState miniChatState;
                MiniChatState newState2;
                boolean $i$a$-synchronized-MiniAiChatController$changeState$newState$22 = false;
                MiniChatState currentState = this.state.get();
                Intrinsics.checkNotNull((Object)currentState);
                MiniChatState miniChatState2 = newState2 = (MiniChatState)action.invoke((Object)currentState);
                if (miniChatState2 != null) {
                    MiniChatState miniChatState3;
                    MiniChatState it = miniChatState3 = miniChatState2;
                    boolean bl = false;
                    this.popup.removeShortcuts$intellij_ml_llm_minichat();
                    this.state.set(newState2);
                    newState2.enterState(this.project, currentState);
                    currentState.leaveState(newState2);
                    miniChatState = miniChatState3;
                } else {
                    miniChatState = null;
                }
                $i$a$-synchronized-MiniAiChatController$changeState$newState$22 = miniChatState;
            }
            MiniChatState miniChatState = newState = $i$a$-synchronized-MiniAiChatController$changeState$newState$22;
            if (miniChatState == null) break block5;
            MiniChatState it = miniChatState;
            boolean bl = false;
            UIUtil.invokeLaterIfNeeded(() -> MiniAiChatController.changeState$lambda$1$0(this, it));
        }
    }

    public final void setState(@NotNull MiniChatState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.changeState((Function1<? super MiniChatState, ? extends MiniChatState>)((Function1)arg_0 -> MiniAiChatController.setState$lambda$0(state, arg_0)));
    }

    public final void reportError(@NotNull String message, boolean allowTryAgain, @Nullable Throwable throwable, @NotNull List<String> additionalInfo, boolean cleanEverything) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(additionalInfo, (String)"additionalInfo");
        this.setState(new MiniChatErrorState(this, message, allowTryAgain, throwable, additionalInfo, cleanEverything));
    }

    public static /* synthetic */ void reportError$default(MiniAiChatController miniAiChatController, String string, boolean bl, Throwable throwable, List list, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        miniAiChatController.reportError(string, bl, throwable, list, bl2);
    }

    public final void reportException(@NotNull Throwable t, boolean allowTryAgain, boolean cleanEverything) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        ErrorStateDescriptor errorDescriptor = GrazieErrorUtilKt.getErrorDescriptor((Throwable)t);
        Object object = errorDescriptor;
        if (object == null || (object = object.getText()) == null) {
            object = MiniChatBundle.message("mini.ai.chat.error.when.generating", new Object[0]);
        }
        this.reportError((String)object, allowTryAgain, t, CollectionsKt.listOf((Object)this.getClass().getSimpleName()), cleanEverything);
    }

    public static /* synthetic */ void reportException$default(MiniAiChatController miniAiChatController, Throwable throwable, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        miniAiChatController.reportException(throwable, bl, bl2);
    }

    public final void clean() {
        this.resetSession();
        this.cleanNoResetSession();
    }

    public final void cleanNoResetSession() {
        this.getRequestLifetimes().next();
        this.setState(this.getProperInitialState());
    }

    public final void changeInitialState(@Nullable MiniChatState newInitialState) {
        MiniChatState miniChatState = newInitialState;
        if (miniChatState == null) {
            miniChatState = EditingState.INSTANCE;
        }
        this.initialState = miniChatState;
        this.changeState((Function1<? super MiniChatState, ? extends MiniChatState>)((Function1)arg_0 -> MiniAiChatController.changeInitialState$lambda$0(this, arg_0)));
    }

    @NotNull
    public final MiniChatState getProperInitialState() {
        boolean bl = this.popup.getHasFocus();
        String string = this.popup.getPromptComponent().getEditorTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        MiniChatState miniChatState = this.initialState.changeFocusOrText(bl, string);
        if (miniChatState == null) {
            miniChatState = this.initialState;
        }
        return miniChatState;
    }

    public void dispose() {
        this.state.get().leaveState(null);
    }

    @NotNull
    public final Lifetime getNewRequestLifetime() {
        this.getRequestLifetimes().next();
        return this.getRequestLifetimes().getCurrent();
    }

    public final void resetSession() {
        this.sessionLifetimes.next();
    }

    private static final void changeState$lambda$1$0(MiniAiChatController this$0, MiniChatState $it) {
        this$0.popup.updateState($it);
    }

    private static final MiniChatState setState$lambda$0(MiniChatState $state, MiniChatState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $state;
    }

    private static final MiniChatState changeInitialState$lambda$0(MiniAiChatController this$0, MiniChatState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isInitialState() ? null : this$0.getProperInitialState();
    }

    static {
        Key key = Key.create((String)(MiniAiChatController.class.getName() + "MINI_AI_CHAT_POPUP"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MINI_AI_CHAT_POPUP = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatController$Companion;", "", "<init>", "()V", "MINI_AI_CHAT_POPUP", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/MiniAiChatController;", "get", "project", "Lcom/intellij/openapi/project/Project;", "showPopup", "", "hidePopup", "", "controller", "canMakeInvisible", "openAndSubmit", "prompt", "", "intellij.ml.llm.minichat"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MiniAiChatController get(@Nullable Project project) {
            Project project2 = project;
            return project2 != null ? (MiniAiChatController)project2.getUserData(MINI_AI_CHAT_POPUP) : null;
        }

        public final boolean showPopup(@Nullable Project project) {
            MiniAiChatController existingController = this.get(project);
            if (existingController != null) {
                if (existingController.getPopup().getWindow() != null) {
                    existingController.getPopup().updatePositionIfNeeded();
                    return false;
                }
                existingController.getPopup().showBalloon();
                return false;
            }
            Project project2 = project;
            if (project2 == null) {
                return false;
            }
            Pair<Balloon, MiniAiChatPopup> pair = MiniAiChatPopup.Companion.show(project2);
            if (pair == null) {
                return false;
            }
            Pair<Balloon, MiniAiChatPopup> pair2 = pair;
            MiniAiChatPopup popup = (MiniAiChatPopup)((Object)pair2.getSecond());
            MiniAiChatController controller = new MiniAiChatController(project, popup);
            popup.setController(controller);
            project.putUserData(MINI_AI_CHAT_POPUP, (Object)controller);
            controller.clean();
            return true;
        }

        public final void hidePopup(@NotNull MiniAiChatController controller, boolean canMakeInvisible) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            controller.getPopup().hide(canMakeInvisible);
            if (!canMakeInvisible) {
                controller.getProject().putUserData(MINI_AI_CHAT_POPUP, null);
                Disposer.dispose((Disposable)controller.getPopup());
            }
        }

        public final boolean openAndSubmit(@NotNull Project project, @NotNull String prompt) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
            if (this.get(project) == null && !this.showPopup(project)) {
                return false;
            }
            MiniAiChatController miniAiChatController = this.get(project);
            Intrinsics.checkNotNull((Object)miniAiChatController);
            return miniAiChatController.trySubmit(prompt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

