/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.ml.llm.inlinePromptDetector.InlinePromptEditorFilter;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingPassFactoryKt;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptMarkupModelListener;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptScopeHolder;
import com.intellij.ml.llm.util.CoroutineScopeKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\r\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000e0\u000e0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"installInlinePromptListenerTo", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "EDITOR_FILTER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptEditorFilter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "IS_LISTENER_SET", "Ljava/util/concurrent/atomic/AtomicBoolean;", "intellij.ml.llm.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nInlinePromptMarkupModelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinePromptMarkupModelListener.kt\ncom/intellij/ml/llm/inlinePromptDetector/InlinePromptMarkupModelListenerKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,146:1\n30#2,2:147\n*S KotlinDebug\n*F\n+ 1 InlinePromptMarkupModelListener.kt\ncom/intellij/ml/llm/inlinePromptDetector/InlinePromptMarkupModelListenerKt\n*L\n35#1:147,2\n*E\n"})
public final class InlinePromptMarkupModelListenerKt {
    @NotNull
    private static final Key<InlinePromptEditorFilter> EDITOR_FILTER_KEY;
    @NotNull
    private static final Key<AtomicBoolean> IS_LISTENER_SET;

    public static final void installInlinePromptListenerTo(@NotNull EditorImpl editor, @NotNull Document document, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = editor.putUserDataIfAbsent(IS_LISTENER_SET, (Object)new AtomicBoolean(false));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"putUserDataIfAbsent(...)");
        AtomicBoolean value = (AtomicBoolean)object;
        if (value.compareAndSet(false, true)) {
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
            Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
            MarkupModelEx markup = (MarkupModelEx)markupModel;
            InlinePromptMarkupModelListener listener = new InlinePromptMarkupModelListener(editor);
            CoroutineScopeKt.disposeWithEditor((Editor)((Editor)editor), (Disposable)((Disposable)listener));
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<InlinePromptScopeHolder> serviceClass$iv = InlinePromptScopeHolder.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            CoroutineScopeKt.attachAsChildTo((Disposable)((Disposable)listener), (CoroutineScope)((InlinePromptScopeHolder)object2).getCs());
            markup.addMarkupModelListener((Disposable)listener, (MarkupModelListener)listener);
            InlinePromptHighlightingPassFactoryKt.getInlinePromptLog().info("InlinePromptListener is installed to editor=" + editor);
        }
    }

    public static final /* synthetic */ Key access$getEDITOR_FILTER_KEY$p() {
        return EDITOR_FILTER_KEY;
    }

    static {
        Key key = Key.create((String)"ai.assistant.inline.prompt.request.editor.filter");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EDITOR_FILTER_KEY = key;
        Key key2 = Key.create((String)"ai.assistant.inline.prompt.request.editor.listener.set");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        IS_LISTENER_SET = key2;
    }
}

