/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.a2ux.extensions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.Part;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.a2ux.api.AgentEvent;
import org.jetbrains.a2ux.api.AskInputResponse;
import org.jetbrains.a2ux.api.InputResponse;
import org.jetbrains.a2ux.api.MarkdownBlockUpdatedEvent;
import org.jetbrains.a2ux.api.TaskRequest;
import org.jetbrains.a2ux.extensions.A2uxBridgeKt;
import org.jetbrains.a2ux.extensions.A2uxEvent;
import org.jetbrains.a2ux.extensions.A2uxTaskRequest;
import org.jetbrains.a2ux.extensions.A2uxTaskState;
import org.jetbrains.a2ux.extensions.JacksonMapperKt;
import org.jetbrains.a2ux.extensions.TaskRequestId;
import org.jetbrains.a2ux.impl.AgentEventToMarkdownKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0010\u001a\u00020\u0011J6\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bJ\f\u0010'\u001a\u00020(*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/a2ux/extensions/A2uxBridge;", "", "<init>", "()V", "METADATA_TASK_NAME", "", "METADATA_RESPONSE_NAME", "METADATA_EVENT_NAME", "sendTaskRequest", "Lio/a2a/spec/SendStreamingMessageRequest;", "taskId", "Lorg/jetbrains/a2ux/extensions/TaskRequestId;", "task", "Lorg/jetbrains/a2ux/api/TaskRequest;", "receiveTaskRequest", "Lorg/jetbrains/a2ux/extensions/A2uxTaskRequest;", "message", "Lio/a2a/spec/MessageSendParams;", "sendInputResponse", "Lio/a2a/spec/SendMessageRequest;", "requestId", "userResponse", "Lorg/jetbrains/a2ux/api/InputResponse;", "receiveInputResponseEvent", "", "sendA2uxEvent", "Lio/a2a/spec/TaskStatusUpdateEvent;", "state", "Lorg/jetbrains/a2ux/extensions/A2uxTaskState;", "event", "Lorg/jetbrains/a2ux/api/AgentEvent;", "timestamp", "Ljava/time/OffsetDateTime;", "messageId", "receiveA2uxEvents", "Lorg/jetbrains/a2ux/extensions/A2uxEvent;", "cancelTaskRequest", "Lio/a2a/spec/CancelTaskRequest;", "taskRequestId", "toProgressEvent", "Lorg/jetbrains/a2ux/api/MarkdownBlockUpdatedEvent;", "a2ux-core"})
@SourceDebugExtension(value={"SMAP\nA2uxBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2uxBridge.kt\norg/jetbrains/a2ux/extensions/A2uxBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n808#2,11:217\n1617#2,9:230\n1869#2:239\n1870#2:243\n1626#2:244\n808#2,11:245\n1563#2:256\n1634#2,2:257\n1636#2:261\n56#3:228\n49#3:229\n56#3:240\n49#3:241\n56#3:259\n49#3:260\n1#4:242\n*S KotlinDebug\n*F\n+ 1 A2uxBridge.kt\norg/jetbrains/a2ux/extensions/A2uxBridge\n*L\n49#1:217,11\n107#1:230,9\n107#1:239\n107#1:243\n107#1:244\n162#1:245,11\n162#1:256\n162#1:257,2\n162#1:261\n57#1:228\n57#1:229\n110#1:240\n110#1:241\n166#1:259\n166#1:260\n107#1:242\n*E\n"})
public final class A2uxBridge {
    @NotNull
    public static final A2uxBridge INSTANCE = new A2uxBridge();
    @NotNull
    public static final String METADATA_TASK_NAME = "a2ux-task";
    @NotNull
    public static final String METADATA_RESPONSE_NAME = "a2ux-response";
    @NotNull
    public static final String METADATA_EVENT_NAME = "a2ux-event";

    private A2uxBridge() {
    }

    @NotNull
    public final SendStreamingMessageRequest sendTaskRequest(@NotNull TaskRequestId taskId, @NotNull TaskRequest task) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        SendStreamingMessageRequest sendStreamingMessageRequest = new SendStreamingMessageRequest.Builder().id(taskId.getId()).params(new MessageSendParams.Builder().message(new Message.Builder().role(Message.Role.USER).taskId(taskId.getId()).parts(CollectionsKt.listOf((Object)new TextPart(task.getRequest(), MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_TASK_NAME, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)task), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))))).build()).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)sendStreamingMessageRequest, (String)"build(...)");
        return sendStreamingMessageRequest;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final A2uxTaskRequest receiveTaskRequest(@NotNull MessageSendParams message) {
        ObjectMapper $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<Part<?>> list = message.message().getParts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParts(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextPart)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TextPart textPart = (TextPart)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (textPart != null) {
            String string = message.message().getTaskId();
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            TaskRequestId taskIdRequestId = new TaskRequestId(string);
            Object eventJson = textPart.getMetadata().get(METADATA_TASK_NAME);
            if (eventJson != null) {
                try {
                    void content$iv;
                    void $this$readValue$iv;
                    $this$filterIsInstanceTo$iv$iv = JacksonMapperKt.getJacksonMapper();
                    String string3 = JacksonMapperKt.getJacksonMapper().writeValueAsString(eventJson);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writeValueAsString(...)");
                    destination$iv$iv = string3;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    return new A2uxTaskRequest(taskIdRequestId, (TaskRequest)$this$readValue$iv.readValue((String)content$iv, (TypeReference)new TypeReference<TaskRequest>(){}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string4 = textPart.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            return new A2uxTaskRequest(taskIdRequestId, new TaskRequest(string4, null));
        }
        return null;
    }

    @NotNull
    public final SendMessageRequest sendInputResponse(@NotNull TaskRequestId requestId, @NotNull InputResponse userResponse) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)userResponse, (String)"userResponse");
        SendMessageRequest sendMessageRequest = new SendMessageRequest.Builder().jsonrpc("2.0").method("message/send").id(requestId.getId()).params(new MessageSendParams.Builder().message(new Message.Builder().role(Message.Role.USER).taskId(requestId.getId()).parts(CollectionsKt.listOf((Object)new TextPart(AgentEventToMarkdownKt.toMarkdown(userResponse), MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_RESPONSE_NAME, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)userResponse), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))))).build()).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)sendMessageRequest, (String)"build(...)");
        return sendMessageRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InputResponse> receiveInputResponseEvent(@NotNull MessageSendParams message) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<Part<?>> list = message.message().getParts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParts(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            block5: {
                block3: {
                    Part it;
                    block4: {
                        String content$iv;
                        void $this$readValue$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        it = (Part)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it instanceof TextPart)) break block3;
                        object = ((TextPart)it).getMetadata().get(METADATA_RESPONSE_NAME);
                        if (object == null) break block4;
                        Object event = object;
                        boolean bl3 = false;
                        ObjectMapper objectMapper = JacksonMapperKt.getJacksonMapper();
                        Intrinsics.checkNotNullExpressionValue((Object)JacksonMapperKt.getJacksonMapper().writeValueAsString(event), (String)"writeValueAsString(...)");
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        InputResponse inputResponse = (InputResponse)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<InputResponse>(){});
                        object = inputResponse;
                        if (inputResponse != null) break block5;
                    }
                    String string = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    object = new AskInputResponse(string, false, ((TextPart)it).getText());
                    break block5;
                }
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TaskStatusUpdateEvent sendA2uxEvent(@NotNull TaskRequestId taskId, @NotNull A2uxTaskState state, @NotNull AgentEvent event, @Nullable OffsetDateTime timestamp, @Nullable String messageId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TaskStatusUpdateEvent.Builder builder = new TaskStatusUpdateEvent.Builder().taskId(taskId.getId()).contextId("project");
        TaskState taskState = A2uxBridgeKt.access$mapTaskState(state);
        Message.Builder builder2 = new Message.Builder().role(Message.Role.AGENT).taskId(taskId.getId()).messageId(messageId);
        String string = AgentEventToMarkdownKt.toMarkdown(event);
        if (string == null) {
            string = "";
        }
        TaskStatusUpdateEvent taskStatusUpdateEvent = builder.status(new TaskStatus(taskState, builder2.parts(CollectionsKt.listOf((Object)new TextPart(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)METADATA_EVENT_NAME, (Object)JacksonMapperKt.getJacksonMapper().readValue(JacksonMapperKt.getJacksonMapper().writeValueAsString((Object)event), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})))))).build(), timestamp)).build();
        Intrinsics.checkNotNullExpressionValue((Object)taskStatusUpdateEvent, (String)"build(...)");
        return taskStatusUpdateEvent;
    }

    public static /* synthetic */ TaskStatusUpdateEvent sendA2uxEvent$default(A2uxBridge a2uxBridge, TaskRequestId taskRequestId, A2uxTaskState a2uxTaskState, AgentEvent agentEvent, OffsetDateTime offsetDateTime, String string, int n, Object object) {
        if ((n & 8) != 0) {
            offsetDateTime = null;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        return a2uxBridge.sendA2uxEvent(taskRequestId, a2uxTaskState, agentEvent, offsetDateTime, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<A2uxEvent> receiveA2uxEvents(@NotNull TaskStatusUpdateEvent event) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<Part<?>> list = event.getStatus().message().getParts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParts(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextPart)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AgentEvent agentEvent;
            void part;
            TextPart textPart = (TextPart)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object eventJson = part.getMetadata().get(METADATA_EVENT_NAME);
            if (eventJson != null) {
                AgentEvent $this$readValue$iv;
                try {
                    String content$iv;
                    ObjectMapper objectMapper = JacksonMapperKt.getJacksonMapper();
                    Intrinsics.checkNotNullExpressionValue((Object)JacksonMapperKt.getJacksonMapper().writeValueAsString(eventJson), (String)"writeValueAsString(...)");
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    $this$readValue$iv = (AgentEvent)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<AgentEvent>(){});
                }
                catch (Exception exception) {
                    String string = part.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    $this$readValue$iv = INSTANCE.toProgressEvent(string);
                }
                agentEvent = $this$readValue$iv;
            } else {
                String string = part.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                agentEvent = INSTANCE.toProgressEvent(string);
            }
            AgentEvent agentEvent2 = agentEvent;
            TaskState taskState = event.getStatus().state();
            Intrinsics.checkNotNull((Object)((Object)taskState));
            A2uxTaskState state = A2uxBridgeKt.access$mapTaskState(taskState);
            collection.add(new A2uxEvent(state, agentEvent2));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final CancelTaskRequest cancelTaskRequest(@NotNull TaskRequestId taskRequestId) {
        Intrinsics.checkNotNullParameter((Object)taskRequestId, (String)"taskRequestId");
        CancelTaskRequest cancelTaskRequest = new CancelTaskRequest.Builder().params(new TaskIdParams(taskRequestId.getId())).build();
        Intrinsics.checkNotNullExpressionValue((Object)cancelTaskRequest, (String)"build(...)");
        return cancelTaskRequest;
    }

    private final MarkdownBlockUpdatedEvent toProgressEvent(String $this$toProgressEvent) {
        return new MarkdownBlockUpdatedEvent(null, null, $this$toProgressEvent, 3, null);
    }
}

