/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core;

import com.intellij.ml.llm.intentions.editor.WriteDocumentationBackgroundTask;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\bf\u0018\u00002\u00020\u0001J>\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H&J\b\u0010\u0010\u001a\u00020\u0003H&J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/core/LLMDocumentationLongLineFormattingSupport;", "", "applyLongLineFormatting", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "emittedText", "", "lineApproximateSymbolsCounter", "updatableDocumentationContext", "Lcom/intellij/ml/llm/intentions/editor/WriteDocumentationBackgroundTask$DocumentationContext;", "rightMargin", "fullSuggestion", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getLongLineFormattingDelimiter", "getLongLineFormattingDelimiterIndentSize", "getLineLengthLimitMultiplier", "", "intellij.ml.llm.chat"})
public interface LLMDocumentationLongLineFormattingSupport {
    default public int applyLongLineFormatting(@NotNull Editor editor, @NotNull String emittedText, int lineApproximateSymbolsCounter, @Nullable WriteDocumentationBackgroundTask.DocumentationContext updatableDocumentationContext, int rightMargin, @NotNull StringBuilder fullSuggestion) {
        int documentationIndentWidth;
        Integer documentationStartOffset;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)emittedText, (String)"emittedText");
        Intrinsics.checkNotNullParameter((Object)fullSuggestion, (String)"fullSuggestion");
        if (StringsKt.contains$default((CharSequence)emittedText, (char)'\n', (boolean)false, (int)2, null)) {
            return 0;
        }
        int newTextMargin = emittedText.length();
        WriteDocumentationBackgroundTask.DocumentationContext documentationContext = updatableDocumentationContext;
        Integer n = documentationStartOffset = documentationContext != null && (documentationContext = documentationContext.getDocumentationRangeMarker()) != null ? Integer.valueOf(documentationContext.getStartOffset()) : null;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            int documentationLine = editor.getDocument().getLineNumber(it);
            v2 = editor.getDocument().getLineEndOffset(documentationLine) - editor.getDocument().getLineStartOffset(documentationLine);
        } else {
            v2 = documentationIndentWidth = 0;
        }
        if ((double)(documentationIndentWidth + lineApproximateSymbolsCounter + newTextMargin) > this.getLineLengthLimitMultiplier() * (double)rightMargin) {
            fullSuggestion.append(this.getLongLineFormattingDelimiter());
            return this.getLongLineFormattingDelimiterIndentSize();
        }
        return lineApproximateSymbolsCounter + newTextMargin;
    }

    @NotNull
    public String getLongLineFormattingDelimiter();

    public int getLongLineFormattingDelimiterIndentSize();

    default public double getLineLengthLimitMultiplier() {
        return 1.5;
    }
}

