/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat;

import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.diff.SuggestRefactoringDefaultInsertStrategy;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/core/chat/LLMSuggestRefactoringSupport;", "", "insertRefactoring", "", "selectionRange", "Lcom/intellij/openapi/util/Segment;", "project", "Lcom/intellij/openapi/project/Project;", "documentToModify", "Lcom/intellij/openapi/editor/Document;", "textToPaste", "Lcom/intellij/ml/llm/privacy/PSString;", "selectionFile", "Lcom/intellij/psi/PsiFile;", "containsWithoutComments", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.ml.llm.chat"})
public interface LLMSuggestRefactoringSupport {
    default public void insertRefactoring(@NotNull Segment selectionRange, @NotNull Project project, @NotNull Document documentToModify, @NotNull PSString textToPaste, @NotNull PsiFile selectionFile) {
        Intrinsics.checkNotNullParameter((Object)selectionRange, (String)"selectionRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)documentToModify, (String)"documentToModify");
        Intrinsics.checkNotNullParameter((Object)textToPaste, (String)"textToPaste");
        Intrinsics.checkNotNullParameter((Object)selectionFile, (String)"selectionFile");
        SuggestRefactoringDefaultInsertStrategy.INSTANCE.replaceSelectedCode(selectionRange, project, documentToModify, textToPaste, selectionFile);
    }

    default public boolean containsWithoutComments(@NotNull Segment $this$containsWithoutComments, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$containsWithoutComments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getTextRange() == null) {
            return false;
        }
        TextRange elementWithoutCommentRange = InlayHintsUtils.INSTANCE.getTextRangeWithoutLeadingCommentsAndWhitespaces(element);
        return $this$containsWithoutComments.getStartOffset() <= elementWithoutCommentRange.getStartOffset() && elementWithoutCommentRange.getEndOffset() <= $this$containsWithoutComments.getEndOffset();
    }
}

