/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.codeSnippet.diff;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/diff/SuggestRefactoringDefaultInsertStrategy;", "", "<init>", "()V", "replaceSelectedCode", "", "selectionRange", "Lcom/intellij/openapi/util/Segment;", "project", "Lcom/intellij/openapi/project/Project;", "documentToModify", "Lcom/intellij/openapi/editor/Document;", "textToPaste", "Lcom/intellij/ml/llm/privacy/PSString;", "selectionFile", "Lcom/intellij/psi/PsiFile;", "intellij.ml.llm.chat"})
public final class SuggestRefactoringDefaultInsertStrategy {
    @NotNull
    public static final SuggestRefactoringDefaultInsertStrategy INSTANCE = new SuggestRefactoringDefaultInsertStrategy();

    private SuggestRefactoringDefaultInsertStrategy() {
    }

    public final void replaceSelectedCode(@NotNull Segment selectionRange, @NotNull Project project, @NotNull Document documentToModify, @NotNull PSString textToPaste, @NotNull PsiFile selectionFile) {
        Intrinsics.checkNotNullParameter((Object)selectionRange, (String)"selectionRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)documentToModify, (String)"documentToModify");
        Intrinsics.checkNotNullParameter((Object)textToPaste, (String)"textToPaste");
        Intrinsics.checkNotNullParameter((Object)selectionFile, (String)"selectionFile");
        if (selectionRange.getEndOffset() > documentToModify.getTextLength() && documentToModify.getTextLength() != 0) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).run(() -> SuggestRefactoringDefaultInsertStrategy.replaceSelectedCode$lambda$0(documentToModify, textToPaste, selectionRange, project, selectionFile));
    }

    private static final void replaceSelectedCode$lambda$0(Document $documentToModify, PSString $textToPaste, Segment $selectionRange, Project $project, PsiFile $selectionFile) {
        if ($documentToModify.getTextLength() == 0) {
            $documentToModify.insertString(0, (CharSequence)$textToPaste);
        } else {
            $documentToModify.replaceString($selectionRange.getStartOffset(), $selectionRange.getEndOffset(), (CharSequence)$textToPaste);
        }
        PsiDocumentManager.getInstance((Project)$project).commitDocument($documentToModify);
        TextRange reformatRange = new TextRange($selectionRange.getStartOffset(), $selectionRange.getStartOffset() + $textToPaste.length());
        CodeStyleManager.getInstance((Project)$project).reformatText($selectionFile, (Collection)CollectionsKt.listOf((Object)reformatRange));
    }
}

