/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.codeSnippet.find;

import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.Alignment;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.Edit;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.EditType;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.LevenshteinStringAligner;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.find.RabinKarpStringMatcher;
import com.intellij.ml.llm.privacy.PSString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002ABB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0016\u0010\"\u001a\u00020\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0016\u0010)\u001a\u00020\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\f\u0010*\u001a\u00020+*\u00020+H\u0002J\u001e\u0010,\u001a\u00020\u00062\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010.2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000f2\u0006\u00103\u001a\u00020+H\u0002J\u0010\u00104\u001a\u00020\u00062\u0006\u00103\u001a\u00020+H\u0002J\u0018\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0010H\u0002J\b\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u000200H\u0002J2\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00103\u001a\u00020+2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002020\u000fH\u0002J\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00100?R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher;", "", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "snippet", "restoreComments", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Z)V", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "getSnippet", "getRestoreComments", "()Z", "origLines1", "", "", "origLines2", "lines1", "lines2", "nestingLevel1", "", "nestingLevel2", "priceForInLineMatch", "", "priceForInLineMismatch", "priceForTotalLineMismatch", "priceBan", "priceForLineMismatch", "lineLengthFactor", "length", "", "getIndentation", "line", "calculateNesting", "lines", "isNestingIncreased", "symbol", "", "isNestingDecreased", "isUnchangedComment", "skipChange", "trim", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/Alignment;", "isValidRange", "collection", "", "range", "Lkotlin/ranges/IntRange;", "revertSkippedComments", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/Edit;", "alignment", "skipAlignment", "isTotallyDifferent", "string1", "string2", "findBestMatchingSubstrings", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher$MatchingResult;", "getIndentDelta", "range1", "range2", "edits", "modifyText", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher$SnippetApplicationResult;", "SnippetApplicationResult", "MatchingResult", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantLinesMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantLinesMatcher.kt\ncom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n1563#2:303\n1634#2,3:304\n1563#2:307\n1634#2,3:308\n2746#2,3:311\n1761#2,3:314\n1740#2,3:317\n1869#2,2:320\n1869#2,2:322\n1740#2,3:324\n1068#2:327\n1068#2:328\n1563#2:329\n1634#2,3:330\n*S KotlinDebug\n*F\n+ 1 AIAssistantLinesMatcher.kt\ncom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher\n*L\n9#1:303\n9#1:304,3\n10#1:307\n10#1:308,3\n73#1:311,3\n73#1:314,3\n109#1:317,3\n206#1:320,2\n209#1:322,2\n256#1:324,3\n262#1:327\n278#1:328\n281#1:329\n281#1:330,3\n*E\n"})
public final class AIAssistantLinesMatcher {
    @NotNull
    private final PSString text;
    @NotNull
    private final PSString snippet;
    private final boolean restoreComments;
    @NotNull
    private final List<String> origLines1;
    @NotNull
    private final List<String> origLines2;
    @NotNull
    private final List<String> lines1;
    @NotNull
    private final List<String> lines2;
    @NotNull
    private final int[] nestingLevel1;
    @NotNull
    private final int[] nestingLevel2;
    private final double priceForInLineMatch;
    private final double priceForInLineMismatch;
    private final double priceForTotalLineMismatch;
    private final double priceBan;
    private final double priceForLineMismatch;

    public AIAssistantLinesMatcher(@NotNull PSString text2, @NotNull PSString snippet, boolean restoreComments) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        this.text = text2;
        this.snippet = snippet;
        this.restoreComments = restoreComments;
        Object object = new String[]{"\n"};
        this.origLines1 = StringsKt.split$default((CharSequence)this.text.unwrap(), (String[])object, (boolean)false, (int)0, (int)6, null);
        object = new String[]{"\n"};
        this.origLines2 = StringsKt.split$default((CharSequence)this.snippet.unwrap(), (String[])object, (boolean)false, (int)0, (int)6, null);
        object = this.origLines1;
        AIAssistantLinesMatcher aIAssistantLinesMatcher = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        aIAssistantLinesMatcher.lines1 = (List)destination$iv$iv;
        $this$map$iv = this.origLines2;
        aIAssistantLinesMatcher = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        aIAssistantLinesMatcher.lines2 = (List)destination$iv$iv;
        this.nestingLevel1 = this.calculateNesting(this.lines1);
        this.nestingLevel2 = this.calculateNesting(this.lines2);
        this.priceForInLineMatch = 1.0;
        this.priceForInLineMismatch = -0.6;
        this.priceForTotalLineMismatch = -2.0;
        this.priceBan = -100.0;
        this.priceForLineMismatch = -0.1;
    }

    public /* synthetic */ AIAssistantLinesMatcher(PSString pSString, PSString pSString2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(pSString, pSString2, bl);
    }

    @NotNull
    public final PSString getText() {
        return this.text;
    }

    @NotNull
    public final PSString getSnippet() {
        return this.snippet;
    }

    public final boolean getRestoreComments() {
        return this.restoreComments;
    }

    private final double lineLengthFactor(int length) {
        return 0.2 + Math.min((double)length / 30.0, 3.0);
    }

    private final int getIndentation(String line) {
        int spacesCnt = 0;
        int n = ((CharSequence)line).length();
        for (int i = 0; i < n && line.charAt(i) == ' '; ++i) {
            ++spacesCnt;
        }
        return spacesCnt;
    }

    private final int[] calculateNesting(List<String> lines) {
        int nesting;
        int[] nestingLevel = new int[lines.size() + 1];
        nestingLevel[0] = nesting = 0;
        Iterator iterator = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String line = (String)iterator.next();
            int n2 = line.length();
            for (int j = 0; j < n2; ++j) {
                char c = line.charAt(j);
                if (this.isNestingIncreased(c)) {
                    ++nesting;
                }
                if (!this.isNestingDecreased(c)) continue;
                --nesting;
            }
            nestingLevel[i + 1] = nesting;
        }
        return nestingLevel;
    }

    private final boolean isNestingIncreased(char symbol) {
        return symbol == '{' || symbol == '(';
    }

    private final boolean isNestingDecreased(char symbol) {
        return symbol == '}' || symbol == ')';
    }

    private final boolean isUnchangedComment(String line) {
        return Intrinsics.areEqual((Object)line, (Object)"...") || (StringsKt.startsWith$default((String)line, (String)"//", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"/*", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null)) && StringsKt.contains$default((CharSequence)line, (CharSequence)"unchanged", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean skipChange(List<String> lines) {
        String it;
        boolean bl;
        Iterable $this$none$iv = lines;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                it = (String)element$iv;
                boolean bl2 = false;
                Character c = StringsKt.firstOrNull((CharSequence)it);
                if (!(c != null ? Character.isJavaIdentifierPart(c.charValue()) : false)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        Iterable $this$any$iv = lines;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl3 = false;
        } while (!this.isUnchangedComment(it));
        return true;
    }

    private final Alignment trim(Alignment $this$trim) {
        return this.isValidRange((Collection<? extends Object>)this.lines2, $this$trim.getRange2()) && this.isUnchangedComment(this.lines2.get($this$trim.getRange2().getFirst())) ? this.trim(new Alignment($this$trim.getPrice(), $this$trim.getRange1(), new IntRange($this$trim.getRange2().getFirst() + 1, $this$trim.getRange2().getLast()), CollectionsKt.emptyList())) : (this.isValidRange((Collection<? extends Object>)this.lines2, $this$trim.getRange2()) && this.isUnchangedComment(this.lines2.get($this$trim.getRange2().getLast())) ? this.trim(new Alignment($this$trim.getPrice(), $this$trim.getRange1(), new IntRange($this$trim.getRange2().getFirst(), $this$trim.getRange2().getLast() - 1), CollectionsKt.emptyList())) : $this$trim);
    }

    private final boolean isValidRange(Collection<? extends Object> collection, IntRange range) {
        return range.getFirst() >= 0 && range.getLast() < collection.size() && range.getFirst() <= range.getLast();
    }

    private final List<Edit> revertSkippedComments(Alignment alignment) {
        if (!this.restoreComments) {
            return CollectionsKt.emptyList();
        }
        List restoredComments = new ArrayList();
        for (Edit edit : alignment.getEdits()) {
            int start2;
            if (edit.getEditType() != EditType.Delete) continue;
            int end = edit.getRange1().getEndExclusive();
            for (start2 = edit.getRange1().getStart().intValue(); start2 < this.lines1.size() && ((CharSequence)this.lines1.get(start2)).length() == 0; ++start2) {
            }
            while (end > 0 && ((CharSequence)this.lines1.get(end - 1)).length() == 0) {
                --end;
            }
            if (start2 < end) {
                boolean bl;
                block8: {
                    Iterable $this$all$iv = (Iterable)RangesKt.until((int)start2, (int)end);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl2 = false;
                            if (StringsKt.startsWith$default((String)this.lines1.get(it), (String)"//", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.lines1.get(it), (String)"#", (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (!bl && (!StringsKt.startsWith$default((String)this.lines1.get(start2), (String)"/*", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)this.lines1.get(end - 1), (String)"*/", (boolean)false, (int)2, null))) continue;
            }
            ((Collection)restoredComments).add(edit);
        }
        return restoredComments;
    }

    private final boolean skipAlignment(Alignment alignment) {
        IntRange range1 = alignment.getRange1();
        IntRange range2 = alignment.getRange2();
        int skipStart = 0;
        int skipEnd = 0;
        while (range1.getStart() + skipStart < range1.getEndExclusive() - skipEnd && range2.getStart() + skipStart < range2.getEndExclusive() - skipEnd) {
            if (Intrinsics.areEqual((Object)this.lines1.get(range1.getStart() + skipStart), (Object)this.lines2.get(range2.getStart() + skipStart))) {
                ++skipStart;
                continue;
            }
            if (!Intrinsics.areEqual((Object)this.lines1.get(range1.getEndInclusive() - skipEnd), (Object)this.lines2.get(range2.getEndInclusive() - skipEnd))) break;
            ++skipEnd;
        }
        List<String> subLines1 = this.lines1.subList(range1.getStart() + skipStart, range1.getEndExclusive() - skipEnd);
        List<String> subLines2 = this.lines2.subList(range2.getStart() + skipStart, range2.getEndExclusive() - skipEnd);
        return this.skipChange(subLines1) || this.skipChange(subLines2);
    }

    private final boolean isTotallyDifferent(String string1, String string2) {
        return !RabinKarpStringMatcher.INSTANCE.haveCommonSubstring(string1, string2, (string1.length() + string2.length()) / 10);
    }

    private final MatchingResult findBestMatchingSubstrings() {
        Object object;
        Alignment alignment;
        Object object2;
        int n;
        int n2;
        int n3;
        int n4 = this.lines1.size();
        boolean[][] blArrayArray = new boolean[n4][];
        for (int i = 0; i < n4; ++i) {
            int n5 = i;
            n3 = 0;
            n2 = this.lines2.size();
            boolean[] blArray = new boolean[n2];
            n = n5;
            object2 = blArrayArray;
            while (n3 < n2) {
                int n6 = n3++;
                blArray[n6] = this.isTotallyDifferent(this.lines1.get(n5), this.lines2.get(n6));
            }
            object2[n] = blArray;
        }
        boolean[][] totallyDifferent = blArrayArray;
        int n7 = this.lines1.size();
        Double[][] doubleArrayArray = new Double[n7][];
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = n4;
            int n8 = this.lines2.size();
            Double[] doubleArray = new Double[n8];
            n = n3;
            object2 = doubleArrayArray;
            for (n2 = 0; n2 < n8; ++n2) {
                double d;
                int n9 = n2;
                if (totallyDifferent[n3][n9]) {
                    d = 0.0;
                } else {
                    String str1 = this.lines1.get(n3);
                    String str2 = this.lines2.get(n9);
                    d = LevenshteinStringAligner.INSTANCE.alignStrings(str1.length(), str2.length(), (Function2<? super Integer, ? super Integer, Double>)((Function2)(arg_0, arg_1) -> AIAssistantLinesMatcher.findBestMatchingSubstrings$lambda$0(str1, str2, this, arg_0, arg_1)), (Function1<? super IntRange, Boolean>)((Function1)AIAssistantLinesMatcher::findBestMatchingSubstrings$lambda$1), (Function1<? super IntRange, Boolean>)((Function1)AIAssistantLinesMatcher::findBestMatchingSubstrings$lambda$2), this.priceForInLineMismatch, this.priceForInLineMismatch, false).getPrice();
                }
                doubleArray[n9] = d;
            }
            object2[n] = (boolean[])doubleArray;
        }
        Double[][] prices = doubleArrayArray;
        int n10 = this.lines1.size();
        Double[][] doubleArray = new Double[n10][];
        for (n7 = 0; n7 < n10; ++n7) {
            n2 = n7;
            int n11 = 0;
            int n12 = this.lines2.size();
            Double[] doubleArray2 = new Double[n12];
            n = n2;
            object2 = doubleArray;
            while (n11 < n12) {
                int str1 = n11++;
                doubleArray2[str1] = 0.0;
            }
            object2[n] = (boolean[])doubleArray2;
        }
        Double[][] pricesNormalized = doubleArray;
        n10 = ((Collection)this.lines1).size();
        for (int i = 0; i < n10; ++i) {
            n2 = ((Collection)this.lines2).size();
            for (int j = 0; j < n2; ++j) {
                int length = this.lines1.get(i).length() + this.lines2.get(j).length();
                pricesNormalized[i][j] = totallyDifferent[i][j] ? this.priceForTotalLineMismatch : (length == 0 ? 0.0 : prices[i][j] * (double)2 * this.lineLengthFactor(length) / (double)length);
            }
        }
        List alignments = new ArrayList();
        Map takenLines1 = new LinkedHashMap();
        Map takenLines2 = new LinkedHashMap();
        Map indentDeltas = new LinkedHashMap();
        Map restoredComments = new LinkedHashMap();
        while (!((alignment = LevenshteinStringAligner.INSTANCE.alignStrings(this.lines1.size(), this.lines2.size(), (Function2<? super Integer, ? super Integer, Double>)((Function2)(arg_0, arg_1) -> AIAssistantLinesMatcher.findBestMatchingSubstrings$lambda$3(takenLines1, takenLines2, this, pricesNormalized, arg_0, arg_1)), (Function1<? super IntRange, Boolean>)((Function1)arg_0 -> AIAssistantLinesMatcher.findBestMatchingSubstrings$lambda$4(this, arg_0)), (Function1<? super IntRange, Boolean>)((Function1)arg_0 -> AIAssistantLinesMatcher.findBestMatchingSubstrings$lambda$5(this, arg_0)), this.priceForLineMismatch, this.priceForLineMismatch, true)).getPrice() < 1.0)) {
            int it;
            int element$iv;
            Alignment $this$findBestMatchingSubstrings_u24lambda_u246 = alignment;
            boolean bl = false;
            if (!this.skipAlignment(alignment)) {
                restoredComments.put(alignment, this.revertSkippedComments(alignment));
                ((Collection)alignments).add(this.trim(alignment));
            }
            Iterable $this$forEach$iv = (Iterable)$this$findBestMatchingSubstrings_u24lambda_u246.getRange1();
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                it = element$iv = ((IntIterator)object).nextInt();
                boolean bl2 = false;
                takenLines1.put(it, alignment);
            }
            $this$forEach$iv = (Iterable)$this$findBestMatchingSubstrings_u24lambda_u246.getRange2();
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                it = element$iv = ((IntIterator)object).nextInt();
                boolean bl3 = false;
                takenLines2.put(it, alignment);
            }
            indentDeltas.put(alignment, this.getIndentDelta(alignment.getRange1(), alignment.getRange2()));
        }
        int firstNotTaken = -1;
        Alignment prevAlignment = null;
        int i = 0;
        int n13 = this.lines2.size();
        if (i <= n13) {
            while (true) {
                if (i < this.lines2.size() && takenLines2.get(i) == null) {
                    if (firstNotTaken == -1) {
                        firstNotTaken = i;
                    }
                } else {
                    if (i > 0 && takenLines2.get(i - 1) == null) {
                        if (prevAlignment != null) {
                            Alignment alignment2 = this.trim(new Alignment(0.0, RangesKt.until((int)prevAlignment.getRange1().getEndExclusive(), (int)prevAlignment.getRange1().getEndExclusive()), RangesKt.until((int)firstNotTaken, (int)i), CollectionsKt.emptyList()));
                            ((Collection)alignments).add(alignment2);
                            object = indentDeltas;
                            Intrinsics.checkNotNull(indentDeltas.get(prevAlignment));
                            object.put(alignment2, var15_48);
                        } else if (i < this.lines2.size()) {
                            Object v = takenLines2.get(i);
                            Intrinsics.checkNotNull(v);
                            Alignment curAlignment = (Alignment)v;
                            Alignment alignment3 = this.trim(new Alignment(0.0, RangesKt.until((int)curAlignment.getRange1().getStart(), (int)curAlignment.getRange1().getStart()), RangesKt.until((int)firstNotTaken, (int)i), CollectionsKt.emptyList()));
                            ((Collection)alignments).add(alignment3);
                            var15_48 = indentDeltas;
                            Integer n14 = this.getIndentDelta(curAlignment.getRange1(), RangesKt.until((int)firstNotTaken, (int)curAlignment.getRange2().getEndExclusive()));
                            var15_48.put((Alignment)alignment3, (Integer)n14);
                            var15_48 = indentDeltas;
                            Object v2 = indentDeltas.get(alignment3);
                            Intrinsics.checkNotNull(v2);
                            n14 = v2;
                            var15_48.put(curAlignment, n14);
                        }
                    }
                    if (i < this.lines2.size()) {
                        prevAlignment = (Alignment)takenLines2.get(i);
                    }
                    firstNotTaken = -1;
                }
                if (i == n13) break;
                ++i;
            }
        }
        return new MatchingResult(alignments, indentDeltas, restoredComments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getIndentDelta(IntRange range1, IntRange range2) {
        int indent2;
        int indent1 = this.getIndentation(this.origLines1.get(range1.getFirst()));
        if (indent1 < (indent2 = this.getIndentation(this.origLines2.get(range2.getFirst())))) {
            boolean bl;
            Iterable $this$all$iv = (Iterable)range2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(((CharSequence)this.origLines2.get(it)).length() == 0)) {
                        if (this.getIndentation(this.origLines2.get(it)) < indent1) return 0;
                    }
                    boolean bl3 = true;
                    if (bl3) continue;
                    return 0;
                }
                bl = true;
            }
            if (!bl) return 0;
        }
        int n = indent1 - indent2;
        return n;
    }

    private final List<String> restoreComments(Alignment alignment, List<String> lines2, List<Edit> edits) {
        List curLines = lines2;
        Iterable $this$sortedByDescending$iv = edits;
        boolean $i$f$sortedByDescending = false;
        for (Edit edit : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Edit it = (Edit)b;
                boolean bl = false;
                Comparable comparable = it.getRange1().getStart();
                it = (Edit)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getRange1().getStart());
            }
        })) {
            curLines = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)curLines.subList(0, edit.getRange2().getStart() - alignment.getRange2().getStart()), (Iterable)this.origLines1.subList(edit.getRange1().getStart(), edit.getRange1().getEndExclusive())), (Iterable)curLines.subList(edit.getRange2().getStart() - alignment.getRange2().getStart(), curLines.size()));
        }
        return curLines;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<SnippetApplicationResult, String> modifyText() {
        List curLines = this.origLines1;
        MatchingResult matchingResult = this.findBestMatchingSubstrings();
        List<Alignment> alignments = matchingResult.component1();
        Map<Alignment, Integer> indentDeltas = matchingResult.component2();
        Map<Alignment, List<Edit>> restoredComments = matchingResult.component3();
        if (alignments.isEmpty()) {
            return TuplesKt.to((Object)((Object)SnippetApplicationResult.NotFound), (Object)"");
        }
        Iterable $this$sortedByDescending$iv = alignments;
        boolean $i$f$sortedByDescending = false;
        for (Alignment alignment : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Alignment it = (Alignment)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRange1().getFirst());
                it = (Alignment)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange1().getFirst()));
            }
        })) {
            void $this$mapTo$iv$iv;
            if (alignment.getRange2().getFirst() >= alignment.getRange2().getEndExclusive()) continue;
            Integer n = indentDeltas.get(alignment);
            Intrinsics.checkNotNull((Object)n);
            int indentDelta = ((Number)n).intValue();
            Iterable $this$map$iv = this.origLines2.subList(alignment.getRange2().getFirst(), alignment.getRange2().getEndExclusive());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (indentDelta >= 0) {
                    object = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)indentDelta)), (CharSequence)"", null, null, (int)0, null, AIAssistantLinesMatcher::modifyText$lambda$1$0, (int)30, null) + (String)it;
                } else if (-indentDelta <= it.length()) {
                    String string2 = it.substring(-indentDelta);
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    object = it;
                }
                collection.add(object);
            }
            List substitution = (List)destination$iv$iv;
            Collection collection = curLines.subList(0, alignment.getRange1().getFirst());
            List list = restoredComments.get(alignment);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            curLines = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)this.restoreComments(alignment, substitution, list)), (Iterable)curLines.subList(alignment.getRange1().getEndExclusive(), curLines.size()));
        }
        String result2 = CollectionsKt.joinToString$default((Iterable)curLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return Intrinsics.areEqual((Object)result2, (Object)this.text.unwrap()) ? TuplesKt.to((Object)((Object)SnippetApplicationResult.NotChanged), (Object)result2) : TuplesKt.to((Object)((Object)SnippetApplicationResult.Applied), (Object)result2);
    }

    private static final double findBestMatchingSubstrings$lambda$0(String $str1, String $str2, AIAssistantLinesMatcher this$0, int i, int j) {
        return $str1.charAt(i) == $str2.charAt(j) ? this$0.priceForInLineMatch : this$0.priceForInLineMismatch;
    }

    private static final boolean findBestMatchingSubstrings$lambda$1(IntRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean findBestMatchingSubstrings$lambda$2(IntRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final double findBestMatchingSubstrings$lambda$3(Map $takenLines1, Map $takenLines2, AIAssistantLinesMatcher this$0, Double[][] $pricesNormalized, int i, int j) {
        return $takenLines1.containsKey(i) || $takenLines2.containsKey(j) ? this$0.priceBan : $pricesNormalized[i][j];
    }

    private static final boolean findBestMatchingSubstrings$lambda$4(AIAssistantLinesMatcher this$0, IntRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.nestingLevel1[it.getStart()] == this$0.nestingLevel1[it.getEndExclusive()];
    }

    private static final boolean findBestMatchingSubstrings$lambda$5(AIAssistantLinesMatcher this$0, IntRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.nestingLevel2[it.getStart()] == this$0.nestingLevel2[it.getEndExclusive()];
    }

    private static final CharSequence modifyText$lambda$1$0(int it) {
        return " ";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u001b\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0006H\u00c6\u0003JK\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher$MatchingResult;", "", "alignments", "", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/Alignment;", "indentDeltas", "", "", "restoredComments", "Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/Edit;", "<init>", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "getAlignments", "()Ljava/util/List;", "getIndentDeltas", "()Ljava/util/Map;", "getRestoredComments", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.chat"})
    private static final class MatchingResult {
        @NotNull
        private final List<Alignment> alignments;
        @NotNull
        private final Map<Alignment, Integer> indentDeltas;
        @NotNull
        private final Map<Alignment, List<Edit>> restoredComments;

        public MatchingResult(@NotNull List<Alignment> alignments, @NotNull Map<Alignment, Integer> indentDeltas, @NotNull Map<Alignment, ? extends List<Edit>> restoredComments) {
            Intrinsics.checkNotNullParameter(alignments, (String)"alignments");
            Intrinsics.checkNotNullParameter(indentDeltas, (String)"indentDeltas");
            Intrinsics.checkNotNullParameter(restoredComments, (String)"restoredComments");
            this.alignments = alignments;
            this.indentDeltas = indentDeltas;
            this.restoredComments = restoredComments;
        }

        @NotNull
        public final List<Alignment> getAlignments() {
            return this.alignments;
        }

        @NotNull
        public final Map<Alignment, Integer> getIndentDeltas() {
            return this.indentDeltas;
        }

        @NotNull
        public final Map<Alignment, List<Edit>> getRestoredComments() {
            return this.restoredComments;
        }

        @NotNull
        public final List<Alignment> component1() {
            return this.alignments;
        }

        @NotNull
        public final Map<Alignment, Integer> component2() {
            return this.indentDeltas;
        }

        @NotNull
        public final Map<Alignment, List<Edit>> component3() {
            return this.restoredComments;
        }

        @NotNull
        public final MatchingResult copy(@NotNull List<Alignment> alignments, @NotNull Map<Alignment, Integer> indentDeltas, @NotNull Map<Alignment, ? extends List<Edit>> restoredComments) {
            Intrinsics.checkNotNullParameter(alignments, (String)"alignments");
            Intrinsics.checkNotNullParameter(indentDeltas, (String)"indentDeltas");
            Intrinsics.checkNotNullParameter(restoredComments, (String)"restoredComments");
            return new MatchingResult(alignments, indentDeltas, restoredComments);
        }

        public static /* synthetic */ MatchingResult copy$default(MatchingResult matchingResult, List list, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                list = matchingResult.alignments;
            }
            if ((n & 2) != 0) {
                map2 = matchingResult.indentDeltas;
            }
            if ((n & 4) != 0) {
                map3 = matchingResult.restoredComments;
            }
            return matchingResult.copy(list, map2, map3);
        }

        @NotNull
        public String toString() {
            return "MatchingResult(alignments=" + this.alignments + ", indentDeltas=" + this.indentDeltas + ", restoredComments=" + this.restoredComments + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.alignments).hashCode();
            result2 = result2 * 31 + ((Object)this.indentDeltas).hashCode();
            result2 = result2 * 31 + ((Object)this.restoredComments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchingResult)) {
                return false;
            }
            MatchingResult matchingResult = (MatchingResult)other;
            if (!Intrinsics.areEqual(this.alignments, matchingResult.alignments)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.indentDeltas, matchingResult.indentDeltas)) {
                return false;
            }
            return Intrinsics.areEqual(this.restoredComments, matchingResult.restoredComments);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/AIAssistantLinesMatcher$SnippetApplicationResult;", "", "<init>", "(Ljava/lang/String;I)V", "Applied", "NotChanged", "NotFound", "intellij.ml.llm.chat"})
    public static final class SnippetApplicationResult
    extends Enum<SnippetApplicationResult> {
        public static final /* enum */ SnippetApplicationResult Applied = new SnippetApplicationResult();
        public static final /* enum */ SnippetApplicationResult NotChanged = new SnippetApplicationResult();
        public static final /* enum */ SnippetApplicationResult NotFound = new SnippetApplicationResult();
        private static final /* synthetic */ SnippetApplicationResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SnippetApplicationResult[] values() {
            return (SnippetApplicationResult[])$VALUES.clone();
        }

        public static SnippetApplicationResult valueOf(String value) {
            return Enum.valueOf(SnippetApplicationResult.class, value);
        }

        @NotNull
        public static EnumEntries<SnippetApplicationResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = snippetApplicationResultArray = new SnippetApplicationResult[]{SnippetApplicationResult.Applied, SnippetApplicationResult.NotChanged, SnippetApplicationResult.NotFound};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

