/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.providers;

import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.llm.entity.LlmBehaviourChatContext;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.context.ChatRetrievalSession;
import com.intellij.ml.llm.core.chat.context.DumbAwareChatContextProvider;
import com.intellij.ml.llm.core.chat.context.providers.CodeSnippetContextProviderKt;
import com.intellij.ml.llm.core.chat.parts.SnippetFileNamePartKt;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskContext;
import com.intellij.ml.llm.grazie.tasks.context.TaskContextProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/context/providers/CodeSnippetContextProvider;", "Lcom/intellij/ml/llm/core/chat/context/DumbAwareChatContextProvider;", "Lcom/intellij/ml/llm/context/llm/entity/LlmBehaviourChatContext;", "Lcom/intellij/ml/llm/grazie/tasks/context/TaskContextProvider;", "<init>", "()V", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "collectTaskContext", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskContext;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collect", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "fuzzyDiffPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "originalPrompt", "intellij.ml.llm.chat"})
public final class CodeSnippetContextProvider
implements DumbAwareChatContextProvider,
LlmBehaviourChatContext,
TaskContextProvider {
    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull ChatSession chatSession2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        return Registry.Companion.is("llm.chat.tag.snippets.with.file.names") && chatSession2.getRetrievalSession() instanceof ChatRetrievalSession;
    }

    @Override
    @Nullable
    public Object collectTaskContext(@NotNull Project project, @NotNull ChatSession chatSession2, @NotNull Continuation<? super PrivacySafeTaskContext> $completion) {
        return PrivacySafeTaskContext.Companion.getEmpty();
    }

    @Override
    @Nullable
    public Object collect(@NotNull Project project, @NotNull ChatSession chatSession2, @NotNull Continuation<? super List<ChatContextItem>> $completion) {
        PSString prompt2 = CodeSnippetContextProviderKt.access$useFuzzyDiffPrompt() ? this.fuzzyDiffPrompt() : this.originalPrompt();
        String string = Reflection.getOrCreateKotlinClass(CodeSnippetContextProvider.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return CollectionsKt.listOf((Object)new ChatContextItem(string, prompt2, null, 4, null));
    }

    private final PSString fuzzyDiffPrompt() {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{CodeSnippetContextProviderKt.getCODE_SNIPPET_EXISTING_CODE_MARKER()};
        PSString c = ConstantsKt.getPrivacyConst((String)"// %s").format(pSStringConvertibleArray);
        PSStringConvertible[] pSStringConvertibleArray2 = new PSStringConvertible[]{CodeSnippetContextProviderKt.getCODE_SNIPPET_EXISTING_CODE_MARKER()};
        PSString cPy = ConstantsKt.getPrivacyConst((String)"# %s").format(pSStringConvertibleArray2);
        pSStringConvertibleArray2 = new PSStringConvertible[]{SnippetFileNamePartKt.getSNIPPET_NAME_START(), SnippetFileNamePartKt.getSNIPPET_NAME_END(), c, c, c, c, c, c, cPy, cPy};
        return ConstantsKt.getPrivacyConst((String)"\n      |--- Code Edits Instructions ---\n      |When suggesting edits for existing source files,\n      |prepend the markdown snippet with the modification with the line mentioning the file name.\n      |Don't add extra empty lines before or after. \n      |If the snippet is not a modification of the existing file, don't add this line/tag.\n      |Example:\n      |%sfilename.java%s\n      |```java\n      |...\n      |```\n      |This tag will be later hidden from the user, so it shouldn't affect the rest of the response (for example, don't assume that the user sees it).\n      |Prefer grouping all edits for a file in a single snippet, but if there are multiple - add the tag before EACH snippet.\n      |NEVER add the tag inside the snippet (inside the markdown code block), ALWAYS add it before the snippet.\n      |\n      |Snippets with edits must show the changed lines with minimal surrounding unchanged lines for context.\n      |Use comments like `%s` to indicate where original, unmodified code is skipped. Each change must be shown sequentially, separated by `%s`.\n      |ALWAYS include enough context to make the edit unambiguous. At least, you should add 3 lines BEFORE and AFTER `%s`.\n      |Do not omit any span of code without explicitly marking it with `%s`.\n      |NEVER use diff-style markers (\"+ line\"/\"- line\").\n      |\n      |Example 1:\n      |original file:\n      |```java\n      |class A {\n      |  public void x() {\n      |    a();\n      |    a();\n      |  }\n      |  public void y() {\n      |    b();\n      |    b();\n      |  }\n      |}\n      |```\n      |Snippet to insert a new method between x() and y() should look like this:\n      |```java\n      |%s\n      |    a();\n      |    a();\n      |  }\n      |  public void z() {\n      |    c();\n      |  }\n      |  public void y() {\n      |    b();\n      |    b();\n      |%s\n      |```\n      |\n      |Example 2:\n      |original file:\n      |```python\n      |\n      |def a():\n      |    print(\"a\")\n      |\n      |def b():\n      |    print(\"b\")\n      |\n      |def c():\n      |    print(\"c\")\n      |\n      |def d():\n      |    print(\"d\")\n      |\n      |def e():\n      |    print(\"d\")\n      |```\n      |Snippet to remove method c() from it should look like this:\n      |```python\n      |%s\n      |\n      |def b():\n      |    print(\"b\")\n      |\n      |def d():\n      |    print(\"d\")\n      |\n      |%s\n      |```\n      |--- End of Code Edit Instructions ---\n   ").format(pSStringConvertibleArray2).trimMargin();
    }

    private final PSString originalPrompt() {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{SnippetFileNamePartKt.getSNIPPET_NAME_START(), SnippetFileNamePartKt.getSNIPPET_NAME_END()};
        return ConstantsKt.getPrivacyConst((String)"If you reply with a Markdown snippet that represents a modification of one of the existing files,\n").plus(ConstantsKt.getPrivacyConst((String)"prepend it with the line mentioning the file name. Don't add extra empty lines before or after. \n")).plus(ConstantsKt.getPrivacyConst((String)"If the snippet is not a modification of the existing file, don't add this line/tag.\n")).plus(ConstantsKt.getPrivacyConst((String)"Example:\n")).plus(ConstantsKt.getPrivacyConst((String)"%sfilename.java%s\n").format(pSStringConvertibleArray)).plus(ConstantsKt.getPrivacyConst((String)"```java\n")).plus(ConstantsKt.getPrivacyConst((String)"...\n")).plus(ConstantsKt.getPrivacyConst((String)"This line will be later hidden from the user, so it shouldn't affect the rest of the response (for example, don't assume that the user sees it)"));
    }
}

