/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.providers;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CustomSystemPromptAttachment;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.context.DumbAwareChatContextProvider;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.IncludedPrivacySafeTaskContextBuilder;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskContext;
import com.intellij.ml.llm.grazie.tasks.context.IJ;
import com.intellij.ml.llm.grazie.tasks.context.TaskContextProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/chat/context/providers/CustomProjectPromptContextProvider;", "Lcom/intellij/ml/llm/core/chat/context/DumbAwareChatContextProvider;", "Lcom/intellij/ml/llm/grazie/tasks/context/TaskContextProvider;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "collect", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectTaskContext", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskContext;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCustomProjectPromptContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomProjectPromptContextProvider.kt\ncom/intellij/ml/llm/core/chat/context/providers/CustomProjectPromptContextProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,39:1\n183#2,2:40\n*S KotlinDebug\n*F\n+ 1 CustomProjectPromptContextProvider.kt\ncom/intellij/ml/llm/core/chat/context/providers/CustomProjectPromptContextProvider\n*L\n22#1:40,2\n*E\n"})
public final class CustomProjectPromptContextProvider
implements DumbAwareChatContextProvider,
TaskContextProvider {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull ChatSession chatSession2) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
            Sequence sequence = SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)chatSession2.getMessages()), CustomProjectPromptContextProvider::isApplicable$lambda$0), CustomProjectPromptContextProvider::isApplicable$lambda$1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChatAttachment attachment = (ChatAttachment)element$iv;
                boolean bl = false;
                if (!(attachment instanceof CustomSystemPromptAttachment)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((ChatAttachment)v0 == null) {
            return false;
        }
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project).findPrompt("AIAssistant.General.ProjectPrompt");
        if (aISystemLibraryPrompt == null) {
            return false;
        }
        AISystemLibraryPrompt usersSystemPrompt = aISystemLibraryPrompt;
        return ((CharSequence)usersSystemPrompt.getContent()).length() > 0;
    }

    @Override
    @Nullable
    public Object collect(@NotNull Project project, @NotNull ChatSession chatSession2, @NotNull Continuation<? super List<ChatContextItem>> $completion) {
        AISystemLibraryPrompt aISystemLibraryPrompt;
        block4: {
            block3: {
                aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project).findPrompt("AIAssistant.General.ProjectPrompt");
                if (aISystemLibraryPrompt == null) break block3;
                AISystemLibraryPrompt it = aISystemLibraryPrompt;
                boolean bl = false;
                PSString pSString = ((CharSequence)it.getContent()).length() == 0 ? null : it.getContent();
                aISystemLibraryPrompt = pSString;
                if (pSString != null) break block4;
            }
            return CollectionsKt.emptyList();
        }
        AISystemLibraryPrompt usersCustomSystemPrompt = aISystemLibraryPrompt;
        String string = Reflection.getOrCreateKotlinClass(CustomProjectPromptContextProvider.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        String qualifiedName = string;
        return CollectionsKt.listOf((Object)new ChatContextItem(qualifiedName, (PSString)usersCustomSystemPrompt, null, 4, null));
    }

    @Override
    @Nullable
    public Object collectTaskContext(@NotNull Project project, @NotNull ChatSession chatSession2, @NotNull Continuation<? super PrivacySafeTaskContext> $completion) {
        return new IncludedPrivacySafeTaskContextBuilder(IJ.IncludedContext.INSTANCE.getCustomUsersContext(), this.isApplicable(project, chatSession2)).build();
    }

    private static final boolean isApplicable$lambda$0(ChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return message.getAuthor() == ChatMessageAuthor.User;
    }

    private static final Iterable isApplicable$lambda$1(ChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return message.getAttachments();
    }
}

