/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.retrievers;

import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextPostProcessor;
import com.intellij.ml.llm.context.ContextRetrievalRequest;
import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.context.ide.entity.PsiElementContextEntity;
import com.intellij.ml.llm.core.chat.context.retrievers.ChatInitializedContextRequest;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u00112\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/context/retrievers/ChatInitializedContextTransformer;", "Lcom/intellij/ml/llm/context/ContextPostProcessor;", "session", "Lcom/intellij/ml/llm/context/RetrievalSession;", "<init>", "(Lcom/intellij/ml/llm/context/RetrievalSession;)V", "getSession", "()Lcom/intellij/ml/llm/context/RetrievalSession;", "priority", "", "isApplicable", "", "request", "Lcom/intellij/ml/llm/context/ContextRetrievalRequest;", "process", "", "Lcom/intellij/ml/llm/context/ContextEntity;", "Lcom/intellij/ml/llm/context/ContextEntities;", "items", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transform", "item", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatInitializedContextTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInitializedContextTransformer.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/ChatInitializedContextTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1617#2,9:45\n1869#2:54\n1870#2:56\n1626#2:57\n1#3:55\n*S KotlinDebug\n*F\n+ 1 ChatInitializedContextTransformer.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/ChatInitializedContextTransformer\n*L\n30#1:45,9\n30#1:54\n30#1:56\n30#1:57\n30#1:55\n*E\n"})
public final class ChatInitializedContextTransformer
implements ContextPostProcessor {
    @NotNull
    private final RetrievalSession session;

    public ChatInitializedContextTransformer(@NotNull RetrievalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public final RetrievalSession getSession() {
        return this.session;
    }

    public int priority() {
        return 20;
    }

    public boolean isApplicable(@NotNull ContextRetrievalRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request instanceof ChatInitializedContextRequest;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object process(@NotNull ContextRetrievalRequest request, @NotNull Iterable<? extends ContextEntity> items, @NotNull Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl = this.isApplicable(request);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable<? extends ContextEntity> $this$mapNotNull$iv = items;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends ContextEntity> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ContextEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            ContextEntity p0 = (ContextEntity)element$iv$iv;
            boolean bl3 = false;
            if (this.transform(p0) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final ContextEntity transform(ContextEntity item) {
        ContextEntity contextEntity;
        if (item instanceof PsiElementContextEntity) {
            PsiElement psiElement = ((PsiElementContextEntity)item).getPsiElement();
            if (psiElement != null && (psiElement = psiElement.getContainingFile()) != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                Project project = this.session.getProject();
                VirtualFile virtualFile2 = it.getViewProvider().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                contextEntity = new FileContextAttachment(project, virtualFile2, ContextAttachmentSource.ReferencesRetriever.INSTANCE, null, 8, null);
            } else {
                contextEntity = item;
            }
        } else {
            contextEntity = item;
        }
        return contextEntity;
    }
}

