/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.uiPicker.projectView;

import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ml.llm.core.chat.context.uiPicker.PSTreeParser;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/projectView/ProjectViewAttachmentUtil;", "", "<init>", "()V", "ATTACHMENT_NAME", "Lcom/intellij/ml/llm/privacy/PSString;", "getATTACHMENT_NAME", "()Lcom/intellij/ml/llm/privacy/PSString;", "getAttachmentContent", "projectViewAsText", "findProjectViewTree", "Lcom/intellij/ide/projectView/impl/ProjectViewTree;", "component", "Ljava/awt/Component;", "getPrivacySafeText", "project", "Lcom/intellij/openapi/project/Project;", "tree", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/projectView/impl/ProjectViewTree;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getProjectStructure", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chat"})
public final class ProjectViewAttachmentUtil {
    @NotNull
    public static final ProjectViewAttachmentUtil INSTANCE = new ProjectViewAttachmentUtil();
    @NotNull
    private static final PSString ATTACHMENT_NAME = ConstantsKt.getPrivacyConst((String)"Project View");

    private ProjectViewAttachmentUtil() {
    }

    @NotNull
    public final PSString getATTACHMENT_NAME() {
        return ATTACHMENT_NAME;
    }

    @NotNull
    public final PSString getAttachmentContent(@NotNull PSString projectViewAsText) {
        Intrinsics.checkNotNullParameter((Object)projectViewAsText, (String)"projectViewAsText");
        return ConstantsKt.getPrivacyConst((String)"Project View content:\n```\n").plus(projectViewAsText).plus(ConstantsKt.getPrivacyConst((String)"```"));
    }

    @Nullable
    public final ProjectViewTree findProjectViewTree(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (component instanceof ProjectViewTree) {
            return (ProjectViewTree)component;
        }
        Container container = component instanceof Container ? (Container)component : null;
        if (container == null) {
            return null;
        }
        Container container2 = container;
        Component[] componentArray = container2.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component child : componentArray) {
            ProjectViewTree found;
            if (child instanceof ProjectViewTree) {
                return (ProjectViewTree)child;
            }
            if (!(child instanceof Container) || (found = this.findProjectViewTree(child)) == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public final Object getPrivacySafeText(@NotNull Project project, @NotNull ProjectViewTree tree, @NotNull Continuation<? super PSString> $completion) {
        return new PSTreeParser(project, (JTree)tree).getPSString($completion);
    }

    @Nullable
    public final Object getProjectStructure(@NotNull Project project, @NotNull Continuation<? super PSString> $completion) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Project");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow tw = toolWindow;
        JComponent jComponent = tw.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        ProjectViewTree projectViewTree = this.findProjectViewTree(jComponent);
        if (projectViewTree == null) {
            return null;
        }
        ProjectViewTree tree = projectViewTree;
        return this.getPrivacySafeText(project, tree, $completion);
    }
}

